// Copyright 2023 TigRig All rights reserved.

tyrano.plugin.kag.tag.nazolang_choice = {
    vital: ["id", "text"],
    pm: {
        x: 270,
        y: 0,
        width: 645,
        storage: null,
        target: null,
        graphic: "",
        size_ruby: 24,
        size: 36,
        enterimg: "",
        clickse: "mysterious.ogg",
        enterse: "",
        // 謎言語ID（空白区切りで複数指定、例: "T001 T002 T009" など）
        id: "",
        // 謎言語テキスト（空白区切りで複数指定、例: "plafono muro test" など）
        text: "",
    },
    start(pm) {
        const tmp = TYRANO.kag.tmp;

        tmp.nazolang_choice_glink_number = tmp.nazolang_choice_glink_number || 1;

        const glink_name = `nazolang_choice_glink_${tmp.nazolang_choice_glink_number++}`;

        // glink の実行
        const glink_pm = {
            name: glink_name,
            graphic: pm.graphic,
            size: pm.size_ruby,
            x: pm.x,
            y: pm.y,
            width: pm.width,
            storage: pm.storage,
            target: pm.target,
            enterimg: pm.enterimg,
            clickse: pm.clickse,
            enterse: pm.enterse,
        };
        // ※ glink 内で nextOrder しているため、以後 nextOrder の実行は不要
        TYRANO.kag.ftag.startTag("glink", glink_pm);

        // 謎言語のレイアウトを生成
        const $nazolang_choice = this.create_nazolang_choice(pm.id, pm.text);
        $nazolang_choice.css({
            "grid-template-rows": `${pm.size_ruby}px ${pm.size}px`,
        });
        $nazolang_choice.find(".nazolang").css({
            "font-size": `${pm.size}px`,
        });

        // ※ glink の生成後に create_nazolang_choice を行うのが正しいため、理想は callback で行いたい
        //    しかし上記 startTag で callback を使うと、以後 nextOrder のたびに呼び出されてしまうため却下
        //    → もし動作の中で「glink の中身が空っぽになる」という不具合が生じた場合、ここが原因の可能性が高い

        // glink 内に謎言語を append
        $(`.${glink_name}`).append($nazolang_choice);

        // 謎言語の閲覧フラグを更新
        this.enable_nazolang_displayed_flag(pm.id);
    },
    /**
     * 謎言語の選択肢UIレイアウトを生成
     * @param {string[]} nazolang_ids 謎言語ID（空白区切りのID文字列、例: "T001 T002 T009" など）
     * @param {string[]} nazolang_texts 謎言語テキスト（空白区切りのアルファベット文字列、例: "test t test", "hoge fuga piyo" など）
     * @returns 謎言語の選択肢UIレイアウトのコンテナ div
     */
    create_nazolang_choice(nazolang_ids, nazolang_texts) {
        const nazolang_id_arr = nazolang_ids.split(" ");
        const nazolang_text_arr = nazolang_texts.split(" ");

        if (nazolang_id_arr.length !== nazolang_text_arr.length) {
            TYRANO.kag.error(
                'タグ「nazolang_choice」のパラメータ id と text の値数が異なります。\nid="T001 T002" text="plafono muro" のように id と text の空白区切り値数を一致させてください。 ',
            );
            return "";
        }

        const nazolang_body_elements = nazolang_text_arr.map((text, index) => {
            const id = nazolang_id_arr[index];
            const nazolang_ruby_element = `<span class="nazolang_ruby" data="${id}">${TYRANO.kag.variable.sf[id] || ""}</span>`;

            const nazolang_element = `<span class="nazolang">${text}</span>`;

            return nazolang_ruby_element + nazolang_element;
        });

        return $("<div></div>")
            .addClass("nazolang_choice")
            .attr("id", `nazolang_choice_${TYRANO.kag.tmp.nazolang_choice_glink_number}`)
            .append(nazolang_body_elements.join(""));
    },
    /**
     * 謎言語IDを受け取り、対象の謎言語の閲覧フラグをONにする
     * @param {string[]} nazolang_ids 謎言語ID（空白区切りのID文字列、例: "T001 T002 T009" など）
     */
    enable_nazolang_displayed_flag(nazolang_ids) {
        const nazolang_id_arr = nazolang_ids.split(" ");
        nazolang_id_arr.forEach((id) => {
            TYRANO.kag.variable.sf[id.replace("T", "M")] = true;
        });
    },
};

//マスタータグに追加
tyrano.plugin.kag.ftag.master_tag["nazolang_choice"] = object(tyrano.plugin.kag.tag["nazolang_choice"]);
tyrano.plugin.kag.ftag.master_tag["nazolang_choice"].kag = TYRANO.kag;

