// Copyright 2023 TigRig All rights reserved.

// KeyConfig.js や [button] タグの role パラメータなどで指定できる "backlog" 機能を拡張する

// → "backlog" は kag.key_mouse.js の _role メソッドで実装されており、実態は kag.menu.displayLog を実行しているだけ
// ⇒ kag.menu.displayLog を拡張する

// TyranoScript v514 のソースコードを流用 https://github.com/ShikemokuMK/tyranoscript/blob/v514/tyrano/plugins/kag/kag.menu.js
// ※TyranoScriptのバージョンアップを行った場合、正しく動作しなくなる可能性あり
TYRANO.kag.menu.displayLog = function () {
    var that = this;
    this.kag.stat.is_skip = false;

    var j_save = $("<div></div>");

    this.kag.html(
        "backlog",
        {
            novel: $.novel,
        },
        function (html_str) {
            var j_menu = $(html_str);

            var layer_menu = that.kag.layer.getMenuLayer();
            layer_menu.empty();
            layer_menu.append(j_menu);

            layer_menu.find(".menu_close").click(function () {
                // 変更部分 ==============================================
                // layer_menu.fadeOut(300, function () {
                //   layer_menu.empty();
                // });
                layer_menu.fadeOut(TYRANO.kag.tmp.backlog_fadeout_speed, function () {
                    layer_menu.empty();
                });
                // ここまで ==============================================

                if (that.kag.stat.visible_menu_button == true) {
                    $(".button_menu").show();
                }
            });

            //スマホの場合はボタンの上下でスクロールできるようにする
            layer_menu.find(".button_smart").hide();
            if ($.userenv() != "pc") {
                layer_menu.find(".button_smart").show();
                layer_menu.find(".button_arrow_up").click(function () {
                    var now = layer_menu.find(".log_body").scrollTop();
                    var pos = now - 60;
                    layer_menu.find(".log_body").animate({ scrollTop: pos }, { queue: false });
                });

                layer_menu.find(".button_arrow_down").click(function () {
                    var now = layer_menu.find(".log_body").scrollTop();
                    var pos = now + 60;
                    layer_menu.find(".log_body").animate({ scrollTop: pos }, { queue: false });
                });
            }

            var log_str = "";

            var array_log = that.kag.variable.tf.system.backlog;

            for (var i = 0; i < array_log.length; i++) {
                log_str += array_log[i] + "<br />";
            }

            layer_menu.find(".log_body").html(log_str);

            layer_menu.find(".log_body").css("font-family", that.kag.config.userFace);

            $.preloadImgCallback(
                layer_menu,
                function () {
                    // 変更部分 ==============================================
                    // layer_menu.stop(true, true).fadeIn(300);
                    layer_menu.stop(true, true).fadeIn(TYRANO.kag.tmp.backlog_fadein_speed);
                    // ここまで ==============================================

                    //一番下固定させる
                    layer_menu.find(".log_body").scrollTop(9999999999);
                },
                that,
            );

            $(".button_menu").hide();

            // 追加部分 ==============================================
            // バックログ上の解読文字を最新に更新する
            // ※ ↑ の `layer_menu.find(".log_body").html(log_str)` よりもあとに実行しないと正しく動作しない
            $("#log_body")
                .find(".nazolang_ruby")
                .each((index, element) => {
                    const id = $(element).attr("data");
                    $(element).text(TYRANO.kag.variable.sf[id] || "");
                });
            // ここまで ==============================================
        },
    );
};

