;-----------------------------------------------------------
;buttonタグとglinkタグでcallしたいプラグイン（Ver.1.02)
;作成者：きつねのてぶくろ図書館　(@FoxMittenLib)
;　　　　　　http://fmlibrary.starfree.jp/
;　　　　紫轢せちる(@Xetil_Works)
;------------------------------------------------------------
;＜使い方＞
;data/others/pluginの中に、解凍したフォルダごと配置したのち、
;first.ks等、確実に通る部分に、
;[plugin name="button_de_call"]　を入力することで使えるようになります。
;
;新規に[glink2]タグと[button2]タグが使えるようになります。
;パラメータはそれぞれglinkとbuttonと同じです。
;jumpではなく、call処理をするので、call～return処理をするときにご使用ください。
;
;button2タグで、fix=trueにしたとき、
;当館ではうまく挙動しなかったので、
;fix=falseにしておくのをお勧めします。
;
;------------------------------------------------------------
;



[iscript]

 var _button2 = tyrano.plugin.kag.tag.button2
 var _kag = tyrano.plugin.kag.ftag.master_tag.html.kag
 var _glink2 = tyrano.plugin.kag.tag.glink2

//button2タグ追加

tyrano.plugin.kag.tag.button2 = {
  pm: {
    graphic: "",
    storage: null,
    target: null,
    ext: "",
    name: "",
    x: "",
    y: "",
    width: "",
    height: "",
    fix: "false",
    savesnap: "false",
    folder: "image",
    exp: "",
    prevar: "",
    visible: "true",
    hint: "",
    clickse: "",
    enterse: "",
    leavese: "",
    clickimg: "",
    enterimg: "",
    auto_next: "yes",
    role: ""
  },
  start: function (pm) {
    var that = this;
    var target_layer = null;
    if (pm.role != "") pm.fix = "true";
    if (pm.fix == "false") {
      target_layer = this.kag.layer.getFreeLayer();
      target_layer.css("z-index", 999999)
    } else target_layer = this.kag.layer.getLayer("fix");
    var storage_url = "";
    if ($.isHTTP(pm.graphic)) storage_url = pm.graphic;
    else storage_url = "./data/" + pm.folder + "/" + pm.graphic;
    var j_button = $("<img />");
    j_button.attr("src", storage_url);
    j_button.css("position", "absolute");
    j_button.css("cursor", "pointer");
    j_button.css("z-index", 99999999);
    if (pm.visible == "true") j_button.show();
    else j_button.hide();
    if (pm.x == "") j_button.css("left", this.kag.stat.locate.x + "px");
    else j_button.css("left", pm.x + "px");
    if (pm.y == "") j_button.css("top", this.kag.stat.locate.y + "px");
    else j_button.css("top", pm.y + "px");
    if (pm.fix != "false") j_button.addClass("fixlayer");
    if (pm.width != "") j_button.css("width", pm.width + "px");
    if (pm.height != "") j_button.css("height", pm.height + "px");
    if (pm.hint != "") j_button.attr({
      "title": pm.hint,
      "alt": pm.hint
    });
    $.setName(j_button, pm.name);
    that.kag.event.addEventElement({
      "tag": "button",
      "j_target": j_button,
      "pm": pm
    });
    that.setEvent(j_button, pm);
    target_layer.append(j_button);
    if (pm.fix == "false") target_layer.show();
    this.kag.ftag.nextOrder()
  },
  setEvent: function (j_button, pm) {
    var that = TYRANO;
    (function () {
      var _target = pm.target;
      var _storage = pm.storage;
      var _pm = pm;
      var preexp = that.kag.embScript(pm.preexp);
      var button_clicked = false;
      j_button.hover(function () {
        if (_pm.enterse != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.enterse,
          "stop": true
        });
        if (_pm.enterimg != "") {
          var enter_img_url = "";
          if ($.isHTTP(_pm.enterimg)) enter_img_url = _pm.enterimg;
          else enter_img_url = "./data/" + _pm.folder + "/" + _pm.enterimg;
          $(this).attr("src", enter_img_url)
        }
      }, function () {
        if (_pm.leavese != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.leavese,
          "stop": true
        });
        if (_pm.enterimg != "") {
          var enter_img_url = "";
          if ($.isHTTP(_pm.graphic)) enter_img_url = _pm.graphic;
          else enter_img_url = "./data/" + _pm.folder + "/" + _pm.graphic;
          $(this).attr("src", enter_img_url)
        }
      });
      j_button.click(function (event) {
        if (_pm.clickimg != "") {
          var click_img_url = "";
          if ($.isHTTP(_pm.clickimg)) click_img_url = _pm.clickimg;
          else click_img_url = "./data/" + _pm.folder + "/" + _pm.clickimg;
          j_button.attr("src", click_img_url)
        }
        if (button_clicked == true && _pm.fix == "false") return false;
        if (that.kag.stat.is_strong_stop != true && _pm.fix == "false") return false;
        button_clicked = true;
        if (_pm.exp != "") that.kag.embScript(_pm.exp, preexp);
        if (_pm.savesnap == "true") {
          if (that.kag.stat.is_stop == true) return false;
          that.kag.menu.snapSave(that.kag.stat.current_save_str)
        }
        if (that.kag.layer.layer_event.css("display") == "none" && that.kag.stat.is_strong_stop != true) return false;
        if (_pm.role != "") {
          that.kag.stat.is_skip = false;
          if (_pm.role != "auto") that.kag.ftag.startTag("autostop", {
            next: "false"
          });
          if (_pm.role == "save" || _pm.role == "menu" || _pm.role == "quicksave" || _pm.role == "sleepgame")
            if (that.kag.stat.is_adding_text == true || that.kag.stat.is_wait == true) return false;
          switch (_pm.role) {
          case "save":
            that.kag.menu.displaySave();
            break;
          case "load":
            that.kag.menu.displayLoad();
            break;
          case "window":
            that.kag.layer.hideMessageLayers();
            break;
          case "title":
            that.kag.backTitle();
            break;
          case "menu":
            that.kag.menu.showMenu();
            break;
          case "skip":
            that.kag.ftag.startTag("skipstart", {});
            break;
          case "backlog":
            that.kag.menu.displayLog();
            break;
          case "fullscreen":
            that.kag.menu.screenFull();
            break;
          case "quicksave":
            that.kag.menu.setQuickSave();
            break;
          case "quickload":
            that.kag.menu.loadQuickSave();
            break;
          case "auto":
            if (that.kag.stat.is_auto == true) that.kag.ftag.startTag("autostop", {
              next: "false"
            });
            else that.kag.ftag.startTag("autostart", {});
            break;
          case "sleepgame":
            j_button.trigger("mouseout");
            if (that.kag.tmp.sleep_game != null) return false;
            that.kag.tmp.sleep_game = {};
            _pm.next = false;
            that.kag.ftag.startTag("sleepgame", _pm);
            break
          }
          if (_pm.clickse != "") that.kag.ftag.startTag("playse", {
            "storage": _pm.clickse,
            "stop": true
          });
          event.stopPropagation();
          return false
        }
        if (_pm.clickse != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.clickse,
          "stop": true
        });
        that.kag.layer.showEventLayer();
        if (_pm.role == "" && _pm.fix == "true") {
          var stack_pm = that.kag.getStack("call");
          if (stack_pm == null) {
            var _auto_next = _pm.auto_next;
            if (that.kag.stat.is_strong_stop == true) _auto_next = "stop";
            else;
            that.kag.ftag.startTag("call", {
              storage: _storage,
              target: _target,
              auto_next: _auto_next
            })
          } else {
            that.kag.log("callスタックが残っている場合、fixボタンは反応しません");
            that.kag.log(stack_pm);
            return false
          }
        } else that.kag.ftag.startTag("call", _pm);
        if (that.kag.stat.skip_link == "true") event.stopPropagation();
        else that.kag.stat.is_skip = false
      })
    })()
  }
};

//button2タグ終わり


//ここからglink2タグ
tyrano.plugin.kag.tag.glink2 = {
  pm: {
    color: "black",
    font_color: "",
    storage: null,
    target: null,
    name: "",
    text: "",
    x: "auto",
    y: "",
    width: "",
    height: "",
    size: 30,
    graphic: "",
    enterimg: "",
    clickse: "",
    enterse: "",
    leavese: "",
    face: ""
  },
  start: function (pm) {
    var that = this;
    var target_layer = null;
    target_layer = this.kag.layer.getFreeLayer();
    target_layer.css("z-index", 999999);
    var j_button = $("<div class='glink_button'>" + pm.text + "</div>");
    j_button.css("position", "absolute");
    j_button.css("cursor", "pointer");
    j_button.css("z-index", 99999999);
    j_button.css("font-size", pm.size + "px");
    if (pm.font_color != "") j_button.css("color", $.convertColor(pm.font_color));
    if (pm.height != "") j_button.css("height", pm.height + "px");
    if (pm.width != "") j_button.css("width", pm.width + "px");
    if (pm.graphic != "") {
      j_button.removeClass("glink_button").addClass("button_graphic");
      var img_url = "./data/image/" + pm.graphic;
      j_button.css("background-image", "url(" + img_url + ")");
      j_button.css("background-repeat", "no-repeat");
      j_button.css("background-position", "center center");
      j_button.css("background-size", "100% 100%")
    } else j_button.addClass(pm.color);
    if (pm.face != "") j_button.css("font-family", pm.face);
    else if (that.kag.stat.font.face != "") j_button.css("font-family", that.kag.stat.font.face);
    if (pm.x == "auto") {
      var sc_width = parseInt(that.kag.config.scWidth);
      var center = Math.floor(parseInt(j_button.css("width")) / 2);
      var base = Math.floor(sc_width / 2);
      var first_left = base - center;
      j_button.css("left", first_left + "px")
    } else if (pm.x == "") j_button.css("left", this.kag.stat.locate.x + "px");
    else j_button.css("left", pm.x + "px");
    if (pm.y == "") j_button.css("top", this.kag.stat.locate.y + "px");
    else j_button.css("top", pm.y + "px");
    $.setName(j_button, pm.name);
    that.kag.event.addEventElement({
      "tag": "glink",
      "j_target": j_button,
      "pm": pm
    });
    this.setEvent(j_button, pm);
    target_layer.append(j_button);
    target_layer.show();
    this.kag.ftag.nextOrder()
  },
  setEvent: function (j_button, pm) {
    var that = TYRANO;
    (function () {
      var _target = pm.target;
      var _storage = pm.storage;
      var _pm = pm;
      var preexp = that.kag.embScript(pm.preexp);
      var button_clicked = false;
      j_button.click(function (e) {
        if (_pm.clickse != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.clickse,
          "stop": true
        });
        if (that.kag.stat.is_strong_stop != true) return false;
        button_clicked = true;
        if (_pm.exp != "") that.kag.embScript(_pm.exp, preexp);
        that.kag.layer.showEventLayer();
        that.kag.ftag.startTag("cm", {});
        that.kag.ftag.startTag("call", _pm);
        if (that.kag.stat.skip_link == "true") e.stopPropagation();
        else that.kag.stat.is_skip = false
      });
      j_button.hover(function () {
        if (_pm.enterimg != "") {
          var enterimg_url = "./data/image/" + _pm.enterimg;
          j_button.css("background-image", "url(" + enterimg_url + ")")
        }
        if (_pm.enterse != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.enterse,
          "stop": true
        })
      }, function () {
        if (_pm.enterimg != "") {
          var img_url = "./data/image/" + _pm.graphic;
          j_button.css("background-image", "url(" + img_url + ")")
        }
        if (_pm.leavese != "") that.kag.ftag.startTag("playse", {
          "storage": _pm.leavese,
          "stop": true
        })
      })
    })()
  }
};

//glink2タグ終わり

 tyrano.plugin.kag.ftag.master_tag.button2 = tyrano.plugin.kag.tag.button2
 tyrano.plugin.kag.ftag.master_tag.button2.kag = _kag
 tyrano.plugin.kag.ftag.master_tag.glink2 = tyrano.plugin.kag.tag.glink2
 tyrano.plugin.kag.ftag.master_tag.glink2.kag = _kag


[endscript]