using HarmonyLib;
using NCMS;
using ReflectionUtility;
using System.Collections.Generic;
using System.Linq;
using System;
using System.Reflection;
using System.Reflection.Emit;
using System.Threading;
using UnityEngine;
using UnityEngine.Purchasing.MiniJSON;
using Cultivation_Way;
using Cultivation_Way.Utils;
using Cultivation_Way.Others;
using Cultivation_Way.Library;
using static Config;

namespace CW_trait
{
    [ModEntry]
    class Main : CW_Addon
    {
		public override void awake(){
			// 不要在此处添加代码，除非你知道你在做什么
			// DO NOT code here.
			load_mod_info(System.Type.GetType("Mod"));
		}
		public override void initialize(){
			Log("添加更多特质!");
			// 在这里初始化模组内容
			// Initalize your mod content here
			add_dfwdsan_trait();
			add_dfwdsi_trait();
			add_dfwdwu_trait();
			add_tianming_trait();
			add_linfu_trait();
			add_Wus_trait();
			CW_trait.init();
		}
		
		private void add_dfwdwu_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "dfwdwu";
			origin.path_icon = "Icons/icondfwdwu";
			origin.needs_to_be_explored = false;
			origin.birth = 0.01f;
			origin.inherit = 10f;
			CW_Asset_Trait dfwdwu = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			dfwdwu.id = origin.id;
			dfwdwu.origin_asset = origin;
			dfwdwu.addition_stats = new CW_BaseStats();
			dfwdwu.addition_stats.base_stats = origin.baseStats;
			// 设置修炼速度加成72%
			dfwdwu.addition_stats.mod_wakan_regen = 720f;
			// 设置灵力上限系数加成108%
			dfwdwu.addition_stats.mod_wakan = 360f;
			// 添加
            CW_Library_Manager.instance.traits.add(dfwdwu);
		}

		private void add_tianming_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "tianming";
			origin.path_icon = "Icons/icontianming";
			origin.needs_to_be_explored = false;
			origin.birth = 0.0001f;
			origin.inherit = 0.1f;
			CW_Asset_Trait tianming = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			tianming.id = origin.id;
			tianming.origin_asset = origin;
			tianming.addition_stats = new CW_BaseStats();
			tianming.addition_stats.base_stats = origin.baseStats;
			// 设置修炼速度加成72%
			tianming.addition_stats.mod_cultivation = 10800f;
			// 设置灵力上限系数加成108%
			tianming.addition_stats.mod_wakan = 10000f;
			tianming.addition_stats.mod_wakan_regen = 10000f;
			tianming.addition_stats.mod_anti_crit = 10000f;
			tianming.addition_stats.mod_anti_crit_damage = 10000f;
			tianming.addition_stats.mod_anti_spell_armor = 10000f;
			tianming.addition_stats.mod_anti_armor = 10000f;
			tianming.addition_stats.mod_shield = 10000f;
			tianming.addition_stats.mod_shield_regen = 10000f;
			tianming.addition_stats.mod_soul = 10000f;
			tianming.addition_stats.mod_age = 10000f;
			tianming.addition_stats.vampire = 1000f;
			tianming.addition_stats.mod_spell_range = 10000f;
			// 添加
            CW_Library_Manager.instance.traits.add(tianming);
		}

		private void add_dfwdsan_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "dfwdsan";
			origin.path_icon = "Icons/icondfwdsan";
			origin.needs_to_be_explored = false;
			origin.birth = 0.05f;
			origin.inherit = 10f;
			CW_Asset_Trait dfwdsan = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			dfwdsan.id = origin.id;
			dfwdsan.origin_asset = origin;
			dfwdsan.addition_stats = new CW_BaseStats();
			dfwdsan.addition_stats.base_stats = origin.baseStats;
			// 设置修炼速度加成72%
			dfwdsan.addition_stats.mod_health_regen = 360f;
			// 添加
            CW_Library_Manager.instance.traits.add(dfwdsan);
		}

		private void add_dfwdsi_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "dfwdsi";
			origin.path_icon = "Icons/icondfwdsi";
			origin.needs_to_be_explored = false;
			origin.birth = 0.5f;
			origin.inherit = 5f;
			origin.baseStats.mod_health = 100;
			CW_Asset_Trait dfwdsi = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			dfwdsi.id = origin.id;
			dfwdsi.origin_asset = origin;
			dfwdsi.addition_stats = new CW_BaseStats();
			dfwdsi.addition_stats.mod_health_regen = -25f;
			dfwdsi.addition_stats.mod_cultivation = -100f;
			dfwdsi.addition_stats.base_stats = origin.baseStats;
			// 添加
            CW_Library_Manager.instance.traits.add(dfwdsi);
		}

		private void add_linfu_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "linfu";
			origin.path_icon = "Icons/iconlinfu";
			origin.needs_to_be_explored = false;
			origin.birth = 0.01f;
			origin.inherit = 0.01f;
			origin.baseStats.mod_damage = 100f;
			origin.baseStats.mod_armor = 100f;
			CW_Asset_Trait linfu = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			linfu.id = origin.id;
			linfu.origin_asset = origin;
			linfu.addition_stats = new CW_BaseStats();
			linfu.addition_stats.mod_cultivation = 100f;
			linfu.addition_stats.mod_wakan_regen = 100f;
			linfu.addition_stats.mod_health_regen = 100f;
			linfu.addition_stats.mod_age = 50f;
			linfu.addition_stats.base_stats = origin.baseStats;
			// 添加
            CW_Library_Manager.instance.traits.add(linfu);
		}
		
		private void add_Wus_trait(){
			// 原版特质
			ActorTrait origin = new ActorTrait();
			origin.id = "Wus";
			origin.path_icon = "Icons/iconWus";
			origin.needs_to_be_explored = false;
			origin.birth = 0.01f;
			origin.inherit = 0.01f;
			CW_Asset_Trait Wus = new CW_Asset_Trait();
			// 包装原版特质，即将提供更简单的创建与包装方式
			Wus.id = origin.id;
			Wus.origin_asset = origin;
			Wus.addition_stats = new CW_BaseStats();
			Wus.addition_stats.shield = 10000;
			Wus.addition_stats.mod_shield = 1000f;
			Wus.addition_stats.shield_regen = 1000;
			Wus.addition_stats.mod_shield_regen = 1000f;
			Wus.addition_stats.base_stats = origin.baseStats;
			// 添加
            CW_Library_Manager.instance.traits.add(Wus);
		}
    }
}