using ai;
using HarmonyLib;
using ReflectionUtility;
using System;
using System.Threading;
using NCMS;
using UnityEngine;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Cultivation_Way;
using Cultivation_Way.Utils;
using Cultivation_Way.Others;
using Cultivation_Way.Library;

namespace CW_trait
{
    public class CW_trait : Asset
    {
        public static void init()
        {
            ActorTrait spelleternalfour = new ActorTrait();
            spelleternalfour.id = "兵部";
            spelleternalfour.path_icon = "Icons/iconspelleternalfour";
            spelleternalfour.needs_to_be_explored = false;
            spelleternalfour.birth = 5f;
            spelleternalfour.inherit = 20f;
            spelleternalfour.baseStats.health = 100;
            spelleternalfour.baseStats.army = 10;
            spelleternalfour.baseStats.armor = 5;
            spelleternalfour.baseStats.diplomacy = -5;
            spelleternalfour.baseStats.stewardship = 10;
            spelleternalfour.baseStats.warfare = 10;
            AssetManager.traits.add(spelleternalfour);
            addTraitToLocalizedLibrary(spelleternalfour.id, "修仙界中的军事天才");

            ActorTrait chuan = new ActorTrait();
            chuan.id = "穿越者";
            chuan.path_icon = "Icons/iconchuan";
            chuan.needs_to_be_explored = false;
            chuan.opposite = "天灾之悬,天灾降世";
            chuan.birth = 0.01f;
            chuan.baseStats.health = 500;
            chuan.baseStats.damage = 200;
            chuan.baseStats.warfare = 10;
            chuan.baseStats.stewardship = 10;
            chuan.baseStats.diplomacy = 10;
            chuan.baseStats.intelligence = 10;
            chuan.action_death = (WorldAction)Delegate.Combine(chuan.action_death, new WorldAction(Reincarnation));
            //交战中摄取敌人的生命治愈己身
            chuan.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            AssetManager.traits.add(chuan);
            addTraitToLocalizedLibrary(chuan.id, "命运掌握在自己手中!");

            ActorTrait chuan1 = new ActorTrait();
            chuan1.id = "穿越者（重生）";
            chuan1.path_icon = "Icons/iconchuan";
            chuan1.needs_to_be_explored = false;
            chuan1.opposite = "天灾之悬,天灾降世";
            chuan1.baseStats.health = 2000;
            chuan1.baseStats.damage = 300;
            chuan1.baseStats.warfare = 20;
            chuan1.baseStats.stewardship = 20;
            chuan1.baseStats.diplomacy = 20;
            chuan1.baseStats.intelligence = 20;
            chuan1.can_be_given = false;
            //交战中摄取敌人的生命治愈己身
            chuan1.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            AssetManager.traits.add(chuan1);
            addTraitToLocalizedLibrary(chuan1.id, "不，不能回头！继续向命运冲锋！");


            ActorTrait zhenwu = new ActorTrait();
            zhenwu.id = "九天荡魔";
            zhenwu.path_icon = "Icons/iconzhenwu";
            zhenwu.needs_to_be_explored = false;
            zhenwu.baseStats.mod_damage = 100;
            zhenwu.baseStats.army = 20;
            zhenwu.baseStats.mod_crit = 100;
            zhenwu.baseStats.stewardship = 25;
            zhenwu.baseStats.intelligence = 10;
            zhenwu.baseStats.diplomacy = -10;
            zhenwu.birth = 0.02f;
            zhenwu.inherit = 10f;
            //复活一次机会
            zhenwu.action_death = (WorldAction)Delegate.Combine(chuan.action_death, new WorldAction(Reincarnation));
            //真武特特性 初始等级为5
            zhenwu.action_special_effect = (WorldAction)Delegate.Combine(zhenwu.action_special_effect, new WorldAction(ZhenWu));
            //护盾
            zhenwu.action_attack_self = (WorldAction)Delegate.Combine(zhenwu.action_attack_self, new WorldAction(ArcanistShield));
            //陨石法术
            zhenwu.action_attack_self = (WorldAction)Delegate.Combine(zhenwu.action_attack_self, new WorldAction(GravitationalPull));
            //三防，半不死，血量加成，出生等级+1
            zhenwu.action_special_effect = (WorldAction)Delegate.Combine(zhenwu.action_special_effect, new WorldAction(SanFang));
            AssetManager.traits.add(zhenwu);
            addTraitToLocalizedLibrary(zhenwu.id, "吾乃九天荡魔祖师，荡尽天下不平事！");

            ActorTrait tian = new ActorTrait();
            tian.id = "天地护体";
            tian.path_icon = "Icons/iconTtian";
            tian.needs_to_be_explored = false;
            tian.birth = 0.07f;
            tian.inherit = 0.01f;
            tian.baseStats.mod_damage = 10;
            tian.baseStats.mod_crit = 50;
            tian.baseStats.armor = 10;
            //三防，半不死，血量加成，出生等级+1
            tian.action_special_effect = (WorldAction)Delegate.Combine(tian.action_special_effect, new WorldAction(SanFang));
            //护盾
            tian.action_attack_self = (WorldAction)Delegate.Combine(tian.action_attack_self, new WorldAction(ArcanistShield));
            AssetManager.traits.add(tian);
            addTraitToLocalizedLibrary(tian.id, "灾障不干,众圣护门");

            ActorTrait ru = new ActorTrait();
            ru.id = "儒者";
            ru.path_icon = "Icons/iconru";
            ru.needs_to_be_explored = false;
            ru.birth = 5f;
            ru.inherit = 50f;
            ru.baseStats.damage = 50;
            ru.baseStats.armor = 5;
            ru.baseStats.attackSpeed = 3;
            ru.baseStats.diplomacy = 1;
            ru.baseStats.warfare = 1;
            ru.baseStats.intelligence = 1;
            AssetManager.traits.add(ru);
            addTraitToLocalizedLibrary(ru.id, "君子六艺大成者");

            ActorTrait duan = new ActorTrait();
            duan.id = "断红尘";
            duan.path_icon = "Icons/iconduan";
            duan.needs_to_be_explored = false;
            duan.birth = 0.05f;
            duan.baseStats.damage = 100;
            duan.baseStats.armor = 10;
            duan.baseStats.crit = 10;
            duan.baseStats.attackSpeed = 20;
            //初始三级
            duan.action_special_effect = (WorldAction)Delegate.Combine(duan.action_special_effect, new WorldAction(Duan));
            AssetManager.traits.add(duan);
            addTraitToLocalizedLibrary(duan.id, "只有抛却红尘，才可登顶巅峰");

            ActorTrait bu = new ActorTrait();
            bu.id = "不朽的歌";
            bu.path_icon = "Icons/iconbu";
            bu.needs_to_be_explored = false;
            bu.baseStats.crit = 100;
            bu.birth = 0.7f;
            bu.baseStats.diplomacy = 30;
            //护盾
            bu.action_attack_self = (WorldAction)Delegate.Combine(bu.action_attack_self, new WorldAction(ArcanistShield));
            AssetManager.traits.add(bu);
            addTraitToLocalizedLibrary(bu.id, "看尽天下事，道尽天下歌");

            ActorTrait jiang = new ActorTrait();
            jiang.id = "将魂";
            jiang.path_icon = "Icons/iconjiang";
            jiang.needs_to_be_explored = false;
            jiang.baseStats.crit = 30;
            jiang.birth = 0.1f;
            jiang.inherit = 20f;
            jiang.baseStats.armor = -10;
            jiang.baseStats.damage = 300;
            jiang.action_special_effect = (WorldAction)Delegate.Combine(jiang.action_special_effect, new WorldAction(San));
            AssetManager.traits.add(jiang);
            addTraitToLocalizedLibrary(jiang.id, "百战无休，干戈无止！");

            ActorTrait ba = new ActorTrait();
            ba.id = "霸王";
            ba.path_icon = "Icons/iconba";
            ba.needs_to_be_explored = false;
            ba.baseStats.crit = 70;
            ba.baseStats.armor = 50;
            ba.baseStats.damage = 500;
            ba.baseStats.attackSpeed = 20;
            AssetManager.traits.add(ba);
            addTraitToLocalizedLibrary(ba.id, "生为人杰，死为鬼雄！");

            ActorTrait daoshi = new ActorTrait();
            daoshi.id = "道士";
            daoshi.path_icon = "Icons/icondaoshi";
            daoshi.needs_to_be_explored = false;
            daoshi.baseStats.mod_damage = -20;
            daoshi.baseStats.armor = 10;
            daoshi.baseStats.mod_health = 20;
            daoshi.birth = 0.2f;
            daoshi.inherit = 50f;
            AssetManager.traits.add(daoshi);
            //寿命提升
            daoshi.action_special_effect = (WorldAction)Delegate.Combine(daoshi.action_special_effect, new WorldAction(ShouMing));
            addTraitToLocalizedLibrary(daoshi.id, "道可道，非常道");

            ActorTrait zhengren = new ActorTrait();
            zhengren.id = "匡正人";
            zhengren.path_icon = "Icons/iconzhengren";
            zhengren.needs_to_be_explored = false;
            zhengren.baseStats.damage = 100;
            zhengren.baseStats.crit = 30;
            zhengren.baseStats.army = 10;
            zhengren.baseStats.warfare = 10;
            zhengren.baseStats.diplomacy = -10;
            zhengren.birth = 0.2f;
            AssetManager.traits.add(zhengren);
            addTraitToLocalizedLibrary(zhengren.id, "匡复真龙，吾命也");

            ActorTrait gongde = new ActorTrait();
            gongde.id = "圣德之身";
            gongde.path_icon = "Icons/icongongde";
            gongde.needs_to_be_explored = false;
            gongde.birth = 0.05f;
            gongde.baseStats.mod_damage = 10;
            gongde.baseStats.armor = 60;
            gongde.baseStats.mod_health = 50;
            gongde.baseStats.diplomacy = 30;
            AssetManager.traits.add(gongde);
            //护盾
            gongde.action_attack_self = (WorldAction)Delegate.Combine(gongde.action_attack_self, new WorldAction(ArcanistShield));
            //三防，半不死，血量加成，出生等级+1
            gongde.action_special_effect = (WorldAction)Delegate.Combine(gongde.action_special_effect, new WorldAction(SanFang));
            addTraitToLocalizedLibrary(gongde.id, "天生五德护佑，诸邪不侵，万法不沾。");

            ActorTrait wudi = new ActorTrait();
            wudi.id = "五帝诰命";
            wudi.path_icon = "Icons/iconwudi";
            wudi.needs_to_be_explored = false;
            wudi.birth = 0.02f;
            wudi.baseStats.damage = 700;
            wudi.baseStats.armor = 90;
            AssetManager.traits.add(wudi);
            wudi.action_special_effect = (WorldAction)Delegate.Combine(wudi.action_special_effect, new WorldAction(San1));
            addTraitToLocalizedLibrary(wudi.id, "从诰命五方大帝，避人间三灾七劫");

            ActorTrait bux = new ActorTrait();
            bux.id = "步虚";
            bux.path_icon = "Icons/iconbux";
            bux.needs_to_be_explored = false;
            bux.birth = 0.02f;
            bux.baseStats.mod_health = 20;
            AssetManager.traits.add(bux);
            //出生2级，增加300寿命
            bux.action_special_effect = (WorldAction)Delegate.Combine(bux.action_special_effect, new WorldAction(San1));
            addTraitToLocalizedLibrary(bux.id, "大道洞玄虚有念无不契炼质入仙真遂成金刚体超度三界难地狱五苦解悉归太上经静念稽首礼");

            ActorTrait ling = new ActorTrait();
            ling.id = "灵宝持剑";
            ling.path_icon = "Icons/iconling";
            ling.needs_to_be_explored = false;
            ling.birth = 0.01f;
            ling.baseStats.mod_damage = 300;
            AssetManager.traits.add(ling);
            ling.action_special_effect = (WorldAction)Delegate.Combine(ling.action_special_effect, new WorldAction(Qian));
            addTraitToLocalizedLibrary(ling.id, "天生异象，天尊持剑佑之。");

            ActorTrait bere = new ActorTrait();
            bere.id = "般若波罗蜜多";
            bere.path_icon = "Icons/iconbere";
            bere.needs_to_be_explored = false;
            bere.birth = 0.01f;
            bere.baseStats.mod_damage = -10;
            bere.baseStats.armor = 20;
            AssetManager.traits.add(bere);
            addTraitToLocalizedLibrary(bere.id, "观自在菩萨，行深般若波罗蜜多时");

            ActorTrait gao = new ActorTrait();
            gao.id = "高功";
            gao.path_icon = "Icons/icongao";
            gao.needs_to_be_explored = false;
            gao.birth = 0.01f;
            gao.baseStats.mod_damage = 50;
            gao.baseStats.armor = 15;
            AssetManager.traits.add(gao);
            //加50寿命
            gao.action_special_effect = (WorldAction)Delegate.Combine(gao.action_special_effect, new WorldAction(ShouMing));
            addTraitToLocalizedLibrary(gao.id, "八方威神使我自然灵宝符命普告九天乾罗答那");

            ActorTrait zhenren = new ActorTrait();
            zhenren.id = "真人";
            zhenren.path_icon = "Icons/iconzhenren";
            zhenren.needs_to_be_explored = false;
            zhenren.birth = 0.01f;
            zhenren.baseStats.mod_damage = -30;
            zhenren.baseStats.armor = 40;
            zhenren.baseStats.health = 50;
            zhenren.baseStats.diplomacy = 20;
            AssetManager.traits.add(zhenren);
            //复活一次机会
            zhenren.action_death = (WorldAction)Delegate.Combine(zhenren.action_death, new WorldAction(Reincarnation));
            //出生2级，增加300寿命
            zhenren.action_special_effect = (WorldAction)Delegate.Combine(zhenren.action_special_effect, new WorldAction(San1));
            //护盾
            zhenren.action_attack_target = (WorldAction)Delegate.Combine(zhenren.action_attack_target, new WorldAction(ArcanistShield));
            //交战中摄取敌人的生命治愈己身
            zhenren.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            addTraitToLocalizedLibrary(zhenren.id, "既入真道 名为得道");

            ActorTrait tianshi = new ActorTrait();
            tianshi.id = "天师";
            tianshi.path_icon = "Icons/icontianshi";
            tianshi.needs_to_be_explored = false;
            tianshi.birth = 0.01f;
            tianshi.baseStats.mod_damage = 50;
            tianshi.baseStats.armor = 80;
            tianshi.baseStats.health = 100;
            tianshi.baseStats.diplomacy = 20;
            AssetManager.traits.add(tianshi);
            //复活一次机会
            tianshi.action_death = (WorldAction)Delegate.Combine(tianshi.action_death, new WorldAction(Reincarnation));
            //出生2级，增加300寿命
            tianshi.action_special_effect = (WorldAction)Delegate.Combine(tianshi.action_special_effect, new WorldAction(WuBai));
            //护盾
            tianshi.action_attack_target = (WorldAction)Delegate.Combine(tianshi.action_attack_target, new WorldAction(ArcanistShield));
            //交战中摄取敌人的生命治愈己身
            tianshi.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            //陨石法术
            tianshi.action_attack_target = (WorldAction)Delegate.Combine(tianshi.action_attack_target, new WorldAction(GravitationalPull));
            //地震法术
            tianshi.action_attack_target = (WorldAction)Delegate.Combine(tianshi.action_attack_target, new WorldAction(EarthCracking));
            addTraitToLocalizedLibrary(tianshi.id, "为化众生 名为得道 能悟之者 可传圣道");

            ActorTrait renwang = new ActorTrait();
            renwang.id = "人王";
            renwang.path_icon = "Icons/iconrenwang";
            renwang.needs_to_be_explored = false;
            renwang.birth = 0.01f;
            renwang.baseStats.mod_damage = 70;
            renwang.baseStats.armor = 50;
            renwang.baseStats.diplomacy = 30;
            renwang.baseStats.warfare = 30;
            renwang.baseStats.stewardship = 30;
            renwang.baseStats.intelligence = 30;
            AssetManager.traits.add(renwang);
            addTraitToLocalizedLibrary(renwang.id, "普天之下，莫非孤家，率土之滨，莫非爱卿");

            ActorTrait tie = new ActorTrait();
            tie.id = "钢筋铁骨";
            tie.birth = 2f;
            tie.inherit = 20f;
            tie.path_icon = "Icons/icontie";
            tie.needs_to_be_explored = false;
            tie.baseStats.mod_damage = 20;
            tie.baseStats.mod_health = 30;
            tie.baseStats.armor = 50;
            AssetManager.traits.add(tie);
            addTraitToLocalizedLibrary(tie.id, "我一身筋骨 任你万般捶打！");

            ActorTrait dao = new ActorTrait();
            dao.id = "天生近道";
            dao.birth = 0.01f;
            dao.path_icon = "Icons/icondao";
            dao.needs_to_be_explored = false;
            dao.inherit = 20f;
            dao.baseStats.mod_damage = 20;
            dao.baseStats.mod_health = 30;
            dao.baseStats.armor = 50;
            AssetManager.traits.add(dao);
            //初始三级
            dao.action_special_effect = (WorldAction)Delegate.Combine(dao.action_special_effect, new WorldAction(Duan));
            addTraitToLocalizedLibrary(dao.id, "天生大道亲近，无双无对");

            ActorTrait ludi = new ActorTrait();
            ludi.id = "陆地神仙";
            ludi.birth = 0.01f;
            ludi.path_icon = "Icons/iconludi";
            ludi.needs_to_be_explored = false;
            ludi.baseStats.mod_damage = 100;
            ludi.baseStats.mod_health = 100;
            ludi.baseStats.armor = 30;
            AssetManager.traits.add(ludi);
            //500寿命
            ludi.action_special_effect = (WorldAction)Delegate.Combine(ludi.action_special_effect, new WorldAction(WuBai));
            //复活一次机会
            ludi.action_death = (WorldAction)Delegate.Combine(ludi.action_death, new WorldAction(Reincarnation));
            //护盾
            ludi.action_attack_target = (WorldAction)Delegate.Combine(ludi.action_attack_target, new WorldAction(ArcanistShield));
            //交战中摄取敌人的生命治愈己身
            ludi.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            //陨石法术
            ludi.action_attack_self = (WorldAction)Delegate.Combine(ludi.action_attack_self, new WorldAction(GravitationalPull));
            //圣光法术
            ludi.action_attack_target = (WorldAction)Delegate.Combine(ludi.action_attack_target, new WorldAction(DivineLight));
            //地震法术
            ludi.action_attack_target = (WorldAction)Delegate.Combine(ludi.action_attack_target, new WorldAction(EarthCracking));
            addTraitToLocalizedLibrary(ludi.id, "天上地下唯我独尊");


            ActorTrait lingtai = new ActorTrait();
            lingtai.id = "灵台";
            lingtai.path_icon = "Icons/iconlingtai";
            lingtai.needs_to_be_explored = false;
            lingtai.birth = 0.5f;
            lingtai.baseStats.mod_damage = 10;
            lingtai.baseStats.mod_health = 20;
            AssetManager.traits.add(lingtai);
            addTraitToLocalizedLibrary(lingtai.id, "灵台清明");

            ActorTrait tianzai = new ActorTrait();
            tianzai.id = "天灾之悬";
            tianzai.path_icon = "Icons/icontianzai";
            tianzai.needs_to_be_explored = false;
            tianzai.birth = 0.02f;
            tianzai.baseStats.damage = 100;
            tianzai.baseStats.crit = 20;
            tianzai.baseStats.mod_health = -50;
            AssetManager.traits.add(tianzai);
            //天灾降世
            tianzai.action_death = (WorldAction)Delegate.Combine(tianzai.action_death, new WorldAction(TianZai));
            addTraitToLocalizedLibrary(tianzai.id, "悬天荡世，震晓天琼，临！");

            ActorTrait tianzai1 = new ActorTrait();
            tianzai1.id = "天灾降世";
            tianzai1.path_icon = "Icons/icontianzai";
            tianzai1.needs_to_be_explored = false;
            tianzai1.birth = 0.01f;
            tianzai1.baseStats.damage = 2000;
            tianzai1.baseStats.crit = 20;
            tianzai1.can_be_given = false;
            AssetManager.traits.add(tianzai1);
            addTraitToLocalizedLibrary(tianzai1.id, "携天之怒妒，为荡世而来");

            ActorTrait haoshen = new ActorTrait();
            haoshen.id = "豪绅";
            haoshen.path_icon = "Icons/iconhaoshen";
            haoshen.needs_to_be_explored = false;
            haoshen.birth = 0.5f;
            haoshen.baseStats.mod_damage = 10;
            haoshen.baseStats.armor = 30;
            haoshen.baseStats.warfare = -10;
            haoshen.baseStats.stewardship = -10;
            haoshen.baseStats.diplomacy = -10;
            haoshen.baseStats.intelligence = -10;
            AssetManager.traits.add(haoshen);
            addTraitToLocalizedLibrary(haoshen.id, "金来银来田粮来，穷离苦离恶疾离");

            ActorTrait yuanmie = new ActorTrait();
            yuanmie.id = "缘灭";
            yuanmie.path_icon = "Icons/iconyuanmie";
            yuanmie.needs_to_be_explored = false;
            yuanmie.birth = 0.01f;
            yuanmie.inherit = 90f;
            AssetManager.traits.add(yuanmie);
            //无法修炼
            yuanmie.action_special_effect = (WorldAction)Delegate.Combine(yuanmie.action_special_effect, new WorldAction(WuFa));
            addTraitToLocalizedLibrary(yuanmie.id, "凡人，怎可妄想飞天遁地");

            ActorTrait donghuang = new ActorTrait();
            donghuang.id = "东皇崩";
            donghuang.path_icon = "Icons/icondonghuang";
            donghuang.needs_to_be_explored = false;
            donghuang.birth = 0.01f; ;
            AssetManager.traits.add(donghuang);
            //降级
            donghuang.action_special_effect = (WorldAction)Delegate.Combine(donghuang.action_special_effect, new WorldAction(QiSi));
            addTraitToLocalizedLibrary(donghuang.id, "连那样的存在也消失得一干二净，此方世界又有何意义");

            ActorTrait kesi = new ActorTrait();
            kesi.id = "客死";
            kesi.path_icon = "Icons/iconkesi";
            kesi.needs_to_be_explored = false;
            kesi.birth = 0.5f;
            kesi.baseStats.damage = -200;
            kesi.baseStats.warfare = -20;
            kesi.baseStats.stewardship = -20;
            kesi.baseStats.diplomacy = -20;
            kesi.baseStats.intelligence = -20;
            AssetManager.traits.add(kesi);
            kesi.action_special_effect = (WorldAction)Delegate.Combine(kesi.action_special_effect, new WorldAction(KeSi));
            addTraitToLocalizedLibrary(kesi.id, "只恨命薄无缘归故里，但求飞叶回旋入梓土");

            ActorTrait shizhi = new ActorTrait();
            shizhi.id = "世之护道人";
            shizhi.path_icon = "Icons/iconshizhi";
            shizhi.needs_to_be_explored = false;
            shizhi.birth = 0.1f;
            shizhi.inherit = 5f;
            shizhi.baseStats.damage = 800;
            shizhi.baseStats.armor = 30;
            shizhi.baseStats.attackSpeed = 80;
            shizhi.baseStats.diplomacy = -100;
            shizhi.baseStats.intelligence = -100;
            AssetManager.traits.add(shizhi);
            shizhi.action_special_effect = (WorldAction)Delegate.Combine(shizhi.action_special_effect, new WorldAction(ZhenWu));
            addTraitToLocalizedLibrary(shizhi.id, "道本凡，人护之，道本非凡，人恒护之");

            ActorTrait guo = new ActorTrait();
            guo.id = "监国";
            guo.path_icon = "Icons/iconguo";
            guo.needs_to_be_explored = false;
            guo.birth = 0.01f;
            guo.inherit = 5f;
            guo.baseStats.damage = 300;
            guo.baseStats.armor = -20;
            guo.baseStats.warfare = -10;
            guo.baseStats.diplomacy = 20;
            guo.baseStats.stewardship = 20;
            guo.baseStats.intelligence = 20;
            guo.baseStats.mod_speed = 30f;
            AssetManager.traits.add(guo);
            //出生三级
            guo.action_special_effect = (WorldAction)Delegate.Combine(guo.action_special_effect, new WorldAction(Duan));
            //护道
            guo.action_attack_self = (WorldAction)Delegate.Combine(zhenwu.action_attack_self, new WorldAction(ArcanistShield));
            addTraitToLocalizedLibrary(guo.id, "监之以国，护之以民");

            ActorTrait kongwu = new ActorTrait();
            kongwu.id = "孔武";
            kongwu.path_icon = "Icons/iconkongwu";
            kongwu.needs_to_be_explored = false;
            kongwu.birth = 1f;
            kongwu.inherit = 5f;
            kongwu.baseStats.mod_damage = 36;
            kongwu.baseStats.mod_health = 36;
            kongwu.baseStats.attackSpeed = 36;
            kongwu.baseStats.armor = 20;
            AssetManager.traits.add(kongwu);
            addTraitToLocalizedLibrary(kongwu.id, "身体体质极强");

            ActorTrait xian = new ActorTrait();
            xian.id = "先天";
            xian.path_icon = "Icons/iconxian";
            xian.needs_to_be_explored = false;
            xian.birth = 10f;
            xian.inherit = 10f;
            xian.baseStats.mod_damage = 30;
            xian.baseStats.armor = 10;
            AssetManager.traits.add(xian);
            xian.action_special_effect = (WorldAction)Delegate.Combine(xian.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(xian.id, "先天");

            ActorTrait shenmai = new ActorTrait();
            shenmai.id = "神脉";
            shenmai.path_icon = "Icons/iconshenmai";
            shenmai.needs_to_be_explored = false;
            shenmai.opposite = "先天";
            shenmai.birth = 0.09f;
            shenmai.inherit = 50f;
            shenmai.baseStats.damage = 36;
            AssetManager.traits.add(shenmai);
            addTraitToLocalizedLibrary(shenmai.id, "天地神脉，大成神道");

            ActorTrait yanqi = new ActorTrait();
            yanqi.id = "衍气";
            yanqi.path_icon = "Icons/iconyanqi";
            yanqi.needs_to_be_explored = false;
            yanqi.birth = 0f;
            yanqi.inherit = 0f;
            yanqi.baseStats.mod_damage = 40;
            yanqi.baseStats.mod_health = 40;
            AssetManager.traits.add(yanqi);
            yanqi.action_special_effect = (WorldAction)Delegate.Combine(yanqi.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(yanqi.id, "衍气");

            ActorTrait mingdao = new ActorTrait();
            mingdao.id = "明道";
            mingdao.path_icon = "Icons/iconmingdao";
            mingdao.needs_to_be_explored = false;
            mingdao.birth = 0f;
            mingdao.inherit = 0f;
            mingdao.baseStats.mod_damage = 60;
            mingdao.baseStats.mod_health = 60;
            AssetManager.traits.add(mingdao);
            mingdao.action_special_effect = (WorldAction)Delegate.Combine(mingdao.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(mingdao.id, "明天地大道，夺世间造化");

            ActorTrait wudao = new ActorTrait();
            wudao.id = "悟道";
            wudao.path_icon = "Icons/iconwudao";
            wudao.needs_to_be_explored = false;
            wudao.birth = 0f;
            wudao.inherit = 0f;
            wudao.baseStats.mod_damage = 81;
            wudao.baseStats.mod_health = 81;
            AssetManager.traits.add(wudao);
            wudao.action_special_effect = (WorldAction)Delegate.Combine(wudao.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(wudao.id, "悟大道，寻长生");

            ActorTrait xiantiandao = new ActorTrait();
            xiantiandao.id = "先天悟道";
            xiantiandao.path_icon = "Icons/iconxiantiandao";
            xiantiandao.needs_to_be_explored = false;
            xiantiandao.birth = 0.01f;
            xiantiandao.inherit = 0.1f;
            xiantiandao.baseStats.mod_damage = 80;
            xiantiandao.baseStats.mod_health = 82;
            AssetManager.traits.add(xiantiandao);
            xiantiandao.action_special_effect = (WorldAction)Delegate.Combine(xiantiandao.action_special_effect, new WorldAction(XTDT));
            addTraitToLocalizedLibrary(xiantiandao.id, "天生悟大道");

            ActorTrait kaiyuan = new ActorTrait();
            kaiyuan.id = "开源";
            kaiyuan.path_icon = "Icons/iconkaiyuan";
            kaiyuan.needs_to_be_explored = false;
            kaiyuan.birth = 0f;
            kaiyuan.inherit = 0f;
            kaiyuan.baseStats.mod_damage = 100;
            kaiyuan.baseStats.mod_health = 100;
            AssetManager.traits.add(kaiyuan);
            kaiyuan.action_special_effect = (WorldAction)Delegate.Combine(kaiyuan.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(kaiyuan.id, "开天地之源，衍仙神之道");
            
            ActorTrait feishengzhe = new ActorTrait();
            feishengzhe.id = "飞升者";
            feishengzhe.path_icon = "Icons/iconfeishengzhe";
            feishengzhe.needs_to_be_explored = false;
            feishengzhe.birth = 0f;
            feishengzhe.inherit = 0f;
            feishengzhe.baseStats.mod_damage = 120;
            feishengzhe.baseStats.mod_health = 120;
            feishengzhe.baseStats.armor = 10;
            AssetManager.traits.add(feishengzhe);
            feishengzhe.action_death = (WorldAction)Delegate.Combine(feishengzhe.action_death, new WorldAction(Reincarnation));
            feishengzhe.action_special_effect = (WorldAction)Delegate.Combine(feishengzhe.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(feishengzhe.id, "天道认证飞升者");

            ActorTrait xiangong = new ActorTrait();
            xiangong.id = "仙宫";
            xiangong.path_icon = "Icons/iconxiangong";
            xiangong.needs_to_be_explored = false;
            xiangong.birth = 0f;
            xiangong.inherit = 0f;
            xiangong.baseStats.mod_damage = 126;
            xiangong.baseStats.mod_health = 126;
            xiangong.baseStats.armor = 12;
            AssetManager.traits.add(xiangong);
            xiangong.action_special_effect = (WorldAction)Delegate.Combine(xiangong.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(xiangong.id, "天苍之上有仙宫");

            ActorTrait xinghe = new ActorTrait();
            xinghe.id = "星河";
            xinghe.path_icon = "Icons/iconxinghe";
            xinghe.needs_to_be_explored = false;
            xinghe.birth = 0f;
            xinghe.inherit = 0f;
            xinghe.baseStats.mod_damage = 140;
            xinghe.baseStats.mod_health = 140;
            xinghe.baseStats.armor = 1;
            AssetManager.traits.add(xinghe);
            xinghe.action_special_effect = (WorldAction)Delegate.Combine(xinghe.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(xinghe.id, "天地之外有星河");

            ActorTrait xianchen = new ActorTrait();
            xianchen.id = "羡尘";
            xianchen.path_icon = "Icons/iconxianchen";
            xianchen.needs_to_be_explored = false;
            xianchen.birth = 0f;
            xianchen.inherit = 0f;
            xianchen.baseStats.mod_damage = 210;
            xianchen.baseStats.mod_health = 129;
            xianchen.baseStats.attackSpeed = 126;
            xianchen.baseStats.armor = 1;
            AssetManager.traits.add(xianchen);
            xianchen.action_special_effect = (WorldAction)Delegate.Combine(xianchen.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(xianchen.id, "纵使登峰造极也羡人间凡尘");

            ActorTrait rendi = new ActorTrait();
            rendi.id = "人族大帝";
            rendi.path_icon = "Icons/iconrendi";
            rendi.needs_to_be_explored = false;
            rendi.birth = 0f;
            rendi.inherit = 0f;
            rendi.baseStats.mod_damage = 192;
            rendi.baseStats.mod_health = 192;
            rendi.baseStats.attackSpeed = 108;
            rendi.baseStats.diplomacy = 108;
            rendi.baseStats.warfare = 108;
            rendi.baseStats.stewardship = 108;
            rendi.baseStats.intelligence = 108;
            rendi.baseStats.armor = 1;
            AssetManager.traits.add(rendi);
            rendi.action_death = (WorldAction)Delegate.Combine(rendi.action_death, new WorldAction(Reincarnation));
            rendi.action_special_effect = (WorldAction)Delegate.Combine(rendi.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(rendi.id, "人族大帝");

            ActorTrait wuzitian = new ActorTrait();
            wuzitian.id = "无字天书";
            wuzitian.path_icon = "Icons/iconwuzitian";
            wuzitian.needs_to_be_explored = false;
            wuzitian.birth = 0f;
            wuzitian.inherit = 0f;
            wuzitian.baseStats.mod_damage = 200;
            wuzitian.baseStats.mod_health = 200;
            wuzitian.baseStats.attackSpeed = 200;
            wuzitian.baseStats.armor = 10;
            AssetManager.traits.add(wuzitian);
            wuzitian.action_death = (WorldAction)Delegate.Combine(wuzitian.action_death, new WorldAction(Reincarnation));
            wuzitian.action_special_effect = (WorldAction)Delegate.Combine(wuzitian.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(wuzitian.id, "天书无字，天无大道");

            ActorTrait XieDragon = new ActorTrait();
            XieDragon.id = "邪龙附身";
            XieDragon.path_icon = "Icons/iconXieDragon";
            XieDragon.needs_to_be_explored = false;
            XieDragon.birth = 0.000001f;
            XieDragon.inherit = 0f;
            XieDragon.baseStats.mod_damage = 2000;
            XieDragon.baseStats.mod_health = 2000;
            XieDragon.baseStats.attackSpeed = 200;
            XieDragon.baseStats.armor = 10;
            AssetManager.traits.add(XieDragon);
            XieDragon.action_death = (WorldAction)Delegate.Combine(XieDragon.action_death, new WorldAction(Reincarnation));
            addTraitToLocalizedLibrary(XieDragon.id, "邪龙显世,天地色变");

            ActorTrait renjian = new ActorTrait();
            renjian.id = "人剑合一";
            renjian.path_icon = "Icons/iconrenjian";
            renjian.needs_to_be_explored = false;
            renjian.birth = 2f;
            renjian.inherit = 0.001f;
            renjian.baseStats.mod_damage = 500;
            renjian.baseStats.armor = -50;
            AssetManager.traits.add(renjian);
            addTraitToLocalizedLibrary(renjian.id, "人剑合一，天下无敌");

            ActorTrait changsheng = new ActorTrait();
            changsheng.id = "天明";
            changsheng.path_icon = "Icons/iconchangsheng";
            changsheng.needs_to_be_explored = false;
            changsheng.opposite = "飞升者";
            changsheng.birth = 0.1f;
            changsheng.baseStats.mod_damage = 500;
            AssetManager.traits.add(changsheng);
            changsheng.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changsheng.action_death = (WorldAction)Delegate.Combine(changsheng.action_death, new WorldAction(WuFa));
            changsheng.action_special_effect = (WorldAction)Delegate.Combine(changsheng.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changsheng.id, "明天地");

            ActorTrait changshengyi = new ActorTrait();
            changshengyi.id = "天门";
            changshengyi.path_icon = "Icons/iconchangshengyi";
            changshengyi.needs_to_be_explored = false;
            changshengyi.opposite = "飞升者";
            changshengyi.birth = 0f;
            changshengyi.baseStats.mod_damage = 5000;
            AssetManager.traits.add(changshengyi);
            changshengyi.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changshengyi.action_special_effect = (WorldAction)Delegate.Combine(changshengyi.action_special_effect, new WorldAction(San1));
            changshengyi.action_special_effect = (WorldAction)Delegate.Combine(changshengyi.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changshengyi.id, "开天门，斗天道");

            ActorTrait changshenger = new ActorTrait();
            changshenger.id = "一圣苍";
            changshenger.path_icon = "Icons/iconchangshenger";
            changshenger.needs_to_be_explored = false;
            changshenger.opposite = "飞升者";
            changshenger.birth = 0f;
            changshenger.baseStats.mod_damage = 10000;
            AssetManager.traits.add(changshenger);
            changshenger.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changshenger.action_special_effect = (WorldAction)Delegate.Combine(changshenger.action_special_effect, new WorldAction(San1));
            changshenger.action_special_effect = (WorldAction)Delegate.Combine(changshenger.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changshenger.id, "开天门，斗天道");

            ActorTrait changshengsan = new ActorTrait();
            changshengsan.id = "二圣苍";
            changshengsan.path_icon = "Icons/iconchangshengsan";
            changshengsan.needs_to_be_explored = false;
            changshengsan.opposite = "飞升者";
            changshengsan.birth = 0f;
            changshengsan.baseStats.mod_damage = 20000;
            AssetManager.traits.add(changshengsan);
            changshengsan.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changshengsan.action_special_effect = (WorldAction)Delegate.Combine(changshengsan.action_special_effect, new WorldAction(San1));
            changshengsan.action_special_effect = (WorldAction)Delegate.Combine(changshengsan.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changshengsan.id, "开天门，斗天道");

            ActorTrait changshengsi = new ActorTrait();
            changshengsi.id = "三圣苍";
            changshengsi.path_icon = "Icons/iconchangshengsi";
            changshengsi.needs_to_be_explored = false;
            changshengsi.opposite = "飞升者";
            changshengsi.birth = 0f;
            changshengsi.baseStats.mod_damage = 30000;
            AssetManager.traits.add(changshengsi);
            changshengsi.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changshengsi.action_special_effect = (WorldAction)Delegate.Combine(changshengsi.action_special_effect, new WorldAction(San1));
            changshengsi.action_special_effect = (WorldAction)Delegate.Combine(changshengsi.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changshengsi.id, "开天门，斗天道");

            ActorTrait changshengwu = new ActorTrait();
            changshengwu.id = "武始苍";
            changshengwu.path_icon = "Icons/iconchangshengwu";
            changshengwu.needs_to_be_explored = false;
            changshengwu.opposite = "飞升者";
            changshengwu.birth = 0f;
            changshengwu.baseStats.mod_damage = 50000;
            AssetManager.traits.add(changshengwu);
            changshengwu.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            changshengwu.action_special_effect = (WorldAction)Delegate.Combine(changshengwu.action_special_effect, new WorldAction(San1));
            changshengwu.action_special_effect = (WorldAction)Delegate.Combine(changshengwu.action_special_effect, new WorldAction(TM));
            addTraitToLocalizedLibrary(changshengwu.id, "开天门，斗天道");

            ActorTrait shadiao = new ActorTrait();
            shadiao.id = "沙雕信徒";
            shadiao.path_icon = "Icons/iconshadiao";
            shadiao.needs_to_be_explored = false;
            shadiao.birth = 0.005f;
            shadiao.inherit = 0.1f;
            shadiao.baseStats.mod_damage = 80;
            shadiao.baseStats.mod_health = 82;
            AssetManager.traits.add(shadiao);
            shadiao.action_special_effect = (WorldAction)Delegate.Combine(shadiao.action_special_effect, new WorldAction(SHADIAO));
            addTraitToLocalizedLibrary(shadiao.id, "信沙雕者可飞升");

            ActorTrait feiying = new ActorTrait();
            feiying.id = "飞影";
            feiying.path_icon = "Icons/iconfeiying";
            feiying.needs_to_be_explored = false;
            feiying.birth = 0.01f;
            feiying.inherit = 0f;
            feiying.baseStats.mod_damage = 45;
            feiying.baseStats.mod_health = 45;
            feiying.baseStats.speed = 36000;
            feiying.baseStats.attackSpeed = 108;
            feiying.baseStats.armor = 20;
            AssetManager.traits.add(feiying);
            addTraitToLocalizedLibrary(feiying.id, "速似飞影");

            ActorTrait shensu = new ActorTrait();
            shensu.id = "神速";
            shensu.path_icon = "Icons/iconshensu";
            shensu.needs_to_be_explored = false;
            shensu.birth = 1f;
            shensu.inherit = 0f;
            shensu.baseStats.mod_damage = 200;
            shensu.baseStats.health = 500;
            shensu.baseStats.attackSpeed = 200;
            shensu.baseStats.armor = 10;
            shensu.baseStats.speed = 360;
            AssetManager.traits.add(shensu);
            shensu.action_death = (WorldAction)Delegate.Combine(shensu.action_death, new WorldAction(SHSU));
            shensu.action_special_effect = (WorldAction)Delegate.Combine(shensu.action_special_effect, new WorldAction(XZ));
            addTraitToLocalizedLibrary(shensu.id, "逃跑大师");

			ActorTrait tianli = new ActorTrait();
			tianli.id = "天生神力";
			tianli.path_icon = "Icons/icontianli";
			tianli.needs_to_be_explored = false;
			tianli.birth = 0.01f;
			tianli.inherit = 10f;
			tianli.baseStats.health = 1000;
			tianli.baseStats.damage = 1000;
            AssetManager.traits.add(tianli);
            addTraitToLocalizedLibrary(tianli.id, "天生神力，力大无穷");

            ActorTrait EasternDragon = new ActorTrait();
			EasternDragon.id = "龙王降世";
			EasternDragon.path_icon = "Icons/iconEasternDragon";
			EasternDragon.needs_to_be_explored = false;
			EasternDragon.birth = 0.01f;
			EasternDragon.inherit = 0.01f;
			EasternDragon.baseStats.mod_damage = 1000f;
            EasternDragon.baseStats.armor = 50;
            EasternDragon.baseStats.attackSpeed = 300;
			EasternDragon.baseStats.speed = 360;
			EasternDragon.baseStats.mod_health = 1000f;
            AssetManager.traits.add(EasternDragon);
            addTraitToLocalizedLibrary(EasternDragon.id, "龙王降世");

            ActorTrait Youss = new ActorTrait();
			Youss.id = "幽天帝传承";
			Youss.path_icon = "Icons/iconYous";
			Youss.needs_to_be_explored = false;
			Youss.birth = 0.001f;
			Youss.inherit = 0.01f;
			Youss.baseStats.mod_damage = 1000f;
            Youss.baseStats.armor = 50;
            Youss.baseStats.attackSpeed = 300;
			Youss.baseStats.speed = 360;
			Youss.baseStats.mod_health = 2000f;
            Youss.baseStats.health = 500;
            AssetManager.traits.add(Youss);
            Youss.action_death = (WorldAction)Delegate.Combine(Youss.action_death, new WorldAction(Youlin));
            addTraitToLocalizedLibrary(Youss.id, "幽天帝传承");

            ActorTrait yuwudi = new ActorTrait();
			yuwudi.id = "无敌附身";
			yuwudi.path_icon = "Icons/iconyuwudi";
			yuwudi.needs_to_be_explored = false;
            yuwudi.opposite = "无敌的诅咒,幽天帝传承";
			yuwudi.birth = 0.005f;
			yuwudi.inherit = 50f;
			yuwudi.baseStats.mod_damage = 1000f;
            yuwudi.baseStats.damage = 500;
            yuwudi.baseStats.armor = 100;
            yuwudi.baseStats.attackSpeed = 300;
			yuwudi.baseStats.mod_health = -72f;
            yuwudi.baseStats.health = 500;
            yuwudi.baseStats.speed = 360;
            AssetManager.traits.add(yuwudi);
            yuwudi.action_death = (WorldAction)Delegate.Combine(yuwudi.action_death, new WorldAction(YUWUDI));
            yuwudi.action_attack_target = (WorldAction)Delegate.Combine(yuwudi.action_attack_target, new WorldAction(wudis));
            yuwudi.action_attack_target = (WorldAction)Delegate.Combine(yuwudi.action_attack_target, new WorldAction(curseds));
            yuwudi.action_death = (WorldAction)Delegate.Combine(yuwudi.action_death, new WorldAction(WD));
            yuwudi.action_special_effect = (WorldAction)Delegate.Combine(yuwudi.action_special_effect, new WorldAction(MI));
            yuwudi.action_special_effect = (WorldAction)Delegate.Combine(yuwudi.action_special_effect, new WorldAction(HF));
            yuwudi.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            addTraitToLocalizedLibrary(yuwudi.id, "无敌附身,天地无敌");

            ActorTrait yuwudis = new ActorTrait();
			yuwudis.id = "无敌临世";
			yuwudis.path_icon = "Icons/iconyuwudi";
			yuwudis.needs_to_be_explored = false;
            yuwudis.opposite = "无敌的诅咒,幽天帝的祝福";
			yuwudis.birth = 0.005f;
			yuwudis.inherit = 50f;
			yuwudis.baseStats.mod_damage = 1000f;
            yuwudis.baseStats.damage = 500;
            yuwudis.baseStats.armor = 100;
            yuwudis.baseStats.attackSpeed = 300;
			yuwudis.baseStats.mod_health = -72f;
            yuwudis.baseStats.health = 1080;
            yuwudis.baseStats.speed = 360;
            yuwudis.can_be_given = false;
            AssetManager.traits.add(yuwudis);
            yuwudis.action_attack_target = (WorldAction)Delegate.Combine(yuwudis.action_attack_target, new WorldAction(wudis));
            yuwudis.action_attack_target = (WorldAction)Delegate.Combine(yuwudis.action_attack_target, new WorldAction(curseds));
            yuwudis.action_special_effect = (WorldAction)Delegate.Combine(yuwudis.action_special_effect, new WorldAction(HF));
            yuwudis.action_special_effect = (WorldAction)Delegate.Combine(yuwudis.action_special_effect, new WorldAction(MI));
            yuwudis.action_attack_self = new WorldAction(ActionLibrary.restoreHealthOnHit);
            addTraitToLocalizedLibrary(yuwudis.id, "无敌附身,天地无敌");
            
            ActorTrait Yous = new ActorTrait();
			Yous.id = "幽天帝的祝福";
			Yous.path_icon = "Icons/iconYous";
			Yous.needs_to_be_explored = false;
			Yous.birth = 0.005f;
			Yous.inherit = 0.01f;
			Yous.baseStats.mod_damage = 500f;
            Yous.baseStats.armor = 1000;
            Yous.baseStats.attackSpeed = 200;
			Yous.baseStats.mod_health = 1000f;
            Yous.baseStats.speed = 360;
            AssetManager.traits.add(Yous);
            Yous.action_death = (WorldAction)Delegate.Combine(Yous.action_death, new WorldAction(Reincarnation));
            addTraitToLocalizedLibrary(Yous.id, "幽天帝的祝福");

            ActorTrait jinzhongzhao = new ActorTrait();
			jinzhongzhao.id = "金钟罩";
			jinzhongzhao.path_icon = "Icons/iconjinzhongzhao";
			jinzhongzhao.needs_to_be_explored = false;
			jinzhongzhao.birth = 0.05f;
			jinzhongzhao.inherit = 0.01f;
            jinzhongzhao.baseStats.armor = 10000000;
            AssetManager.traits.add(jinzhongzhao);
            addTraitToLocalizedLibrary(jinzhongzhao.id, "刀枪不入");

            ActorTrait zhuque = new ActorTrait();
			zhuque.id = "朱雀";
			zhuque.path_icon = "Icons/iconzhuque";
			zhuque.needs_to_be_explored = false;
			zhuque.birth = 0.05f;
			zhuque.inherit = 0.01f;
            zhuque.baseStats.armor = 100;
            zhuque.baseStats.mod_damage = 108f;
            AssetManager.traits.add(zhuque);
            zhuque.action_special_effect = (WorldAction)Delegate.Combine(zhuque.action_special_effect, new WorldAction(HF));
            addTraitToLocalizedLibrary(zhuque.id, "朱雀");

            ActorTrait xuanwu = new ActorTrait();
			xuanwu.id = "玄武";
			xuanwu.path_icon = "Icons/iconxuanwu";
			xuanwu.needs_to_be_explored = false;
			xuanwu.birth = 0.05f;
			xuanwu.inherit = 0.01f;
            xuanwu.baseStats.armor = 10000000;
            xuanwu.baseStats.mod_health = 108f;
            AssetManager.traits.add(xuanwu);
            xuanwu.action_attack_self = (WorldAction)Delegate.Combine(xuanwu.action_attack_self, new WorldAction(ArcanistShield));
            xuanwu.action_special_effect = (WorldAction)Delegate.Combine(xuanwu.action_special_effect, new WorldAction(SanFang));
            addTraitToLocalizedLibrary(xuanwu.id, "玄武");

            ActorTrait baihu = new ActorTrait();
			baihu.id = "白虎";
			baihu.path_icon = "Icons/iconbaihu";
			baihu.needs_to_be_explored = false;
			baihu.birth = 0.05f;
			baihu.inherit = 0.01f;
            baihu.baseStats.armor = 1000;
            baihu.baseStats.mod_damage = 360f;
            AssetManager.traits.add(baihu);
            baihu.action_attack_self = (WorldAction)Delegate.Combine(baihu.action_attack_self, new WorldAction(ArcanistShield));
            baihu.action_special_effect = (WorldAction)Delegate.Combine(baihu.action_special_effect, new WorldAction(SanFang));
            addTraitToLocalizedLibrary(baihu.id, "白虎");

            ActorTrait qinglong = new ActorTrait();
			qinglong.id = "青龙";
			qinglong.path_icon = "Icons/iconqinglong";
			qinglong.needs_to_be_explored = false;
			qinglong.birth = 0.05f;
			qinglong.inherit = 0.01f;
            qinglong.baseStats.armor = 10;
            qinglong.baseStats.mod_damage = 108f;
            qinglong.baseStats.mod_damage = 108f;
            AssetManager.traits.add(qinglong);
            qinglong.action_attack_target = (WorldAction)Delegate.Combine(qinglong.action_attack_target, new WorldAction(linhs));
            qinglong.action_special_effect = (WorldAction)Delegate.Combine(qinglong.action_special_effect, new WorldAction(SanFang));
            addTraitToLocalizedLibrary(qinglong.id, "青龙");

            ActorTrait CGs = new ActorTrait();
			CGs.id = "无敌的诅咒";
			CGs.path_icon = "Icons/icontianqian";
			CGs.needs_to_be_explored = false;
            CGs.opposite = "无敌附身,幽天帝传承,无敌临世";
            CGs.baseStats.armor = -1000;
            CGs.baseStats.mod_damage = -100f;
            CGs.baseStats.damage = -1000;
            CGs.baseStats.mod_health = -100f;
            CGs.baseStats.health = -100;
            CGs.can_be_given = false;
            AssetManager.traits.add(CGs);
            CGs.action_attack_target = (WorldAction)Delegate.Combine(CGs.action_attack_target, new WorldAction(wudis));
            CGs.action_special_effect = (WorldAction)Delegate.Combine(CGs.action_special_effect, new WorldAction(MI));
            addTraitToLocalizedLibrary(CGs.id, "无敌的诅咒");

		}
        [HarmonyPrefix]
        [HarmonyPatch(typeof(ActionLibrary), "giveCursed")]
        public static bool giveCursed_Prefix(ActorBase pActor)
        {
            if (pActor.haveTrait("cursed_immune"))
            {
                return false;
            }
            return true;
        }
        //诅咒周围人
        public static bool BleedingBlade(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                a.addTrait("cursed");
            }
            return true;

        }
        //地震法术
        public static bool EarthCracking(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                if (Toolbox.randomChance(0.05f))
                {
                    MapBox.instance.earthquakeManager.startQuake(pTile, EarthquakeType.RandomPower);
                }
            }
            return true;
        }
        //圣光法术
        public static bool DivineLight(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                if (Toolbox.randomChance(0.1f))
                {
                    ActionLibrary.castCure(pTarget, pTile);
                    a.spawnParticle(Toolbox.color_heal);
                }
            }
            return true;
        }
        //七级轮回
        public static bool WuFa(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level >= 7)
            {
                actorData.level = 1;
            }
            return true;
        }
        //不能修炼
        public static bool QiSi(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level >= 1)
            {
                actorData.level = 1;
            }
            return true;
        }
        public static bool KeSi(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.age == 80)
            {
                actorData.level = 1;
                actorData.health = 1;
                actorData.kills = 1;
            }
            return true;
        }
        //天灾
        public static bool TianZai(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                if (a.haveTrait("天灾之悬"))
                {
                    a.removeTrait("天灾之悬");
                    a.addTrait("天灾降世");
                    a.addTrait("immortal");
                    a.addTrait("madness");
                }

                ActorTool.copyUnitToOtherUnit(a, a);
                a.kingdom = pTarget.kingdom;
            }
            return true;
        }
        //增加300年寿命
        public static bool San1(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 1;
            }
            return true;
        }
        public static bool WuBai(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 1;
            }
            return true;
        }
        public static bool Qian(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 1;
            }
            return true;
        }
        public static void addTraitToLocalizedLibrary(string id, string description)
        {
            string language = Reflection.GetField(LocalizedTextManager.instance.GetType(), LocalizedTextManager.instance, "language") as string;
            Dictionary<string, string> localizedText = Reflection.GetField(LocalizedTextManager.instance.GetType(), LocalizedTextManager.instance, "localizedText") as Dictionary<string, string>;
            localizedText.Add("trait_" + id, id);
            localizedText.Add("trait_" + id + "_info", description);
        }
        //道士加20寿命
        public static bool ShouMing(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 1;
            }
            return true;
        }
        public static bool Reincarnation(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var act = MapBox.instance.createNewUnit(a.stats.id, pTile, null, 0f, null);
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), act, "data");
                a.removeTrait("穿越者");
                a.removeTrait("幽天帝的祝福");
                a.removeTrait("真人");
                a.removeTrait("天师");
                a.removeTrait("陆地神仙");
                a.removeTrait("九天荡魔");
                a.removeTrait("飞升者");
                a.removeTrait("无字天书");
                a.removeTrait("人族大帝");
                a.addTrait("穿越者（重生）");
                ActorTool.copyUnitToOtherUnit(a, act);
                act.kingdom = pTarget.kingdom;

            }
            return true;
        }
        public static bool YUWUDI(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var act = MapBox.instance.createNewUnit(a.stats.id, pTile, null, 0f, null);
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), act, "data");
                a.removeTrait("无敌附身");
                a.addTrait("无敌临世");
                ActorTool.copyUnitToOtherUnit(a, act);
                act.kingdom = pTarget.kingdom;

            }
            return true;
        }
        public static bool Youlin(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var act = MapBox.instance.createNewUnit(a.stats.id, pTile, null, 0f, null);
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), act, "data");
                a.removeTrait("幽天帝传承");
                a.addTrait("幽天帝的祝福");
                ActorTool.copyUnitToOtherUnit(a, act);
                act.kingdom = pTarget.kingdom;

            }
            return true;
        }
        //真武特质
        public static bool ZhenWu(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level == 1)
            {
                actorData.level += 2;
            }
            else if (actorData.level == 11)
            {
            }
            return true;
        }
        public static bool HF(BaseSimObject pTarget, WorldTile pTile = null) 
      	{
          if(pTarget != null){
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
          a.addTrait("fire_proof");
          a.addTrait("pyromaniac");
          a.addTrait("evil");
          a.addTrait("burning_feet");
          }
      		return true;
        }
        public static bool MI(BaseSimObject pTarget, WorldTile pTile = null) 
      	{
          if(pTarget != null){
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
          a.addTrait("madness");
          }
      		return true;
        }
        //护盾
        public static bool ArcanistShield(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                if (Toolbox.randomChance(0.1f))
                {
                    ActionLibrary.castShieldOnHimself(pTarget, pTile);
                }
            }
            return true;
        }
        //陨石法术
        public static bool GravitationalPull(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                if (Toolbox.randomChance(0.1f))
                {
                    ActionLibrary.unluckyMeteorite(pTarget, pTile);
                }
            }
            return true;

        }
        public static bool SanFang(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                a.addTrait("acid_proof");
                a.addTrait("fire_proof");
                a.addTrait("freeze_proof");
                a.addTrait("immune");
                if (actorData.health <= 1)
                {
                    actorData.level += 1;
                }
                if (actorData.level == 1)
                {
                    actorData.health += 500;
                    actorData.level += 1;
                }
            }
            return true;
        }
        //出生三级
        public static bool Duan(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 2;
            }
            return true;
        }
        //霸王
        public static bool San(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                if (actorData.level <= 1)
                {
                    actorData.level += 2;
                }
                if (actorData.level == 10)
                {
                    a.removeTrait("将魂");
                    a.addTrait("霸王");
                }
            }
            return true;
        }
        public static bool XZ(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                if (actorData.level == 2)
                {
                    a.removeTrait("先天");
                    a.addTrait("衍气");
                }
                if (actorData.level == 3)
                {
                    a.removeTrait("衍气");
                    a.addTrait("明道");
                }
                if (actorData.level == 4)
                {
                    a.removeTrait("明道");
                    a.addTrait("悟道");
                }
                if (actorData.level == 5)
                {
                    a.removeTrait("悟道");
                    a.addTrait("开源");
                }
                if (actorData.level == 5)
                {
                    a.removeTrait("先天悟道");
                    a.addTrait("开源");
                }
                if (actorData.level == 6)
                {
                    a.removeTrait("开源");
                    a.addTrait("飞升者");
                }
                if (actorData.level == 8)
                {
                    a.removeTrait("飞升者");
                    a.addTrait("仙宫");
                }
                if (actorData.level == 9)
                {
                    a.removeTrait("仙宫");
                    a.addTrait("星河");
                }
                if (actorData.level == 10)
                {
                    a.removeTrait("星河");
                    a.addTrait("人族大帝");
                }
                if (actorData.level == 12)
                {
                    a.removeTrait("人族大帝");
                    a.addTrait("无字天书");
                }
                if (actorData.level == 14)
                {
                    a.removeTrait("无字天书");
                    a.addTrait("羡尘");
                }
            }
            return true;
        }
        public static bool XTDT(BaseSimObject pTarget, WorldTile pTile = null)
        {
            Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
            if (actorData.level <= 1)
            {
                actorData.level += 3;                
            }
            return true;
        }
        public static bool TM(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                if (actorData.age >= 108)
                {
                    a.removeTrait("天明");
                    a.addTrait("天门");
                }
                if (actorData.age >= 360)
                {
                    a.removeTrait("天门");
                    a.addTrait("一圣苍");
                }
                if (actorData.age >= 720)
                {
                    a.removeTrait("一圣苍");
                    a.addTrait("二圣苍");
                }
                if (actorData.age >= 1080)
                {
                    a.removeTrait("二圣苍");
                    a.addTrait("三圣苍");
                }
                if (actorData.age >= 3600)
                {
                    a.removeTrait("三圣苍");
                    a.addTrait("武始苍");
                }
            }
            return true;
        }
        static bool SHADIAO(BaseSimObject pTarget, WorldTile pTile = null)
        {
            if (pTarget != null)
            {
                Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
                var actorData = (ActorStatus)Reflection.GetField(typeof(Actor), a, "data");
                if (actorData.age >= 18)
                {
                    a.removeTrait("沙雕信徒");
                    a.addTrait("飞升者"); 
                    actorData.level += 8;
                }
            }
            return true;
        }
        public static bool SHSU(BaseSimObject pTarget, WorldTile pTile = null)
        {
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
          ActorStatus Data = Reflection.GetField(a.GetType(), pTarget, "data") as ActorStatus;
          if(Toolbox.randomChance(0.1f)){
            ActionLibrary.teleportRandom(pTarget, pTile); 
          }
          else if(Data.health <= 50){
            ActionLibrary.teleportRandom(pTarget, pTile);             
           }
          return true;
        }
        public static bool WD(BaseSimObject pTarget, WorldTile pTile = null)
        {
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
          ActorStatus Data = Reflection.GetField(a.GetType(), pTarget, "data") as ActorStatus;
          if(Toolbox.randomChance(0.1f)){
            ActionLibrary.teleportRandom(pTarget, pTile); 
          }
          else if(Data.health <= 30){
            ActionLibrary.teleportRandom(pTarget, pTile);             
           }
          return true;
        }
        public static bool linhs(BaseSimObject pTarget, WorldTile pTile = null)
        {
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
          ActorStatus Data = Reflection.GetField(a.GetType(), pTarget, "data") as ActorStatus;
           if(Toolbox.randomChance(10f)){
            ActionLibrary.teleportRandom(pTarget, pTile); 
          } 
            return true;
        }
        public static bool curseds(BaseSimObject pTarget, WorldTile pTile = null) 
      	{
          if(pTarget != null){
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            if(Toolbox.randomChance(0.9f)){
              MapBox.instance.CallMethod("getObjectsInChunks", pTile, 3, MapObjectType.Actor);
              var temp_map_objects = Reflection.GetField(MapBox.instance.GetType(), MapBox.instance, "temp_map_objects") as List<BaseSimObject>;
              for (int i = 0; i < temp_map_objects.Count; i++)
              {
                  Actor actor = (Actor)temp_map_objects[i];
                      actor.addTrait("无敌的诅咒");
                      actor.spawnParticle(Toolbox.color_plague);
                   }
                }
              }
              return true;
        }
        public static bool wudis(BaseSimObject pTarget, WorldTile pTile = null) 
      	{
          if(pTarget != null){
          Actor a = Reflection.GetField(pTarget.GetType(), pTarget, "a") as Actor;
            if(Toolbox.randomChance(0.3f)){
              MapBox.instance.CallMethod("getObjectsInChunks", pTile, 3, MapObjectType.Actor);
              var temp_map_objects = Reflection.GetField(MapBox.instance.GetType(), MapBox.instance, "temp_map_objects") as List<BaseSimObject>;
              for (int i = 0; i < temp_map_objects.Count; i++)
              {
                  Actor actor = (Actor)temp_map_objects[i];
                      actor.addTrait("无敌附身");
                      actor.spawnParticle(Toolbox.color_plague);
                   }
                }
              }
              return true;
        }
    }
}

