﻿using System;
using HarmonyLib;
using NCMS;
using NCMS.Utils;
using ReflectionUtility;
using UnityEngine;
using UnityEngine.UI;

namespace MultipleSpawn {
    [ModEntry]
    public class Main : MonoBehaviour {
        // spwan 倍数
        private static int multipleSize = 1;

        // 左侧按钮
        private GameObject leftMultipleButton;

        // mod根目录
        public static string mainPath = "Mods/MultipleSpawn";

        // 控制左侧按钮显隐
        private static bool leftButtonIsShow = false;
        
        // 主菜单按钮n位置
        private static Vector2 mainButtonLocalPosition = new Vector2(250,-17);

        private void Awake() {
            Harmony.CreateAndPatchAll(typeof(Main));
            InitButton();
        }
        
        private void InitButton() {
            InitMainButton();
            InitLeftButton();
        }

        /// <summary>
        /// 初始化左侧按钮
        /// </summary>
        private void InitLeftButton() {
            GameObject copyTabButton = GameObjects.FindEvenInactive("SideCenterLeft");
            Vector3 transformLocalPosition = copyTabButton.transform.localPosition;
            if (copyTabButton != null) {
                GameObject instantiate = Instantiate(copyTabButton, copyTabButton.transform.parent, true);
                instantiate.name = "MultipleSpawnCenterLeft";
                instantiate.transform.localScale = new Vector3(1f, 1f);
                instantiate.transform.localPosition = new Vector3(transformLocalPosition.x,transformLocalPosition.y + 100,0);
                
                Transform cancelButtonMover = instantiate.transform.GetChild(0);
                Transform cancelButton = cancelButtonMover.GetChild(0);
                // 注册按钮点击事件
                cancelButton.GetComponent<Button>().onClick
                    .AddListener(LeftMultipleButtonHide);
                // 设置Icon
                var icon = cancelButton.GetChild(1).GetComponent<Image>();

                // 修改复制过来的gameobject名称
                Transform multipleButtonMover = instantiate.transform.GetChild(2);
                multipleButtonMover.name = "MultipleButtonMover";
                Transform multipleSize = multipleButtonMover.GetChild(0);
                multipleSize.name = "MultipleSize";

                // 设置左侧按钮 常显/已选择 默认的图片
                multipleSize.GetChild(1).GetComponent<Image>().sprite =
                    Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_icon/x1.png");

                Transform buttons = multipleSize.GetChild(2);
                // 初始化按钮图片和各个按钮对应的spawn倍数
                InitButtonImageAndMultipleSize(buttons);

                for (int i = 0; i < 4; i++) {
                    Button button = buttons.GetChild(i).GetComponent<Button>();
                    Sprite sprite = button.transform.GetChild(1).GetComponent<Image>().sprite;
                    button.onClick.AddListener(() => {
                        multipleSize.GetChild(1).GetComponent<Image>().sprite = sprite;
                        Main.multipleSize = button.GetComponent<MultipleSpawnConfig>().multipleSize;
                        buttons.gameObject.SetActive(false);
                    });
                    PowerButton powerButton = buttons.GetChild(i).GetComponent<PowerButton>();
                    Destroy(powerButton);
                }

                icon.sprite = Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_number.png");
                leftMultipleButton = instantiate;
            }
        }

        /// <summary>
        /// 初始化按钮图片和各个按钮对应的spawn倍数
        /// </summary>
        /// <param name="buttons"></param>
        private static void InitButtonImageAndMultipleSize(Transform buttons) {
            Transform x1 = buttons.GetChild(0);
            Transform x10 = buttons.GetChild(1);
            Transform x100 = buttons.GetChild(2);
            Transform x1000 = buttons.GetChild(3);
            x1.transform.GetChild(1).GetComponent<Image>().sprite =
                Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_icon/x1.png");
            x10.transform.GetChild(1).GetComponent<Image>().sprite =
                Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_icon/x10.png");
            x100.transform.GetChild(1).GetComponent<Image>().sprite =
                Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_icon/x100.png");
            x1000.transform.GetChild(1).GetComponent<Image>().sprite =
                Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_icon/x1000.png");
            x1.gameObject.AddComponent<MultipleSpawnConfig>().multipleSize = 1;
            x10.gameObject.AddComponent<MultipleSpawnConfig>().multipleSize = 10;
            x100.gameObject.AddComponent<MultipleSpawnConfig>().multipleSize = 100;
            x1000.gameObject.AddComponent<MultipleSpawnConfig>().multipleSize = 1000;
        }

        /// <summary>
        /// 初始化主页面mod按钮
        /// </summary>
        private void InitMainButton() {
            Vector3 transformLocalPosition = GameObjects.FindEvenInactive("SettingsButton").transform.localPosition;
            Vector3 v3 = new Vector3(transformLocalPosition.x, transformLocalPosition.y - 36, 0);
            var sprite = Sprites.LoadSprite($"{Main.mainPath}/EmbededResources/icons/multiple_number.png");
            var button = PowerButtons.CreateButton("MultipleSpawnButton", sprite, "批量生成",
                "这个按钮可以帮你批量生成动物，生物和怪物", Vector2.zero, ButtonType.Click, null,
                MultipleMainButtonClick);
            
            PowerButtons.AddButtonToTab(button, PowerTab.Main, v3);
        }

        /// <summary>
        /// 主页面按钮被点击事件
        /// </summary>
        public void MultipleMainButtonClick() {
            Toggle();
        }

        /// <summary>
        /// 主页面按钮点击开关
        /// </summary>
        private void Toggle() {
            if (leftButtonIsShow) {
                // 隐藏
                LeftMultipleButtonHide();
            } else {
                // 显示
                LeftMultipleButtonShow();
            }
        }

        private void LeftMultipleButtonShow() {
            GameObject copyTabButton = GameObjects.FindEvenInactive("SideCenterLeft");
            Vector3 transformLocalPosition = copyTabButton.transform.localPosition;
            leftMultipleButton.transform.localPosition = new Vector3(transformLocalPosition.x,transformLocalPosition.y + 100,0);
            var cancelButtonMover = leftMultipleButton.transform.GetChild(0);
            var multipleSpawnButtonMover = leftMultipleButton.transform.GetChild(2);
            var cancelMover = cancelButtonMover.GetComponent<UiMover>();
            var multipleMover = multipleSpawnButtonMover.GetComponent<UiMover>();
            cancelMover.transform.localPosition = new Vector3(25.0f, -25.0f, 0.0f);
            multipleMover.transform.localPosition = new Vector3(25.0f, 25.0f, 0.0f);
            leftButtonIsShow = true;
        }

        private void LeftMultipleButtonHide() {
            var CancelButtonMover = leftMultipleButton.transform.GetChild(0);
            var MultipleSpawnButtonMover = leftMultipleButton.transform.GetChild(2);
            var cancelMover = CancelButtonMover.GetComponent<UiMover>();
            var MultipleMover = MultipleSpawnButtonMover.GetComponent<UiMover>();
            cancelMover.transform.localPosition = new Vector3(-150.0f, -25.0f, 0.0f);
            MultipleMover.transform.localPosition = new Vector3(-150.0f, 25.0f, 0.0f);
            leftButtonIsShow = false;
        }

        /// <summary>
        /// Patching WorldTile的spawnUnit方法
        /// 实现倍数spawn生物
        /// </summary>
        /// <param name="pTile"></param>
        /// <param name="pPowerID"></param>
        /// <param name="__instance"></param>
        [HarmonyPrefix, HarmonyPatch(typeof(PowerLibrary), "spawnUnit")]
        public static void
            spawnUnit_prefix_patching(ref WorldTile pTile, ref string pPowerID, PowerLibrary __instance) {
            GodPower godPower = __instance.get(pPowerID);
            string pStatsID;
            if (godPower.actorStatsId.Contains(",")) {
                pStatsID = Toolbox.getRandom<string>(godPower.actorStatsId.Split(','));
            } else
                pStatsID = godPower.actorStatsId;

            // 倍数spawn
            for (int i = 0; i < multipleSize - 1; i++) {
                MapBox.instance.spawnNewUnit(pStatsID, pTile, pSpawnHeight: godPower.actorSpawnHeight);
            }
        }
        

    }
}