﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Cultivation_Way;
using Cultivation_Way.Content;
using Cultivation_Way.Library;
using ReflectionUtility;
using UnityEngine;
namespace CW_Addon_Fantasy_Creatures.Code
{
    internal class Helper
    {
        public static CW_ActorStats add_fantasy_creature(string id, string locale_name, string icon_name)
        {
            CW_ActorStats cw_actor_stats = CW_Library_Manager.instance.units.clone(id, "deer");
            cw_actor_stats.culti_velo = 1;
            ActorStats origin = cw_actor_stats.origin_stats;
            origin.take_items = false;
            origin.use_items = true;
            origin.diet_meat = true;
            origin.diet_vegetation = true;
            origin.diet_flowers = true;
            origin.diet_crops = true;
            origin.diet_meat_insect = true;
            origin.icon = icon_name;
            origin.texture_path = "t_" + id;
            origin.nameLocale = locale_name;
            addColorSet(origin, "default", "#BFBFBF", "#FFFFFF");
            addColorSet(origin, "default", "#825D45", "#2D2D2D");
            AssetManager.unitStats.CallMethod("loadShadow", origin);

            GodPower power = AssetManager.powers.clone("spawn_"+locale_name, "_spawnActor");
            power.name = locale_name;
            power.spawnSound = "spawnHuman";
            power.actorStatsId = id;
            power.click_action = new PowerActionWithID((WorldTile pTile, string pPower) =>
            {
                return (bool)AssetManager.powers.CallMethod("spawnUnit", pTile, pPower);
            });

            W_Content_Tab.add_button(
                W_Content_Tab.create_button(
                    "spawn_"+locale_name, "ui/Icons/"+icon_name,
                    null, NCMS.Utils.ButtonType.GodPower
                    ),
                CW_Tab_Button_Type.ACTOR
                );
            return cw_actor_stats;
        }
        private static void addColorSet(ActorStats stats, string pID, string pColorFrom, string pColorTo)
        {
            stats.useSkinColors = true;
            if (stats.color_sets == null)
            {
                stats.color_sets = new List<ColorSet>();
            }
            ColorSet colorSet = new ColorSet();
            colorSet.id = pID;
            stats.color_sets.Add(colorSet);
            Color color = Toolbox.makeColor(pColorFrom, -1f);
            Color color2 = Toolbox.makeColor(pColorTo, -1f);
            int num = 5;
            float num2 = 1f / (float)(num - 1);
            for (int i = 0; i < num; i++)
            {
                float num3 = 1f - (float)i * num2;
                if (num3 > 1f)
                {
                    num3 = 1f;
                }
                Color color3 = Toolbox.blendColor(color, color2, num3);
                colorSet.colors.Add(color3);
            }
        }
    }
}
