/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.heaven.util.util;

import com.github.houbb.heaven.util.lang.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AbbreviationUtil {
    private static final Map<String, String> MAP = new ConcurrentHashMap<String, String>();

    private AbbreviationUtil() {
    }

    public static void set(String shortName, String fullName) {
        MAP.put(shortName, fullName);
    }

    public static String get(String shortName) {
        return MAP.get(shortName);
    }

    public static String getOrDefault(String shortName, String defaultValue) {
        String value = MAP.get(shortName);
        if (StringUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    static {
        MAP.put("impl", "implements");
        MAP.put("msg", "message");
        MAP.put("err", "error");
        MAP.put("e", "exception");
        MAP.put("ex", "exception");
        MAP.put("doc", "document");
        MAP.put("val", "value");
        MAP.put("num", "number");
        MAP.put("vo", "value object");
        MAP.put("dto", "data transfer object");
        MAP.put("gen", "generate");
        MAP.put("dir", "directory");
        MAP.put("init", "initialize");
        MAP.put("cfg", "config");
        MAP.put("arg", "argument");
        MAP.put("args", "arguments");
    }
}

