/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.util;

import atlantafx.base.util.MaskChar;
import atlantafx.base.util.SimpleMaskChar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import org.jetbrains.annotations.Nullable;

public class MaskTextFormatter
extends TextFormatter<String> {
    protected final MaskTextFilter filter;

    protected MaskTextFormatter(MaskTextFilter filter) {
        super((UnaryOperator)filter);
        this.filter = filter;
    }

    public static TextField createTextField(String mask) {
        return MaskTextFormatter.createTextField(MaskTextFormatter.fromString(mask));
    }

    public static TextField createTextField(List<MaskChar> mask) {
        TextField field = new TextField();
        MaskTextFormatter.create(field, mask);
        return field;
    }

    public static MaskTextFormatter create(TextField field, String mask) {
        return MaskTextFormatter.create(field, MaskTextFormatter.fromString(mask));
    }

    public static MaskTextFormatter create(TextField field, List<MaskChar> mask) {
        Objects.requireNonNull(field, "Text field can't be null");
        if (mask == null || mask.isEmpty()) {
            throw new IllegalArgumentException("Input mask can't be null or empty.");
        }
        String placeholder = MaskTextFormatter.createPlaceholderMask(mask);
        MaskTextFilter filter = new MaskTextFilter(mask);
        field.focusedProperty().addListener((obs, old, val) -> {
            String text = field.getText();
            String prompt = field.getPromptText();
            if (val.booleanValue()) {
                if (text == null || text.isBlank()) {
                    filter.doInternalChange(() -> field.setText(placeholder));
                    int caretPos = IntStream.range(0, mask.size()).filter(i -> !((MaskChar)mask.get(i)).isFixed()).findFirst().orElse(0);
                    Platform.runLater(() -> {
                        field.deselect();
                        field.positionCaret(caretPos);
                    });
                }
            } else if (prompt != null && !prompt.isBlank() && Objects.equals(placeholder, text)) {
                filter.doInternalChange(() -> field.setText(""));
            }
        });
        field.promptTextProperty().addListener((obs, old, val) -> {
            if (val == null || val.isBlank()) {
                filter.doInternalChange(() -> field.setText(placeholder));
            } else {
                filter.doInternalChange(() -> field.setText(""));
            }
        });
        MaskTextFormatter formatter = new MaskTextFormatter(filter);
        field.setTextFormatter((TextFormatter)formatter);
        filter.doInternalChange(() -> field.setText(placeholder));
        return formatter;
    }

    protected static String createPlaceholderMask(String inputMask) {
        return MaskTextFormatter.createPlaceholderMask(MaskTextFormatter.fromString(inputMask));
    }

    protected static String createPlaceholderMask(List<MaskChar> mask) {
        return mask.stream().map(mc -> Character.toString(mc.getPlaceholder())).collect(Collectors.joining());
    }

    protected static List<MaskChar> fromString(String inputMask) {
        if (inputMask == null || inputMask.trim().isEmpty()) {
            throw new IllegalArgumentException("Input mask can't be null or empty.");
        }
        ArrayList<SimpleMaskChar> mask = new ArrayList<SimpleMaskChar>(inputMask.trim().length());
        for (int i = 0; i < inputMask.length(); ++i) {
            char curChar = inputMask.charAt(i);
            SimpleMaskChar maskChar = switch (curChar) {
                case 'A' -> new SimpleMaskChar(Character::isLetter);
                case 'N' -> new SimpleMaskChar(Character::isLetterOrDigit);
                case 'X' -> new SimpleMaskChar(ch -> !Character.isSpaceChar(ch.charValue()));
                case 'H' -> new SimpleMaskChar(ch -> ch.charValue() >= 'A' && ch.charValue() <= 'F' || ch.charValue() >= 'a' && ch.charValue() <= 'f' || Character.isDigit(ch.charValue()));
                case 'D' -> new SimpleMaskChar(ch -> Character.isDigit(ch.charValue()) && ch.charValue() != '0');
                case '9' -> new SimpleMaskChar(Character::isDigit);
                case '8' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '8');
                case '7' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '7');
                case '6' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '6');
                case '5' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '5');
                case '4' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '4');
                case '3' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '3');
                case '2' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '2');
                case '1' -> new SimpleMaskChar(ch -> ch.charValue() >= '0' && ch.charValue() <= '1');
                case '0' -> new SimpleMaskChar(ch -> ch.charValue() == '0');
                default -> SimpleMaskChar.fixed(curChar);
            };
            mask.add(maskChar);
        }
        return Collections.unmodifiableList(mask);
    }

    protected static class MaskTextFilter
    implements UnaryOperator<TextFormatter.Change> {
        protected final List<MaskChar> mask;
        protected boolean ignoreFilter;

        public MaskTextFilter(List<MaskChar> mask) {
            this.mask = Objects.requireNonNull(mask);
        }

        public boolean isInternalChange() {
            return this.ignoreFilter;
        }

        public void doInternalChange(Runnable r) {
            try {
                this.ignoreFilter = true;
                r.run();
            }
            finally {
                this.ignoreFilter = false;
            }
        }

        @Override
        public TextFormatter.Change apply(TextFormatter.Change change) {
            if (!change.isContentChange() || this.isInternalChange()) {
                return change;
            }
            return this.correctContentChange(change);
        }

        @Nullable
        protected TextFormatter.Change correctContentChange(TextFormatter.Change change) {
            String newText = null;
            if (change.isReplaced()) {
                newText = this.correctReplacedText(change);
            } else if (change.isAdded()) {
                newText = this.correctAddedText(change);
            } else if (change.isDeleted()) {
                newText = this.correctDeletedText(change);
            }
            if (newText != null) {
                int start = change.getRangeStart();
                change.setRange(start, Math.min(start + newText.length(), change.getControlText().length()));
                change.setText(newText);
            }
            this.adjustCaretPosition(change);
            return newText != null ? change : null;
        }

        @Nullable
        protected String correctReplacedText(TextFormatter.Change change) {
            int i;
            int start = change.getRangeStart();
            int end = change.getRangeEnd();
            String changedText = change.getText();
            StringBuilder newText = new StringBuilder(end - start);
            for (i = start; i - start < changedText.length() && i < end && i < this.mask.size(); ++i) {
                char ch = changedText.charAt(i - start);
                if (!this.mask.get(i).isAllowed(ch)) {
                    return null;
                }
                newText.append(this.mask.get(i).transform(ch));
            }
            for (i = start + changedText.length(); i < end && i < this.mask.size(); ++i) {
                newText.append(this.mask.get(i).getPlaceholder());
            }
            return newText.toString();
        }

        @Nullable
        protected String correctAddedText(TextFormatter.Change change) {
            int start = change.getRangeStart();
            String changedText = change.getText();
            StringBuilder newText = new StringBuilder(changedText.length());
            for (int i = start; i - start < changedText.length() && i < this.mask.size(); ++i) {
                char ch = changedText.charAt(i - start);
                if (!this.mask.get(i).isAllowed(ch)) {
                    return null;
                }
                newText.append(this.mask.get(i).transform(ch));
            }
            return newText.toString();
        }

        protected String correctDeletedText(TextFormatter.Change change) {
            int i;
            int start = change.getRangeStart();
            int end = change.getRangeEnd();
            StringBuilder newText = new StringBuilder(end - start);
            for (i = start; i < end; ++i) {
                newText.append(this.mask.get(i).getPlaceholder());
            }
            i = start;
            while (i > 0 && this.mask.get(i).isFixed()) {
                newText.insert(0, this.mask.get(i - 1).getPlaceholder());
                --i;
                --start;
            }
            change.setRange(start, end);
            return newText.toString();
        }

        protected void adjustCaretPosition(TextFormatter.Change change) {
            int newPos;
            int oldPos = change.getControlCaretPosition();
            if (oldPos != (newPos = Math.min(change.getCaretPosition(), this.mask.size()))) {
                int sign;
                int n = sign = newPos > oldPos ? 1 : -1;
                while (newPos > 0 && newPos < this.mask.size() && this.mask.get(newPos).isFixed()) {
                    newPos += sign;
                }
                while (newPos < this.mask.size() && this.mask.get(newPos).isFixed()) {
                    ++newPos;
                }
            }
            newPos = Math.min(newPos, change.getControlNewText().length());
            if (change.getAnchor() == change.getCaretPosition()) {
                change.setAnchor(newPos);
            }
            change.setCaretPosition(newPos);
        }
    }
}

