/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import java.util.Objects;
import java.util.function.BiConsumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.jetbrains.annotations.Nullable;

final class SlotListener
implements ChangeListener<Node> {
    private static final PseudoClass FILLED = PseudoClass.getPseudoClass((String)"filled");
    private final Pane slot;
    @Nullable
    private final BiConsumer<Node, Boolean> onContentUpdate;

    public SlotListener(Pane slot) {
        this((Node)slot, null);
    }

    public SlotListener(Node slot, @Nullable BiConsumer<Node, Boolean> onContentUpdate) {
        Pane pane;
        Objects.requireNonNull(slot, "Slot cannot be null.");
        this.onContentUpdate = onContentUpdate;
        if (!(slot instanceof Pane)) {
            throw new IllegalArgumentException("Invalid slot type. Pane is required.");
        }
        this.slot = pane = (Pane)slot;
    }

    public void changed(ObservableValue<? extends Node> obs, Node old, Node val) {
        if (val != null) {
            this.slot.getChildren().setAll((Object[])new Node[]{val});
        } else {
            this.slot.getChildren().clear();
        }
        this.slot.setVisible(val != null);
        this.slot.setManaged(val != null);
        this.slot.pseudoClassStateChanged(FILLED, val != null);
        if (this.onContentUpdate != null) {
            this.onContentUpdate.accept(val, val != null);
        }
    }
}

