/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

abstract class FieldWriterInt32<T>
extends FieldWriter<T> {
    final boolean toString;

    protected FieldWriterInt32(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldType, fieldClass, field, method);
        this.toString = (features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L || "string".equals(format);
    }

    @Override
    public final void writeInt32(JSONWriter jsonWriter, int value) {
        if (this.toString) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeString(Integer.toString(value));
            return;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeInt32(value);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Integer value;
        try {
            value = (Integer)this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask)) == 0L) {
                return false;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeNumberNull();
            return true;
        }
        this.writeInt32(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Integer value = (Integer)this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNumberNull();
            return;
        }
        jsonWriter.writeInt32(value);
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == this.fieldClass) {
            return ObjectWriterImplInt32.INSTANCE;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }
}

