/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.modules.ObjectCodecProvider;
import com.alibaba.fastjson2.modules.ObjectReaderAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ByteArrayValueConsumer;
import com.alibaba.fastjson2.reader.CharArrayValueConsumer;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderCreatorASM;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.support.LambdaMiscCodec;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderProvider
implements ObjectCodecProvider {
    static final ClassLoader FASTJSON2_CLASS_LOADER;
    public static final boolean SAFE_MODE;
    static final String[] DENYS;
    static final String[] AUTO_TYPE_ACCEPT_LIST;
    static JSONReader.AutoTypeBeforeHandler DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    static Consumer<Class> DEFAULT_AUTO_TYPE_HANDLER;
    static boolean DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR;
    static ObjectReaderCachePair readerCache;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Integer, ConcurrentHashMap<Long, ObjectReader>> tclHashCaches = new ConcurrentHashMap<Integer, ConcurrentHashMap<Long, ObjectReader>>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final LRUAutoTypeCache autoTypeList = new LRUAutoTypeCache(1024);
    private final ConcurrentMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
    final ObjectReaderCreator creator;
    final List<ObjectReaderModule> modules = new ArrayList<ObjectReaderModule>();
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    private JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    private Consumer<Class> autoTypeHandler = DEFAULT_AUTO_TYPE_HANDLER;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader()) {
            int tclHash = System.identityHashCode(tcl);
            ConcurrentHashMap tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            if (tclHashCache == null) {
                this.tclHashCaches.putIfAbsent(tclHash, new ConcurrentHashMap());
                tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            }
            tclHashCache.putIfAbsent(hashCode, objectReader);
        }
        this.hashCache.putIfAbsent(hashCode, objectReader);
    }

    public void addAutoTypeAccept(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.acceptHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.acceptHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
            Arrays.sort(hashCodes);
            this.acceptHashCodes = hashCodes;
        }
    }

    public void addAutoTypeDeny(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.denyHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.denyHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.denyHashCodes, 0, hashCodes, 0, this.denyHashCodes.length);
            Arrays.sort(hashCodes);
            this.denyHashCodes = hashCodes;
        }
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    @Override
    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public void registerSeeAlsoSubType(Class subTypeClass) {
        this.registerSeeAlsoSubType(subTypeClass, null);
    }

    public void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderSeeAlso readerSeeAlso;
        ObjectReaderSeeAlso readerSeeAlsoNew;
        Class superClass = subTypeClass.getSuperclass();
        if (superClass == null) {
            throw new JSONException("superclass is null");
        }
        ObjectReader objectReader = this.getObjectReader(superClass);
        if (objectReader instanceof ObjectReaderSeeAlso && (readerSeeAlsoNew = (readerSeeAlso = (ObjectReaderSeeAlso)objectReader).addSubType(subTypeClass, subTypeClassName)) != readerSeeAlso) {
            if (this.cache.containsKey(superClass)) {
                this.cache.put(superClass, readerSeeAlsoNew);
            } else {
                this.cacheFieldBased.put(subTypeClass, readerSeeAlsoNew);
            }
        }
    }

    public ObjectReader register(Type type, ObjectReader objectReader) {
        if (objectReader == null) {
            return (ObjectReader)this.cache.remove(type);
        }
        return this.cache.put(type, objectReader);
    }

    public ObjectReader registerIfAbsent(Type type, ObjectReader objectReader) {
        return this.cache.putIfAbsent(type, objectReader);
    }

    public ObjectReader unregisterObjectReader(Type type) {
        return (ObjectReader)this.cache.remove(type);
    }

    public boolean unregisterObjectReader(Type type, ObjectReader reader) {
        return this.cache.remove(type, reader);
    }

    public boolean register(ObjectReaderModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public boolean unregister(ObjectReaderModule module) {
        return this.modules.remove(module);
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        for (ConcurrentHashMap tlc : this.tclHashCaches.values()) {
            Iterator it = tlc.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ObjectReader reader = (ObjectReader)entry.getValue();
                if (reader.getObjectClass() != objectClass) continue;
                it.remove();
            }
        }
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectReader objectReader, ClassLoader classLoader) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)objectType;
            Type rawType = paramType.getRawType();
            if (ObjectReaderProvider.match(rawType, objectReader, classLoader)) {
                return true;
            }
            Type[] typeArray = paramType.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type argType = typeArray[i];
                if (!ObjectReaderProvider.match(argType, objectReader, classLoader)) continue;
                return true;
            }
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            ObjectReaderImplMapTyped mapTyped = (ObjectReaderImplMapTyped)objectReader;
            Class valueClass = mapTyped.valueClass;
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            return keyClass != null && keyClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplList) {
            ObjectReaderImplList list = (ObjectReaderImplList)objectReader;
            return list.itemClass != null && list.itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplOptional) {
            Class itemClass = ((ObjectReaderImplOptional)objectReader).itemClass;
            return itemClass != null && itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderAdapter) {
            FieldReader[] fieldReaders;
            for (FieldReader fieldReader : fieldReaders = ((ObjectReaderAdapter)objectReader).fieldReaders) {
                if (fieldReader.fieldClass != null && fieldReader.fieldClass.getClassLoader() == classLoader) {
                    return true;
                }
                Type fieldType = fieldReader.fieldType;
                if (!(fieldType instanceof ParameterizedType) || !ObjectReaderProvider.match(fieldType, null, classLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        this.mixInCache.entrySet().removeIf(entry -> ((Class)entry.getKey()).getClassLoader() == classLoader);
        this.cache.entrySet().removeIf(entry -> ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader));
        this.cacheFieldBased.entrySet().removeIf(entry -> ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader));
        int tclHash = System.identityHashCode(classLoader);
        this.tclHashCaches.remove(tclHash);
        BeanUtils.cleanupCache(classLoader);
    }

    public ObjectReaderCreator getCreator() {
        ObjectReaderCreator contextCreator = JSONFactory.getContextReaderCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public ObjectReaderProvider() {
        long[] hashCodes;
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        ObjectReaderCreator creator = null;
        switch (JSONFactory.CREATOR) {
            case "reflect": 
            case "lambda": {
                creator = ObjectReaderCreator.INSTANCE;
                break;
            }
            default: {
                try {
                    if (!JDKUtils.ANDROID && !JDKUtils.GRAAL) {
                        creator = ObjectReaderCreatorASM.INSTANCE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (creator != null) break;
                creator = ObjectReaderCreator.INSTANCE;
            }
        }
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        long[] hashCodes;
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
        this.modules.add(new ObjectReaderBaseModule(this));
        this.init();
    }

    void init() {
        for (ObjectReaderModule module : this.modules) {
            module.init(this);
        }
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    public Function registerTypeConvert(Type from, Type to, Function typeConvert) {
        Map map = (Map)this.typeConverts.get(from);
        if (map == null) {
            this.typeConverts.putIfAbsent(from, new ConcurrentHashMap());
            map = (Map)this.typeConverts.get(from);
        }
        return map.put(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        int tclHash;
        ConcurrentHashMap tclHashCache;
        ObjectReaderCachePair pair = readerCache;
        if (pair != null) {
            if (pair.hashCode == hashCode) {
                return pair.reader;
            }
            if (pair.missCount++ > 16) {
                readerCache = null;
            }
        }
        Long hashCodeObj = new Long(hashCode);
        ObjectReader objectReader = null;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != FASTJSON2_CLASS_LOADER && (tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash = System.identityHashCode(tcl))) != null) {
            objectReader = (ObjectReader)tclHashCache.get(hashCodeObj);
        }
        if (objectReader == null) {
            objectReader = (ObjectReader)this.hashCache.get(hashCodeObj);
        }
        if (objectReader != null && readerCache == null) {
            readerCache = new ObjectReaderCachePair(hashCode, objectReader);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class<?> autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        if (autoTypeClass != expectClass) {
            this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        }
        return objectReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void afterAutoType(String typeName, Class type) {
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(type);
        }
        LRUAutoTypeCache lRUAutoTypeCache = this.autoTypeList;
        synchronized (lRUAutoTypeCache) {
            this.autoTypeList.putIfAbsent(typeName, new Date());
        }
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, long features) {
        Class clazz;
        int ch;
        int i;
        long hash;
        boolean autoTypeSupport;
        Class<?> resolvedClass;
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            this.afterAutoType(typeName, resolvedClass);
            return resolvedClass;
        }
        if (SAFE_MODE) {
            return null;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (typeName.charAt(0) == '[') {
            String componentTypeName = typeName.substring(1);
            this.checkAutoType(componentTypeName, null, features);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            this.afterAutoType(typeName, expectClass);
            return expectClass;
        }
        boolean bl = autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass(typeName)) != null) {
                    if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                        throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                    }
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getMapping(typeName) != null) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                    throw new JSONException("autoType is not support. " + typeName);
                }
                if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (clazz != null && expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                this.afterAutoType(typeName, clazz);
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            return null;
        }
        clazz = TypeUtils.getMapping(typeName);
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            this.afterAutoType(typeName, clazz);
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName);
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || JDKUtils.isSQLDataSourceOrRowSet(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if ((features & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) != 0L) {
                    return expectClass;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        this.afterAutoType(typeName, clazz);
        return clazz;
    }

    public List<ObjectReaderModule> getModules() {
        return this.modules;
    }

    public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
        for (ObjectReaderModule module : this.modules) {
            module.getBeanInfo(beanInfo, objectClass);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
        for (ObjectReaderModule module : this.modules) {
            module.getFieldInfo(fieldInfo, objectClass, field);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Parameter parameter) {
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, constructor, paramIndex, parameter);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex, Parameter parameter) {
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, method, paramIndex, parameter);
        }
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public Function<Consumer, ByteArrayValueConsumer> createValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return this.creator.createByteArrayValueConsumerCreator(objectClass, fieldReaderArray);
    }

    public Function<Consumer, CharArrayValueConsumer> createCharArrayValueConsumerCreator(Class objectClass, FieldReader[] fieldReaderArray) {
        return this.creator.createCharArrayValueConsumerCreator(objectClass, fieldReaderArray);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        ObjectReader previous;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader != null) {
            return objectReader;
        }
        for (ObjectReaderModule module : this.modules) {
            ObjectReader previous2;
            objectReader = module.getObjectReader(this, (Type)objectType);
            if (objectReader == null) continue;
            ObjectReader objectReader3 = previous2 = fieldBased ? this.cacheFieldBased.putIfAbsent((Type)objectType, objectReader) : this.cache.putIfAbsent((Type)objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3 = this.getPreviousObjectReader(fieldBased, (Type)objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(typeArguments.length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4 = this.getPreviousObjectReader(fieldBased, (Type)objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
            }
        }
        Class<?> objectClass = TypeUtils.getMapping((Type)objectType);
        String className = objectClass.getName();
        if (!fieldBased && className.equals("com.google.common.collect.ArrayListMultimap")) {
            objectReader = ObjectReaderImplMap.of(null, objectClass, 0L);
        }
        if (objectReader == null) {
            Annotation[] annotations;
            boolean jsonCompiled = false;
            for (Annotation annotation : annotations = objectClass.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                jsonCompiled = annotationType.getName().equals("com.alibaba.fastjson2.annotation.JSONCompiled");
            }
            if (jsonCompiled) {
                String codeGenClassName = objectClass.getName() + "_FASTJOSNReader";
                ClassLoader classLoader = objectClass.getClassLoader();
                if (classLoader == null) {
                    classLoader = Thread.currentThread().getContextClassLoader();
                }
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                try {
                    Class<?> loadedClass = classLoader.loadClass(codeGenClassName);
                    if (ObjectReader.class.isAssignableFrom(loadedClass)) {
                        objectReader = (ObjectReader)loadedClass.newInstance();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (objectReader == null) {
            ObjectReaderCreator creator = this.getCreator();
            objectReader = creator.createObjectReader(objectClass, (Type)objectType, fieldBased, this);
        }
        if ((previous = this.getPreviousObjectReader(fieldBased, (Type)objectType, objectReader)) != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    private ObjectReader getPreviousObjectReader(boolean fieldBased, Type objectType, ObjectReader boundObjectReader) {
        return fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, boundObjectReader) : this.cache.putIfAbsent(objectType, boundObjectReader);
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public Map<String, Date> getAutoTypeList() {
        return this.autoTypeList;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
        String findName;
        Field field;
        String methodName;
        for (ObjectReaderModule module : this.modules) {
            ObjectReaderAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getFieldInfo(fieldInfo, objectClass, method);
        }
        if (fieldInfo.fieldName == null && fieldInfo.alternateNames == null && (methodName = method.getName()).startsWith("set") && (field = BeanUtils.getDeclaredField(objectClass, findName = methodName.substring(3))) != null) {
            fieldInfo.alternateNames = new String[]{findName};
        }
    }

    public <T> Supplier<T> createObjectCreator(Class<T> objectClass, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return () -> objectReader.createInstance(0L);
        }
        Constructor constructor = BeanUtils.getDefaultConstructor(objectClass, false);
        if (constructor == null) {
            throw new JSONException("default constructor not found : " + objectClass.getName());
        }
        return LambdaMiscCodec.createSupplier(constructor);
    }

    public FieldReader createFieldReader(Class objectClass, String fieldName, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return objectReader.getFieldReader(fieldName);
        }
        AtomicReference fieldRef = new AtomicReference();
        long nameHashLCase = Fnv.hashCode64LCase(fieldName);
        BeanUtils.fields(objectClass, field -> {
            if (nameHashLCase == Fnv.hashCode64LCase(field.getName())) {
                fieldRef.set(field);
            }
        });
        Field field2 = (Field)fieldRef.get();
        if (field2 != null) {
            return this.creator.createFieldReader(fieldName, null, field2.getType(), field2);
        }
        AtomicReference methodRef = new AtomicReference();
        BeanUtils.setters(objectClass, method -> {
            String setterName = BeanUtils.setterName(method.getName(), PropertyNamingStrategy.CamelCase.name());
            if (nameHashLCase == Fnv.hashCode64LCase(setterName)) {
                methodRef.set(method);
            }
        });
        Method method2 = (Method)methodRef.get();
        if (method2 != null) {
            Class<?>[] params = method2.getParameterTypes();
            Class<?> fieldClass = params[0];
            return this.creator.createFieldReaderMethod(objectClass, fieldName, null, fieldClass, fieldClass, method2);
        }
        return null;
    }

    static {
        Class handlerClass;
        FASTJSON2_CLASS_LOADER = JSON.class.getClassLoader();
        String property = System.getProperty("fastjson2.parser.deny");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.parser.deny");
        }
        DENYS = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeAccept");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.autoTypeAccept");
        }
        AUTO_TYPE_ACCEPT_LIST = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeBeforeHandler");
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeBeforeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_BEFORE_HANDLER = (JSONReader.AutoTypeBeforeHandler)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson2.autoTypeHandler")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_HANDLER = (Consumer)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson.parser.safeMode")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = System.getProperty("fastjson2.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.parser.safeMode");
        }
        if (property != null) {
            property = property.trim();
        }
        SAFE_MODE = "true".equals(property);
    }

    static class LRUAutoTypeCache
    extends LinkedHashMap<String, Date> {
        private final int maxSize;

        public LRUAutoTypeCache(int maxSize) {
            super(16, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class ObjectReaderCachePair {
        final long hashCode;
        final ObjectReader reader;
        volatile int missCount;

        public ObjectReaderCachePair(long hashCode, ObjectReader reader) {
            this.hashCode = hashCode;
            this.reader = reader;
        }
    }
}

