/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public class ObjectReaderImplField
implements ObjectReader {
    static final long HASH_DECLARING_CLASS = Fnv.hashCode64("declaringClass");
    static final long HASH_NAME = Fnv.hashCode64("name");

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readObject(jsonReader, fieldType, fieldName, features);
    }

    public Object readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        int entryCount = jsonReader.startArray();
        if (entryCount != 2) {
            throw new JSONException("not support input " + jsonReader.info());
        }
        String declaringClassName = jsonReader.readString();
        String methodName = jsonReader.readString();
        return this.getField(jsonReader.getContext().getFeatures() | features, methodName, declaringClassName);
    }

    public Object readArrayMappingObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        boolean arrayStart = jsonReader.nextIfArrayStart();
        if (!arrayStart) {
            throw new JSONException("not support input " + jsonReader.info());
        }
        String declaringClassName = jsonReader.readString();
        String methodName = jsonReader.readString();
        boolean arrayEnd = jsonReader.nextIfArrayEnd();
        if (!arrayEnd) {
            throw new JSONException("not support input " + jsonReader.info());
        }
        jsonReader.nextIfComma();
        return this.getField(jsonReader.getContext().getFeatures() | features, methodName, declaringClassName);
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        boolean objectStart = jsonReader.nextIfObjectStart();
        if (!objectStart) {
            if (jsonReader.isSupportBeanArray(features)) {
                if (jsonReader.isJSONB()) {
                    return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
                }
                return this.readArrayMappingObject(jsonReader, fieldType, fieldName, features);
            }
            throw new JSONException("not support input " + jsonReader.info());
        }
        String methodName = null;
        String declaringClassName = null;
        while (!jsonReader.nextIfObjectEnd()) {
            long nameHashCode = jsonReader.readFieldNameHashCode();
            if (nameHashCode == HASH_DECLARING_CLASS) {
                declaringClassName = jsonReader.readString();
                continue;
            }
            if (nameHashCode == HASH_NAME) {
                methodName = jsonReader.readString();
                continue;
            }
            jsonReader.skipValue();
        }
        if (!jsonReader.isJSONB()) {
            jsonReader.nextIfComma();
        }
        return this.getField(jsonReader.getContext().getFeatures() | features, methodName, declaringClassName);
    }

    private Field getField(long features, String methodName, String declaringClassName) {
        boolean supportClassForName;
        boolean bl = supportClassForName = (features & JSONReader.Feature.SupportClassForName.mask) != 0L;
        if (!supportClassForName) {
            throw new JSONException("ClassForName not support");
        }
        Class declaringClass = TypeUtils.loadClass(declaringClassName);
        try {
            return declaringClass.getDeclaredField(methodName);
        }
        catch (NoSuchFieldException e) {
            throw new JSONException("method not found", e);
        }
    }
}

