/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.commands;

import de.saxsys.mvvmfx.utils.commands.Action;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateCommand
extends Service<Void>
implements Command {
    protected final Supplier<Action> actionSupplier;
    protected boolean inBackground = false;
    protected final ReadOnlyBooleanWrapper executable = new ReadOnlyBooleanWrapper(true);
    protected ReadOnlyBooleanWrapper notExecutable;
    protected ReadOnlyBooleanWrapper notRunning;
    private Property<Throwable> writableExceptionProperty;
    Logger LOG = LoggerFactory.getLogger(DelegateCommand.class);

    public DelegateCommand(Supplier<Action> actionSupplier) {
        this(actionSupplier, false);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, boolean inBackground) {
        this(actionSupplier, null, inBackground);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, ObservableValue<Boolean> executableObservable) {
        this(actionSupplier, executableObservable, false);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, ObservableValue<Boolean> executableObservable, boolean inBackground) {
        this.actionSupplier = actionSupplier;
        this.inBackground = inBackground;
        if (executableObservable != null) {
            this.executable.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                boolean isRunning = this.runningProperty().get();
                boolean isExecutable = (Boolean)executableObservable.getValue();
                return !isRunning && isExecutable;
            }, (Observable[])new Observable[]{this.runningProperty(), executableObservable}));
        }
    }

    @Override
    public void execute() {
        if (!this.isExecutable()) {
            throw new RuntimeException("The execute()-method of the command was called while it wasn't executable.");
        }
        if (this.inBackground) {
            super.restart();
        } else {
            this.callActionAndSynthesizeServiceRun();
        }
    }

    private ObjectProperty<Worker.State> getStateObjectPropertyReadable() {
        return (ObjectProperty)this.stateProperty();
    }

    private BooleanProperty getRunningPropertyReadable() {
        return (BooleanProperty)this.runningProperty();
    }

    protected void callActionAndSynthesizeServiceRun() {
        try {
            this.unbindServiceExceptionFromTaskException();
            this.getStateObjectPropertyReadable().setValue((Object)Worker.State.SCHEDULED);
            Action action = this.actionSupplier.get();
            this.setWritableExceptionProperty(action);
            this.bindServiceExceptionToTaskException();
            this.getRunningPropertyReadable().set(true);
            action.action();
            this.getRunningPropertyReadable().set(false);
            this.getStateObjectPropertyReadable().setValue((Object)Worker.State.SUCCEEDED);
        }
        catch (Exception e) {
            this.setException(e);
            this.LOG.error("Exception in Command Execution", (Throwable)this.writableExceptionProperty.getValue());
            this.getStateObjectPropertyReadable().setValue((Object)Worker.State.FAILED);
        }
    }

    protected Task<Void> createTask() {
        if (this.inBackground) {
            return this.actionSupplier.get();
        }
        return this.createSynthesizedTask();
    }

    @Override
    public ReadOnlyBooleanProperty executableProperty() {
        return this.executable.getReadOnlyProperty();
    }

    @Override
    public boolean isExecutable() {
        return this.executableProperty().get();
    }

    @Override
    public final ReadOnlyBooleanProperty notExecutableProperty() {
        if (this.notExecutable == null) {
            this.notExecutable = new ReadOnlyBooleanWrapper();
            this.notExecutable.bind((ObservableValue)this.executableProperty().not());
        }
        return this.notExecutable.getReadOnlyProperty();
    }

    @Override
    public final boolean isNotExecutable() {
        return this.notExecutableProperty().get();
    }

    @Override
    public final ReadOnlyBooleanProperty notRunningProperty() {
        if (this.notRunning == null) {
            this.notRunning = new ReadOnlyBooleanWrapper();
            this.notRunning.bind((ObservableValue)this.runningProperty().not());
        }
        return this.notRunning.getReadOnlyProperty();
    }

    @Override
    public final boolean isNotRunning() {
        return this.notRunningProperty().get();
    }

    private Task<Void> createSynthesizedTask() {
        return new Task<Void>(){

            protected Void call() throws Exception {
                return null;
            }
        };
    }

    private void bindServiceExceptionToTaskException() {
        DelegateCommand.checkExceptionProperty((ReadOnlyObjectProperty<Throwable>)super.exceptionProperty()).bind(this.writableExceptionProperty);
    }

    private void unbindServiceExceptionFromTaskException() {
        DelegateCommand.checkExceptionProperty((ReadOnlyObjectProperty<Throwable>)super.exceptionProperty()).unbind();
    }

    private void setWritableExceptionProperty(Action action) {
        this.writableExceptionProperty = DelegateCommand.checkExceptionProperty((ReadOnlyObjectProperty<Throwable>)action.exceptionProperty());
    }

    private void setException(Throwable throwable) {
        this.writableExceptionProperty.setValue((Object)throwable);
    }

    protected static Property<Throwable> checkExceptionProperty(ReadOnlyObjectProperty<Throwable> exceptionProperty) {
        if (exceptionProperty instanceof Property) {
            return (Property)exceptionProperty;
        }
        throw new RuntimeException("Cannot use DelegateCommand in asynchronous mode because of an incompatible JDK version. Please report this to the mvvmFX developers at https://github.com/sialcasa/mvvmFX.");
    }

    public Supplier<Action> getActionSupplier() {
        return this.actionSupplier;
    }
}

