/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(WindowsThemeDetector.class);
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";
    private final Set<Consumer<Boolean>> listeners = Collections.synchronizedSet(new HashSet());
    private DetectorThread detectorThread;

    WindowsThemeDetector() {
    }

    @Override
    public boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
    }

    @Override
    public synchronized void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener);
        boolean listenerAdded = this.listeners.add(darkThemeListener);
        boolean singleListener = listenerAdded && this.listeners.size() == 1;
        boolean bl = threadInterrupted = this.detectorThread != null && this.detectorThread.isInterrupted();
        if (singleListener || threadInterrupted) {
            this.detectorThread = new DetectorThread(this);
            this.detectorThread.start();
        }
    }

    @Override
    public synchronized void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        this.listeners.remove(darkThemeListener);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    private static final class DetectorThread
    extends Thread {
        private final WindowsThemeDetector themeDetector;
        private boolean lastValue;

        DetectorThread(WindowsThemeDetector themeDetector) {
            this.themeDetector = themeDetector;
            this.lastValue = themeDetector.isDark();
            this.setName("Windows 10 Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        @Override
        public void run() {
            WinReg.HKEYByReference hkey = new WinReg.HKEYByReference();
            int err = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, WindowsThemeDetector.REGISTRY_PATH, 0, 131097, hkey);
            if (err != 0) {
                throw new Win32Exception(err);
            }
            while (!this.isInterrupted()) {
                err = Advapi32.INSTANCE.RegNotifyChangeKeyValue(hkey.getValue(), false, 4, null, false);
                if (err != 0) {
                    throw new Win32Exception(err);
                }
                boolean currentDetection = this.themeDetector.isDark();
                if (currentDetection == this.lastValue) continue;
                this.lastValue = currentDetection;
                logger.debug("Theme change detected: dark: {}", (Object)currentDetection);
                for (Consumer<Boolean> listener : this.themeDetector.listeners) {
                    try {
                        listener.accept(currentDetection);
                    }
                    catch (RuntimeException e) {
                        logger.error("Caught exception during listener notifying ", (Throwable)e);
                    }
                }
            }
            Advapi32Util.registryCloseKey((WinReg.HKEY)hkey.getValue());
        }
    }
}

