/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.MacOSThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static OsThemeDetector osThemeDetector;

    OsThemeDetector() {
    }

    @NotNull
    public static synchronized OsThemeDetector getDetector() {
        if (osThemeDetector != null) {
            return osThemeDetector;
        }
        if (OsInfo.isWindows10OrLater()) {
            OsThemeDetector.logDetection("Windows 10", WindowsThemeDetector.class);
            osThemeDetector = new WindowsThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isGnome()) {
            OsThemeDetector.logDetection("Gnome", GnomeThemeDetector.class);
            osThemeDetector = new GnomeThemeDetector();
            return osThemeDetector;
        }
        if (OsInfo.isMacOsMojaveOrLater()) {
            OsThemeDetector.logDetection("MacOS", MacOSThemeDetector.class);
            osThemeDetector = new MacOSThemeDetector();
            return osThemeDetector;
        }
        logger.debug("Theme detection is not supported on the system: {} {}", (Object)OsInfo.getFamily(), (Object)OsInfo.getVersion());
        logger.debug("Creating empty detector...");
        osThemeDetector = new EmptyDetector();
        return osThemeDetector;
    }

    private static void logDetection(String desktop, Class<? extends OsThemeDetector> detectorClass) {
        logger.debug("Supported Desktop detected: {}", (Object)desktop);
        logger.debug("Creating {}...", (Object)detectorClass.getName());
    }

    public abstract boolean isDark();

    public abstract void registerListener(@NotNull Consumer<Boolean> var1);

    public abstract void removeListener(@Nullable Consumer<Boolean> var1);

    public static boolean isSupported() {
        return OsInfo.isWindows10OrLater() || OsInfo.isMacOsMojaveOrLater() || OsInfo.isGnome();
    }

    private static final class EmptyDetector
    extends OsThemeDetector {
        private EmptyDetector() {
        }

        @Override
        public boolean isDark() {
            return false;
        }

        @Override
        public void registerListener(@NotNull Consumer<Boolean> darkThemeListener) {
        }

        @Override
        public void removeListener(@Nullable Consumer<Boolean> darkThemeListener) {
        }
    }
}

