/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.common.utils.sm.cert;

import com.ruoyi.common.utils.sm.cert.CertSNAllocator;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;

public class FileSNAllocator
implements CertSNAllocator {
    private static final String SN_FILENAME = "sn.dat";
    private static String snFilePath;

    @Override
    public synchronized BigInteger nextSerialNumber() throws Exception {
        BigInteger sn = this.readSN();
        this.writeSN(sn.add(BigInteger.ONE));
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger readSN() throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(snFilePath, "r");
            byte[] data = new byte[(int)raf.length()];
            raf.read(data);
            String snStr = new String(data);
            BigInteger bigInteger = new BigInteger(snStr);
            return bigInteger;
        }
    }

    private void writeSN(BigInteger sn) throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(snFilePath, "rw");
            raf.writeBytes(sn.toString(10));
        }
    }

    static {
        ClassLoader loader = FileSNAllocator.class.getClassLoader();
        snFilePath = loader.getResource(SN_FILENAME).getPath();
    }
}

