/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.ssh;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.ftp.AbstractFtp;
import cn.hutool.extra.ftp.FtpConfig;
import cn.hutool.extra.ftp.FtpException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class SshjSftp
extends AbstractFtp {
    private SSHClient ssh;
    private SFTPClient sftp;

    public SshjSftp(String sshHost) {
        this(new FtpConfig(sshHost, 22, null, null, CharsetUtil.CHARSET_UTF_8));
    }

    public SshjSftp(String sshHost, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, 22, sshUser, sshPass, CharsetUtil.CHARSET_UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, CharsetUtil.CHARSET_UTF_8));
    }

    public SshjSftp(String sshHost, int sshPort, String sshUser, String sshPass, Charset charset) {
        this(new FtpConfig(sshHost, sshPort, sshUser, sshPass, charset));
    }

    protected SshjSftp(FtpConfig config) {
        super(config);
        this.init();
    }

    public void init() {
        this.ssh = new SSHClient();
        this.ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        try {
            this.ssh.connect(this.ftpConfig.getHost(), this.ftpConfig.getPort());
            this.ssh.authPassword(this.ftpConfig.getUser(), this.ftpConfig.getPassword());
            this.ssh.setRemoteCharset(this.ftpConfig.getCharset());
            this.sftp = this.ssh.newSFTPClient();
        }
        catch (IOException e) {
            throw new FtpException("sftp \u521d\u59cb\u5316\u5931\u8d25.", e);
        }
    }

    @Override
    public AbstractFtp reconnectIfTimeout() {
        if (StrUtil.isBlank(this.ftpConfig.getHost())) {
            throw new FtpException("Host is blank!");
        }
        try {
            this.cd("/");
        }
        catch (FtpException e) {
            this.close();
            this.init();
        }
        return this;
    }

    @Override
    public boolean cd(String directory) {
        String exec = String.format("cd %s", directory);
        this.command(exec);
        String pwd = this.pwd();
        return pwd.equals(directory);
    }

    @Override
    public String pwd() {
        return this.command("pwd");
    }

    @Override
    public boolean mkdir(String dir) {
        try {
            this.sftp.mkdir(dir);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        return this.containsFile(dir);
    }

    @Override
    public List<String> ls(String path) {
        List infoList;
        try {
            infoList = this.sftp.ls(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
        if (CollUtil.isNotEmpty(infoList)) {
            return CollUtil.map(infoList, RemoteResourceInfo::getName, true);
        }
        return null;
    }

    @Override
    public boolean delFile(String path) {
        try {
            this.sftp.rm(path);
            return !this.containsFile(path);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean delDir(String dirPath) {
        try {
            this.sftp.rmdir(dirPath);
            return !this.containsFile(dirPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public boolean upload(String destPath, File file) {
        try {
            this.sftp.put((LocalSourceFile)new FileSystemFile(file), destPath);
            return this.containsFile(destPath);
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void download(String path, File outFile) {
        try {
            this.sftp.get(path, (LocalDestFile)new FileSystemFile(outFile));
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    @Override
    public void recursiveDownloadFolder(String sourcePath, File destDir) {
        List<String> files = this.ls(sourcePath);
        if (files != null && !files.isEmpty()) {
            files.forEach(path -> this.download(sourcePath + "/" + path, destDir));
        }
    }

    @Override
    public void close() {
        try {
            this.sftp.close();
            this.ssh.disconnect();
        }
        catch (IOException e) {
            throw new FtpException(e);
        }
    }

    public boolean containsFile(String fileDir) {
        try {
            this.sftp.lstat(fileDir);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String command(String exec) {
        Session session = null;
        try {
            session = this.ssh.startSession();
            Session.Command command = session.exec(exec);
            InputStream inputStream = command.getInputStream();
            String string = IoUtil.read(inputStream, DEFAULT_CHARSET);
            return string;
        }
        catch (Exception e) {
            throw new FtpException(e);
        }
        finally {
            IoUtil.close((Closeable)session);
        }
    }
}

