/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.Severity;
import java.util.Objects;

public class ValidationMessage {
    private final String message;
    private final Severity severity;

    public ValidationMessage(Severity severity, String message) {
        this.severity = Objects.requireNonNull(severity);
        this.message = Objects.requireNonNull(message);
    }

    public static ValidationMessage warning(String message) {
        return new ValidationMessage(Severity.WARNING, message);
    }

    public static ValidationMessage error(String message) {
        return new ValidationMessage(Severity.ERROR, message);
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String toString() {
        return "ValidationMessage{message='" + this.message + '\'' + ", severity=" + (Object)((Object)this.severity) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ValidationMessage)) {
            return false;
        }
        ValidationMessage that = (ValidationMessage)o;
        return this.message.equals(that.message) && this.severity == that.severity;
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + this.severity.hashCode();
        return result;
    }
}

