/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.CompositeValidationStatus;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class CompositeValidator
implements Validator {
    private CompositeValidationStatus status = new CompositeValidationStatus();
    private ListProperty<Validator> validators = new SimpleListProperty(FXCollections.observableArrayList());
    private Map<Validator, ListChangeListener<ValidationMessage>> listenerMap = new HashMap<Validator, ListChangeListener<ValidationMessage>>();

    public CompositeValidator() {
        this.validators.addListener((ListChangeListener)new ListChangeListener<Validator>(){

            public void onChanged(ListChangeListener.Change<? extends Validator> c) {
                while (c.next()) {
                    c.getAddedSubList().forEach(validator -> {
                        ObservableList<ValidationMessage> messages = validator.getValidationStatus().getMessages();
                        CompositeValidator.this.status.addMessage((Validator)validator, (List<? extends ValidationMessage>)messages);
                        ListChangeListener changeListener = change -> {
                            while (change.next()) {
                                CompositeValidator.this.status.addMessage((Validator)validator, change.getAddedSubList());
                                CompositeValidator.this.status.removeMessage((Validator)validator, change.getRemoved());
                            }
                        };
                        validator.getValidationStatus().getMessages().addListener(changeListener);
                        CompositeValidator.this.listenerMap.put(validator, changeListener);
                    });
                    c.getRemoved().forEach(validator -> {
                        CompositeValidator.this.status.removeMessage((Validator)validator);
                        if (CompositeValidator.this.listenerMap.containsKey(validator)) {
                            ListChangeListener changeListener = (ListChangeListener)CompositeValidator.this.listenerMap.get(validator);
                            validator.getValidationStatus().getMessages().removeListener(changeListener);
                            CompositeValidator.this.listenerMap.remove(validator);
                        }
                    });
                }
            }
        });
    }

    public CompositeValidator(Validator ... validators) {
        this();
        this.addValidators(validators);
    }

    public ObservableList<Validator> getValidators() {
        return FXCollections.unmodifiableObservableList(this.validators);
    }

    public void addValidators(Validator ... validators) {
        this.validators.addAll((Object[])validators);
    }

    public void removeValidators(Validator ... validators) {
        this.validators.removeAll((Object[])validators);
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.status;
    }
}

