/*
 * Decompiled with CFR 0.152.
 */
package com.rexbas.bouncingballs.item;

import com.rexbas.bouncingballs.BouncingBalls;
import com.rexbas.bouncingballs.api.capability.BounceCapability;
import com.rexbas.bouncingballs.api.capability.IBounceCapability;
import com.rexbas.bouncingballs.api.item.BouncingBall;
import com.rexbas.bouncingballs.api.item.IBouncingBall;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class EnderBouncingBall
extends BouncingBall {
    public EnderBouncingBall() {
        super(new Item.Properties().m_41491_(BouncingBalls.TAB), new BouncingBall.Properties(600, Items.f_42545_, 0.5f, 0.65f, 10.0f, 0.5f).recipeItem(Items.f_42545_).addFluid(FluidTags.f_13131_));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() instanceof IBouncingBall) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (!player.f_19853_.m_5776_() && this.canBounce((LivingEntity)player)) {
            this.bounce((LivingEntity)player, 0.0f);
            this.damageBall((LivingEntity)player, stack);
            this.playBounceSound(level, (LivingEntity)player);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean canBounce(LivingEntity entity) {
        IBounceCapability cap = (IBounceCapability)entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).orElse(null);
        if (cap != null) {
            float yaw = entity.m_146908_();
            float pitch = entity.m_146909_();
            double deltaX = -Mth.m_14031_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI)) * 5.0f;
            double deltaZ = Mth.m_14089_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI)) * 5.0f;
            BlockPos newPos = entity.m_20183_().m_121955_(new Vec3i(deltaX, 8.0, deltaZ));
            return super.canBounce(entity) && entity.f_19853_.m_8055_(newPos).m_60795_() && entity.f_19853_.m_8055_(newPos.m_7494_()).m_60795_();
        }
        return false;
    }

    public void bounce(LivingEntity entity, float motionY) {
        if (motionY == 0.0f) {
            float yaw = entity.m_146908_();
            float pitch = entity.m_146909_();
            double forwardMotion = 10.0;
            double deltaX = (double)(-Mth.m_14031_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI))) * forwardMotion;
            double deltaZ = (double)(Mth.m_14089_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI))) * forwardMotion;
            BlockPos newPos = entity.m_20183_().m_121955_(new Vec3i(deltaX, 8.0, deltaZ));
            entity.m_6027_((double)newPos.m_123341_(), (double)newPos.m_123342_(), (double)newPos.m_123343_());
            entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> cap.addBounce());
        } else {
            super.bounce(entity, motionY);
        }
    }

    public void playBounceSound(Level level, LivingEntity entity) {
        level.m_6269_(null, (Entity)entity, SoundEvents.f_11857_, SoundSource.PLAYERS, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
    }
}

