/*
 * Decompiled with CFR 0.152.
 */
package com.rexbas.bouncingballs.api.item;

import com.rexbas.bouncingballs.api.BouncingBallsAPI;
import com.rexbas.bouncingballs.api.capability.BounceCapability;
import com.rexbas.bouncingballs.api.capability.IBounceCapability;
import com.rexbas.bouncingballs.api.item.IBouncingBall;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BouncingBall
extends Item
implements IBouncingBall {
    protected Properties properties;

    public BouncingBall(Item.Properties itemProperties, Properties ballProperties) {
        super(itemProperties.m_41487_(1).m_41499_(ballProperties.durability));
        this.properties = ballProperties;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && player.m_21206_().m_41720_() instanceof IBouncingBall) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (!player.f_19853_.m_5776_() && this.canBounce((LivingEntity)player)) {
            this.bounce((LivingEntity)player, this.properties.upwardMotion);
            this.damageBall((LivingEntity)player, stack);
            this.playBounceSound(level, (LivingEntity)player);
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.properties.repairItem != Items.f_41852_ && repair.m_41720_() == this.properties.repairItem;
    }

    @Override
    public boolean canBounce(LivingEntity entity) {
        IBounceCapability cap = (IBounceCapability)entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).orElse(null);
        if (cap != null) {
            if (this.properties.mustStartOnGroundOrFluid && cap.getConsecutiveBounces() == 0) {
                return cap.getConsecutiveBounces() < this.properties.maxConsecutiveBounces && (cap.getTicksOnGround() > 0 && !entity.f_19853_.m_46855_(entity.m_20191_()) || cap.getTicksInFluid() > 0 && cap.getLastFluid() != null && this.properties.fluidList.contains(cap.getLastFluid()) && !entity.m_204029_(cap.getLastFluid())) && this.hasConsumptionItem(entity);
            }
            return cap.getConsecutiveBounces() < this.properties.maxConsecutiveBounces && (!entity.f_19853_.m_46855_(entity.m_20191_()) || cap.getLastFluid() != null && this.properties.fluidList.contains(cap.getLastFluid()) && !entity.m_204029_(cap.getLastFluid())) && this.hasConsumptionItem(entity);
        }
        return false;
    }

    @Override
    public boolean shouldSitOnBall(LivingEntity entity) {
        IBounceCapability cap = (IBounceCapability)entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).orElse(null);
        if (cap != null) {
            return cap.getConsecutiveBounces() > 0 && !entity.m_20096_() || cap.getTicksSinceLastReset() < 7 || entity.f_19789_ > 3.0f || this.properties.fluidList.contains(cap.getLastFluid()) && !entity.m_6069_();
        }
        return false;
    }

    @Override
    public void bounce(LivingEntity entity, float motionY) {
        float yaw = entity.m_146908_();
        float pitch = entity.m_146909_();
        double motionX = -Mth.m_14031_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI)) * this.properties.forwardMotion;
        double motionZ = Mth.m_14089_((float)(yaw / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(pitch / 180.0f * (float)Math.PI)) * this.properties.forwardMotion;
        if (entity.f_19853_.m_46855_(entity.m_20191_())) {
            entity.m_20334_(entity.m_20184_().m_7096_(), 0.0, entity.m_20184_().m_7094_());
        }
        entity.m_5997_(motionX, (double)motionY, motionZ);
        entity.f_19864_ = true;
        entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> cap.addBounce());
        if (this.properties.consumptionItem.m_41720_() != Items.f_41852_) {
            entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                int slot = this.findConsumptionItemSlot((IItemHandler)itemHandler);
                if (slot != -1) {
                    itemHandler.extractItem(slot, 1, false);
                }
            });
        }
    }

    @Override
    public float onFall(LivingEntity entity, ItemStack stack, float fallDistance) {
        if (!entity.f_19853_.m_5776_() && fallDistance > this.properties.rebounceHeight) {
            float multiplier;
            if (this.hasConsumptionItem(entity)) {
                this.bounce(entity, this.properties.upwardMotion);
                multiplier = this.properties.damageMultiplier;
            } else {
                this.bounce(entity, this.properties.upwardMotion / 2.0f);
                multiplier = this.properties.damageMultiplier * 2.0f > 1.0f ? 1.0f : this.properties.damageMultiplier * 2.0f;
            }
            this.damageBall(entity, stack);
            this.playBounceSound(entity.f_19853_, entity);
            return multiplier;
        }
        return 0.0f;
    }

    @Override
    public boolean onDamage(LivingEntity entity, DamageSource damageSource, float amount) {
        return false;
    }

    @Override
    public void inFluid(LivingEntity entity, TagKey<Fluid> fluid) {
        if (this.properties.fluidList.contains(fluid)) {
            entity.getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> cap.setLastFluid(fluid));
            if (!entity.f_19853_.m_5776_()) {
                double d = 0.1 * entity.m_204036_(fluid) + 0.0175;
                if (entity.m_20184_().m_7098_() < 0.0 && entity.m_204036_(fluid) > 0.0) {
                    d += -0.98 * entity.m_20184_().m_7098_();
                }
                if (fluid == FluidTags.f_13132_) {
                    d *= 1.5;
                }
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_() * d, 0.0));
                entity.f_19864_ = true;
            }
        }
    }

    public void damageBall(LivingEntity entity, ItemStack stack) {
        stack.m_41622_(1, entity, p -> {});
    }

    public void playBounceSound(Level level, LivingEntity entity) {
        float pitch = level.f_46441_.m_188501_() * 0.20000005f + 0.9f;
        level.m_6269_(null, (Entity)entity, this.getBounceSound(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        for (TagKey<Fluid> fluid : this.properties.fluidList) {
            if (fluid == FluidTags.f_13131_) {
                list.add((Component)Component.m_237115_((String)"bouncingballs_api.hovertext.water_floating").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)39423))));
                continue;
            }
            if (fluid != FluidTags.f_13132_) continue;
            list.add((Component)Component.m_237115_((String)"bouncingballs_api.hovertext.lava_floating").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF9900))));
        }
        if (this.properties.consumptionItem.m_41720_() != Items.f_41852_) {
            list.add((Component)Component.m_237115_((String)"bouncingballs_api.hovertext.consumes").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAAAA))).m_130946_(" ").m_7220_(this.properties.consumptionItem.m_41786_()));
        }
    }

    public SoundEvent getBounceSound() {
        return (SoundEvent)BouncingBallsAPI.BouncingBallsSounds.BOUNCE.get();
    }

    public Item getRecipeItem() {
        return this.properties.recipeItem;
    }

    protected boolean hasConsumptionItem(LivingEntity entity) {
        if (this.properties.consumptionItem.m_41720_() == Items.f_41852_) {
            return true;
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (itemHandler != null) {
            return this.findConsumptionItemSlot(itemHandler) != -1;
        }
        return false;
    }

    protected int findConsumptionItemSlot(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != this.properties.consumptionItem.m_41720_() || !ItemStack.m_41658_((ItemStack)stack, (ItemStack)this.properties.consumptionItem)) continue;
            return i;
        }
        return -1;
    }

    public static class Properties {
        public int durability;
        public Item repairItem;
        public float forwardMotion;
        public float upwardMotion;
        public float rebounceHeight;
        public float damageMultiplier;
        public boolean mustStartOnGroundOrFluid;
        public int maxConsecutiveBounces;
        public ItemStack consumptionItem;
        public HashSet<TagKey<Fluid>> fluidList;
        public Item recipeItem;

        public Properties(int durability, Item repairItem, float forwardMotion, float upwardMotion, float rebounceHeight, float damageMultiplier, boolean mustStartOnGroundOrFluid, int maxConsecutiveBounces, Item consumptionItem) {
            this.durability = durability;
            this.repairItem = repairItem;
            this.forwardMotion = forwardMotion;
            this.upwardMotion = upwardMotion;
            this.rebounceHeight = rebounceHeight;
            this.damageMultiplier = damageMultiplier;
            this.mustStartOnGroundOrFluid = mustStartOnGroundOrFluid;
            this.maxConsecutiveBounces = maxConsecutiveBounces;
            this.consumptionItem = new ItemStack((ItemLike)consumptionItem);
            this.fluidList = new HashSet();
            this.recipeItem = Items.f_41852_;
        }

        public Properties(int durability, Item repairItem, float forwardMotion, float upwardMotion, float rebounceHeight, float damageMultiplier) {
            this(durability, repairItem, forwardMotion, upwardMotion, rebounceHeight, damageMultiplier, true, 1, Items.f_41852_);
        }

        public Properties(float forwardMotion, float upwardMotion, float rebounceHeight, float damageMultiplier) {
            this(0, Items.f_41852_, forwardMotion, upwardMotion, rebounceHeight, damageMultiplier, true, 1, Items.f_41852_);
        }

        public Properties(float forwardMotion, float upwardMotion, float rebounceHeight, float damageMultiplier, boolean mustStartOnGround, int maxConsecutiveBounces, Item consumptionItem) {
            this(0, Items.f_41852_, forwardMotion, upwardMotion, rebounceHeight, damageMultiplier, mustStartOnGround, maxConsecutiveBounces, consumptionItem);
        }

        public Properties() {
            this(100, Items.f_42518_, 0.5f, 0.65f, 10.0f, 0.5f, true, 1, Items.f_41852_);
        }

        public Properties addFluid(TagKey<Fluid> fluid) {
            this.fluidList.add(fluid);
            return this;
        }

        public Properties recipeItem(Item recipeItem) {
            this.recipeItem = recipeItem;
            return this;
        }
    }
}

