/*
 * Decompiled with CFR 0.152.
 */
package com.rexbas.bouncingballs.api.capability;

import com.rexbas.bouncingballs.api.capability.IBounceCapability;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class BounceCapability
implements ICapabilityProvider,
IBounceCapability {
    public static final Capability<IBounceCapability> BOUNCE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IBounceCapability>(){});
    private final LazyOptional<IBounceCapability> INSTANCE = LazyOptional.of(BounceCapability::new);
    private AtomicInteger consecutiveBounces = new AtomicInteger(0);
    private int ticksSinceLastReset = 1200;
    private int ticksOnGround = 0;
    private int ticksInFluid = 0;
    private TagKey<Fluid> lastFluid = null;
    private boolean markedForUpdate = true;

    @Override
    public void addBounce() {
        this.consecutiveBounces.incrementAndGet();
        this.ticksOnGround = 0;
        this.ticksInFluid = 0;
        this.markedForUpdate = true;
    }

    @Override
    public void resetConsecutiveBounces(float fallDistance) {
        if (this.consecutiveBounces.get() != 0) {
            this.consecutiveBounces.set(0);
            this.ticksSinceLastReset = 0;
        } else if (fallDistance > 3.0f) {
            this.ticksSinceLastReset = 0;
        }
        this.markedForUpdate = true;
    }

    @Override
    public int getConsecutiveBounces() {
        return this.consecutiveBounces.get();
    }

    @Override
    public void increaseTicksOnGround() {
        ++this.ticksOnGround;
        this.lastFluid = null;
    }

    @Override
    public void increaseTicksInFluid() {
        ++this.ticksInFluid;
    }

    @Override
    public void increaseTicksSinceLastReset() {
        ++this.ticksSinceLastReset;
    }

    @Override
    public void resetTicksOnGround() {
        this.ticksOnGround = 0;
        this.markedForUpdate = true;
    }

    @Override
    public void resetTicksInFluid() {
        this.ticksInFluid = 0;
        this.markedForUpdate = true;
    }

    @Override
    public int getTicksOnGround() {
        return this.ticksOnGround;
    }

    @Override
    public int getTicksInFluid() {
        return this.ticksInFluid;
    }

    @Override
    public int getTicksSinceLastReset() {
        return this.ticksSinceLastReset;
    }

    @Override
    public void setLastFluid(TagKey<Fluid> fluid) {
        this.lastFluid = fluid;
    }

    @Override
    @Nullable
    public TagKey<Fluid> getLastFluid() {
        return this.lastFluid;
    }

    @Override
    public void setMarkedForUpdate(boolean update) {
        this.markedForUpdate = update;
    }

    @Override
    public boolean getMarkedForUpdate() {
        return this.markedForUpdate;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("consecutiveBounces", this.consecutiveBounces.get());
        nbt.m_128405_("ticksSinceLastReset", this.ticksSinceLastReset);
        nbt.m_128405_("ticksOnGround", this.ticksOnGround);
        nbt.m_128405_("ticksInFluid", this.ticksInFluid);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.consecutiveBounces.set(nbt.m_128451_("consecutiveBounces"));
        this.ticksSinceLastReset = nbt.m_128451_("ticksSinceLastReset");
        this.ticksOnGround = nbt.m_128451_("ticksOnGround");
        this.ticksInFluid = nbt.m_128451_("ticksInFluid");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == BOUNCE_CAPABILITY ? this.INSTANCE.cast() : LazyOptional.empty();
    }
}

