/*
 * Decompiled with CFR 0.152.
 */
package com.rexbas.bouncingballs.api;

import com.rexbas.bouncingballs.api.capability.BounceCapability;
import com.rexbas.bouncingballs.api.capability.IBounceCapability;
import com.rexbas.bouncingballs.api.client.renderer.PlayerSitRenderer;
import com.rexbas.bouncingballs.api.item.IBouncingBall;
import com.rexbas.bouncingballs.api.network.BouncingBallsAPINetwork;
import com.rexbas.bouncingballs.api.network.packet.SUpdateBounceCapabilityPacket;
import java.lang.reflect.Method;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="bouncingballs_api")
public class BouncingBallsAPIEvents {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IBounceCapability.class);
    }

    @SubscribeEvent
    public static void attachtCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("bouncingballs_api", "capability.bounce"), (ICapabilityProvider)new BounceCapability());
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingTickEvent event) throws Throwable {
        Method m;
        boolean isAffectedByFluids;
        IBouncingBall ball = event.getEntity().m_21206_().m_41720_() instanceof IBouncingBall ? (IBouncingBall)event.getEntity().m_21206_().m_41720_() : (event.getEntity().m_21205_().m_41720_() instanceof IBouncingBall ? (IBouncingBall)event.getEntity().m_21205_().m_41720_() : null);
        event.getEntity().getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> {
            boolean inFluid = event.getEntity().f_19853_.m_46855_(event.getEntity().m_20191_());
            if (cap.getConsecutiveBounces() > 0 && (event.getEntity().f_19789_ == 0.0f && cap.getTicksOnGround() > 3 || cap.getTicksInFluid() > 3)) {
                cap.resetConsecutiveBounces(0.0f);
            }
            if (event.getEntity().m_20096_()) {
                cap.increaseTicksOnGround();
            } else {
                cap.resetTicksOnGround();
            }
            if (inFluid) {
                cap.increaseTicksInFluid();
            } else {
                cap.resetTicksInFluid();
            }
            if (cap.getLastFluid() != null && event.getEntity().m_20096_()) {
                cap.setLastFluid(null);
            }
            cap.increaseTicksSinceLastReset();
        });
        if (ball != null && (isAffectedByFluids = ((Boolean)(m = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6129_", (Class[])new Class[0])).invoke((Object)event.getEntity(), new Object[0])).booleanValue()) && !event.getEntity().m_6069_()) {
            FluidState fluidstate = event.getEntity().f_19853_.m_6425_(new BlockPos(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_()));
            fluidstate.m_205075_().forEach(fluid -> {
                if (event.getEntity().m_204036_(fluid) > 0.0) {
                    ball.inFluid(event.getEntity(), (TagKey<Fluid>)fluid);
                }
            });
        }
        event.getEntity().getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> {
            if (cap.getMarkedForUpdate()) {
                if (!event.getEntity().f_19853_.m_5776_()) {
                    BouncingBallsAPINetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> event.getEntity()), (Object)new SUpdateBounceCapabilityPacket(event.getEntity().m_19879_(), (CompoundTag)cap.serializeNBT()));
                }
                cap.setMarkedForUpdate(false);
            }
        });
    }

    @SubscribeEvent
    public static void onCreativePlayerFall(PlayerFlyableFallEvent event) {
        event.getEntity().getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> cap.resetConsecutiveBounces(event.getDistance()));
        if (event.getEntity().m_21206_().m_41720_() instanceof IBouncingBall) {
            ((IBouncingBall)event.getEntity().m_21206_().m_41720_()).onFall((LivingEntity)event.getEntity(), event.getEntity().m_21206_(), event.getDistance());
        } else if (event.getEntity().m_21205_().m_41720_() instanceof IBouncingBall) {
            ((IBouncingBall)event.getEntity().m_21205_().m_41720_()).onFall((LivingEntity)event.getEntity(), event.getEntity().m_21205_(), event.getDistance());
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        event.getEntity().getCapability(BounceCapability.BOUNCE_CAPABILITY).ifPresent(cap -> cap.resetConsecutiveBounces(event.getDistance()));
        float multiplier = 1.0f;
        if (event.getEntity().m_21206_().m_41720_() instanceof IBouncingBall) {
            multiplier = ((IBouncingBall)event.getEntity().m_21206_().m_41720_()).onFall(event.getEntity(), event.getEntity().m_21206_(), event.getDistance());
        } else if (event.getEntity().m_21205_().m_41720_() instanceof IBouncingBall) {
            multiplier = ((IBouncingBall)event.getEntity().m_21205_().m_41720_()).onFall(event.getEntity(), event.getEntity().m_21205_(), event.getDistance());
        }
        event.setDamageMultiplier(multiplier);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity().m_21206_().m_41720_() instanceof IBouncingBall) {
            event.setCanceled(((IBouncingBall)event.getEntity().m_21206_().m_41720_()).onDamage(event.getEntity(), event.getSource(), event.getAmount()));
        } else if (event.getEntity().m_21205_().m_41720_() instanceof IBouncingBall) {
            event.setCanceled(((IBouncingBall)event.getEntity().m_21205_().m_41720_()).onDamage(event.getEntity(), event.getSource(), event.getAmount()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        IBouncingBall ball = null;
        if (event.getEntity().m_21206_().m_41720_() instanceof IBouncingBall) {
            ball = (IBouncingBall)event.getEntity().m_21206_().m_41720_();
        } else if (event.getEntity().m_21205_().m_41720_() instanceof IBouncingBall) {
            ball = (IBouncingBall)event.getEntity().m_21205_().m_41720_();
        }
        if (ball != null && ball.shouldSitOnBall((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
            PlayerSitRenderer sitRenderer = new PlayerSitRenderer((LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)event.getRenderer(), (AbstractClientPlayer)event.getEntity());
            sitRenderer.render((AbstractClientPlayer)event.getEntity(), 0.0f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
        }
    }
}

