/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.realisticbees.events;

import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.SpawnEntityFunctions;
import com.natamus.collective.functions.StringFunctions;
import com.natamus.collective.functions.TaskFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.realisticbees.config.ConfigHandler;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BeeEvent {
    private static HashMap<PlayerEntity, Integer> stung_players = new HashMap();
    private static HashMap<PlayerEntity, Date> last_sting_player = new HashMap();
    private static HashMap<LivingEntity, Vector3d> stingerless_bees = new HashMap();

    @SubscribeEvent
    public static void onBeeCheckSpawn(LivingSpawnEvent.SpecialSpawn e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof BeeEntity)) {
            return;
        }
        entity.func_184211_a("SpawnReason." + e.getSpawnReason().name());
    }

    @SubscribeEvent
    public static void onBeeSpawn(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof BeeEntity)) {
            return;
        }
        Set tags = entity.func_184216_O();
        if (tags.contains("realisticbees.ignorebee")) {
            return;
        }
        entity.func_184211_a("realisticbees.ignorebee");
        if (tags.contains("SpawnReason.BUCKET") || tags.contains("SpawnReason.SPAWN_EGG")) {
            return;
        }
        BlockPos epos = entity.func_233580_cy_();
        if (!world.func_217354_b(MathHelper.func_76141_d((float)epos.func_177958_n()) >> 4, MathHelper.func_76141_d((float)epos.func_177952_p()) >> 4)) {
            return;
        }
        int extrabees = (Integer)ConfigHandler.GENERAL.extraBeeSpawnsPerBee.get();
        if (extrabees == 0) {
            return;
        }
        BeeEntity bee = (BeeEntity)entity;
        if (bee.func_70631_g_()) {
            return;
        }
        TaskFunctions.enqueueImmediateTask((World)world, () -> {
            Vector3d beevec = entity.func_213303_ch();
            ServerWorld serverworld = (ServerWorld)world;
            for (int i = 0; i < extrabees; ++i) {
                BeeEntity newbee = (BeeEntity)EntityType.field_226289_e_.func_200721_a(world);
                newbee.func_70029_a(world);
                newbee.func_70107_b(beevec.field_72450_a, beevec.field_72448_b, beevec.field_72449_c);
                newbee.func_184211_a("realisticbees.ignorebee");
                SpawnEntityFunctions.spawnEntityOnNextTick((ServerWorld)serverworld, (Entity)newbee);
            }
        }, (boolean)false);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent e) {
        Entity entity = e.getEntity();
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        stung_players.remove(player);
    }

    @SubscribeEvent
    public static void onEntityDamageTaken(LivingHurtEvent e) {
        Entity target = e.getEntity();
        World world = target.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        Entity truesource = e.getSource().func_76346_g();
        if (!(truesource instanceof BeeEntity)) {
            return;
        }
        boolean targetisplayer = target instanceof PlayerEntity;
        if (!((Boolean)ConfigHandler.GENERAL.beesDieFromStingingPlayer.get()).booleanValue() && targetisplayer) {
            return;
        }
        if (!((Boolean)ConfigHandler.GENERAL.beesDieFromStingingMob.get()).booleanValue() && !targetisplayer) {
            return;
        }
        double chance = GlobalVariables.random.nextDouble();
        if (chance > (Double)ConfigHandler.GENERAL.chanceBeeLeavesItsStinger.get()) {
            return;
        }
        EntityFunctions.addPotionEffect((Entity)truesource, (Effect)Effects.field_189112_A, (Integer)((Integer)ConfigHandler.GENERAL.timeInSecondsBeeWithoutStingerDies.get() * 1000));
        if (targetisplayer) {
            PlayerEntity player = (PlayerEntity)target;
            int timesstung = 1;
            if (stung_players.containsKey(player)) {
                timesstung = stung_players.get(player) + 1;
            }
            String times = "";
            if (timesstung > 1) {
                times = " " + timesstung + " times";
            }
            Date now = new Date();
            last_sting_player.put(player, now);
            stung_players.put(player, timesstung);
            if (((Boolean)ConfigHandler.GENERAL.sendStungPlayerWithStingerAMessage.get()).booleanValue()) {
                StringFunctions.sendMessage((PlayerEntity)player, (String)("You have been stung" + times + " with the stinger left behind! You can try and get it out by using some shears as pliers."), (TextFormatting)TextFormatting.YELLOW);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        Entity entity = e.getEntity();
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof BeeEntity) {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity le = (LivingEntity)entity;
            EffectInstance badluck = le.func_70660_b(Effects.field_189112_A);
            if (badluck == null) {
                return;
            }
            int ticksleft = badluck.func_76459_b();
            if (ticksleft < 5) {
                stingerless_bees.remove(le);
                le.func_70097_a(DamageSource.field_76366_f, Float.MAX_VALUE);
                return;
            }
            Vector3d beevec = le.func_213303_ch();
            if (!stingerless_bees.containsKey(le)) {
                stingerless_bees.put(le, beevec);
                return;
            }
            Vector3d lastvec = stingerless_bees.get(le);
            le.func_70634_a(lastvec.field_72450_a, beevec.field_72448_b, lastvec.field_72449_c);
        } else if (entity instanceof PlayerEntity) {
            LivingEntity le;
            EffectInstance poison;
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (stung_players.containsKey(player) && (poison = (le = (LivingEntity)entity).func_70660_b(Effects.field_76436_u)) == null) {
                Date now = new Date();
                Date last_sting = last_sting_player.get(player);
                long ms = now.getTime() - last_sting.getTime();
                if (ms >= (long)((Integer)ConfigHandler.GENERAL.timeInSecondsStingerPumpsPoison.get() * 1000)) {
                    StringFunctions.sendMessage((PlayerEntity)player, (String)"All stingers have stopped pumping poison.", (TextFormatting)TextFormatting.DARK_GREEN);
                    stung_players.remove(player);
                    return;
                }
                EntityFunctions.addPotionEffect((Entity)le, (Effect)Effects.field_76436_u, (Integer)5000);
            }
        }
    }

    @SubscribeEvent
    public static void onStingerPull(PlayerInteractEvent.RightClickItem e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = e.getPlayer();
        if (stung_players.containsKey(player)) {
            ItemStack hand = e.getItemStack();
            if (!(hand.func_77973_b() instanceof ShearsItem)) {
                return;
            }
            double chance = GlobalVariables.random.nextDouble();
            if (chance > (Double)ConfigHandler.GENERAL.chanceBeeStingerIsPulledOut.get()) {
                StringFunctions.sendMessage((PlayerEntity)player, (String)"You failed to get the stinger out!", (TextFormatting)TextFormatting.YELLOW);
                return;
            }
            int timesstung = stung_players.get(player);
            int newamount = timesstung - 1;
            if (newamount == 0) {
                StringFunctions.sendMessage((PlayerEntity)player, (String)"You successfully took all the stingers out.", (TextFormatting)TextFormatting.DARK_GREEN);
                stung_players.remove(player);
                return;
            }
            String are = "is 1";
            if (newamount > 1) {
                are = "are " + newamount;
            }
            StringFunctions.sendMessage((PlayerEntity)player, (String)("You took out a stinger! There " + are + " left."), (TextFormatting)TextFormatting.YELLOW);
            stung_players.put(player, newamount);
        }
    }
}

