luascript = {}

function luascript.get_keywords()
  local keywords0_set = "and break do else elseif end false for function if in local nil not or repeat return then true until while"
  local keywords1_set = "assert collectgarbage date error gcinfo getfenv getmetatable loadstring next pcall select setfenv setmetatable time type unpack xpcall abs acos asin atan atan2 ceil cos deg exp floor frexp ldexp log log10 max min mod rad random randomseed sin sqrt tan format gsub strbyte strchar strfind strlen strlower strmatch strrep strsub strupper tonumber tostring strtrim strsplit strjoin foreach foreachi getn ipairs pairs sort tinsert tremove"
  return keywords0_set,keywords1_set
end

 function luascript.get_autocomplete()
  local autocomplete_set = "assert collectgarbage date error gcinfo getfenv getmetatable loadstring next pcall select setfenv setmetatable time type unpack xpcall abs acos asin atan atan2 ceil cos deg exp floor frexp ldexp log log10 max min mod rad random randomseed sin sqrt tan format gsub strbyte strchar strfind strlen strlower strmatch strrep strsub strupper tonumber tostring strtrim strsplit strjoin foreach foreachi getn ipairs pairs sort tinsert tremove"
  return autocomplete_set
end

function luascript.get_calltip()
  local calltip_add =
  {
    "assert|assert(value)",
    "collectgarbage|collectgarbage()",
    "date|date(format, time)",
    "error|error(\"error message\",level)",
    "gcinfo|gcinfo()",
    "getfenv|getfenv(function or integer)",
    "getmetatable|getmetatable(obj, mtable)",
    "loadstring|loadstring(\"Lua code\")",
    "next|next(table, index)",
    "pcall|pcall(func, arg1, arg2, ...)",
    "select|select(index, list)",
    "setfenv|setfenv(function or integer, table)",
    "setmetatable|setmetatable(obj, mtable)",
    "time|time(table)",
    "type|type(var)",
    "unpack|unpack(table)",
    "xpcall|xpcall(func, err)",
    "abs|abs(value)",
    "acos|acos(value)",
    "asin|asin(value)",
    "atan|atan(value)",
    "atan2|atan2(y, x)",
    "ceil|ceil(value)",
    "cos|cos(degrees)",
    "deg|deg(radians)",
    "exp|exp(value)",
    "floor|floor(value)",
    "frexp|frexp(num)",
    "ldexp|ldexp(value, multiple)",
    "log|log(value)",
    "log10|log10(value)",
    "max|max(value[, values...])",
    "min|min(value[,values...])",
    "mod|mod(value,modulus)",
    "rad|rad(degrees)",
    "random|random([ [lower,] upper])",
    "randomseed|randomseed(seed)",
    "sin|sin(degrees)",
    "sqrt|sqrt(value)",
    "tan|tan(degrees)",
    "format|format(formatstring[, value[, ...]])",
    "gsub|gsub(string,pattern,replacement[, limitCount])",
    "strbyte|strbyte(string[, index])",
    "strchar|strchar(asciiCode[, ...])",
    "strfind|strfind(string, pattern[, initpos[, plain]])",
    "strlen|strlen(string)",
    "strlower|strlower(string)",
    "strmatch|strmatch(string, pattern[, initpos])",
    "strrep|strrep(seed,count)",
    "strsub|strsub(string, index[, endIndex])",
    "strupper|strupper(string)",
    "tonumber|tonumber(arg[, base])",
    "tostring|tostring(arg)",
    "strtrim|strtrim(string)",
    "strsplit|strsplit(delimiter, string)",
    "strjoin|strjoin(delimiter, string, string[, ...])",
    "foreach|foreach(table,function)",
    "foreachi|foreachi(table,function)",
    "getn|getn(table)",
    "ipairs|ipairs(table)",
    "pairs|pairs(table)",
    "sort|sort(table[, comp])",
    "tinsert|tinsert(table[, pos], value)",
    "tremove|tremove(table[, pos])"
  }
  return calltip_add
end

function luascript.get_reqular()
  local symbol_reqular_exp = "\\s*|^function\\s+([_a-zA-Z]+[\\.:_a-zA-Z0-9]*)\\s*\\("
  return symbol_reqular_exp
end

function luascript.create_bakup(path)
  local luascript_code = {
    "user_luascript = {}\n",
    "function user_luascript.get_keywords()\n",
    "  local keywords0_set = \"and break do else elseif end false for function if in local nil not or repeat return then true until while\"\n",
    "  local keywords1_set = \"assert collectgarbage date error gcinfo getfenv getmetatable loadstring next pcall select setfenv setmetatable time type unpack xpcall abs acos asin atan atan2 ceil cos deg exp floor frexp ldexp log log10 max min mod rad random randomseed sin sqrt tan format gsub strbyte strchar strfind strlen strlower strmatch strrep strsub strupper tonumber tostring strtrim strsplit strjoin foreach foreachi getn ipairs pairs sort tinsert tremove\"\n",
    "  return keywords0_set,keywords1_set\n",
    "end\n",
    "\n",
    "function user_luascript.get_autocomplete()\n",
    "  local autocomplete_set = \"assert collectgarbage date error gcinfo getfenv getmetatable loadstring next pcall select setfenv setmetatable time type unpack xpcall abs acos asin atan atan2 ceil cos deg exp floor frexp ldexp log log10 max min mod rad random randomseed sin sqrt tan format gsub strbyte strchar strfind strlen strlower strmatch strrep strsub strupper tonumber tostring strtrim strsplit strjoin foreach foreachi getn ipairs pairs sort tinsert tremove\"\n",
    "  return autocomplete_set\n",
    "end\n",
    "\n",
    "function user_luascript.get_calltip()\n",
    "  local calltip_add =\n",
    "  {\n",
    "    \"assert|assert(value)\",\n",
    "    \"collectgarbage|collectgarbage()\",\n",
    "    \"date|date(format, time)\",\n",
    "    \"error|error(\\\"error message\\\",level)\",\n",
    "    \"gcinfo|gcinfo()\",\n",
    "    \"getfenv|getfenv(function or integer)\",\n",
    "    \"getmetatable|getmetatable(obj, mtable)\",\n",
    "    \"loadstring|loadstring(\\\"Lua code\\\")\",\n",
    "    \"next|next(table, index)\",\n",
    "    \"pcall|pcall(func, arg1, arg2, ...)\",\n",
    "    \"select|select(index, list)\",\n",
    "    \"setfenv|setfenv(function or integer, table)\",\n",
    "    \"setmetatable|setmetatable(obj, mtable)\",\n",
    "    \"time|time(table)\",\n",
    "    \"type|type(var)\",\n",
    "    \"unpack|unpack(table)\",\n",
    "    \"xpcall|xpcall(func, err)\",\n",
    "    \"abs|abs(value)\",\n",
    "    \"acos|acos(value)\",\n",
    "    \"asin|asin(value)\",\n",
    "    \"atan|atan(value)\",\n",
    "    \"atan2|atan2(y, x)\",\n",
    "    \"ceil|ceil(value)\",\n",
    "    \"cos|cos(degrees)\",\n",
    "    \"deg|deg(radians)\",\n",
    "    \"exp|exp(value)\",\n",
    "    \"floor|floor(value)\",\n",
    "    \"frexp|frexp(num)\",\n",
    "    \"ldexp|ldexp(value, multiple)\",\n",
    "    \"log|log(value)\",\n",
    "    \"log10|log10(value)\",\n",
    "    \"max|max(value[, values...])\",\n",
    "    \"min|min(value[,values...])\",\n",
    "    \"mod|mod(value,modulus)\",\n",
    "    \"rad|rad(degrees)\",\n",
    "    \"random|random([ [lower,] upper])\",\n",
    "    \"randomseed|randomseed(seed)\",\n",
    "    \"sin|sin(degrees)\",\n",
    "    \"sqrt|sqrt(value)\",\n",
    "    \"tan|tan(degrees)\",\n",
    "    \"format|format(formatstring[, value[, ...]])\",\n",
    "    \"gsub|gsub(string,pattern,replacement[, limitCount])\",\n",
    "    \"strbyte|strbyte(string[, index])\",\n",
    "    \"strchar|strchar(asciiCode[, ...])\",\n",
    "    \"strfind|strfind(string, pattern[, initpos[, plain]])\",\n",
    "    \"strlen|strlen(string)\",\n",
    "    \"strlower|strlower(string)\",\n",
    "    \"strmatch|strmatch(string, pattern[, initpos])\",\n",
    "    \"strrep|strrep(seed,count)\",\n",
    "    \"strsub|strsub(string, index[, endIndex])\",\n",
    "    \"strupper|strupper(string)\",\n",
    "    \"tonumber|tonumber(arg[, base])\",\n",
    "    \"tostring|tostring(arg)\",\n",
    "    \"strtrim|strtrim(string)\",\n",
    "    \"strsplit|strsplit(delimiter, string)\",\n",
    "    \"strjoin|strjoin(delimiter, string, string[, ...])\",\n",
    "    \"foreach|foreach(table,function)\",\n",
    "    \"foreachi|foreachi(table,function)\",\n",
    "    \"getn|getn(table)\",\n",
    "    \"ipairs|ipairs(table)\",\n",
    "    \"pairs|pairs(table)\",\n",
    "    \"sort|sort(table[, comp])\",\n",
    "    \"tinsert|tinsert(table[, pos], value)\",\n",
    "    \"tremove|tremove(table[, pos])\"\n",
    "  }\n",
    "  return calltip_add\n",
    "end\n",
    "\n",
    "function user_luascript.get_reqular()\n",
    "  local symbol_reqular_exp = \"\\\\s*|^function\\\\s+([_a-zA-Z]+[\\\\.:_a-zA-Z0-9]*)\\\\s*\\\\(\"\n",
    "  return symbol_reqular_exp\n",
    "end\n",
    "return user_luascript",
  }
  local shell_code = table.concat(luascript_code)
  eu_core.save_file(path, shell_code)
  shell_code = nil
  luascript_code = nil
end

return luascript