/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.measurement.zzh;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzbo;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzq;

public final class zzfp
extends zzfs {
    private final AlarmManager zzrp = (AlarmManager)this.getContext().getSystemService("alarm");
    private final zzab zzrq;
    private Integer zzrr;

    protected zzfp(zzft zzft2) {
        super(zzft2);
        this.zzrq = new zzfq(this, (zzcv)zzft2.zzgi(), zzft2);
    }

    @Override
    protected final boolean zzak() {
        this.zzrp.cancel(this.zzft());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzfs();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzfs() {
        JobScheduler jobScheduler = (JobScheduler)this.getContext().getSystemService("jobscheduler");
        int n = this.getJobId();
        this.zzad().zzdi().zza("Cancelling job. JobID", (Object)n);
        jobScheduler.cancel(n);
    }

    public final void zzv(long l) {
        this.zzah();
        zzq zzq2 = this.zzag();
        Context context = this.getContext();
        if (!zzbo.zzl((Context)context)) {
            this.zzad().zzdh().zzaq("Receiver not registered/enabled");
        }
        if (!zzgd.zzb((Context)context, (boolean)false)) {
            this.zzad().zzdh().zzaq("Service not registered/enabled");
        }
        this.cancel();
        long l2 = this.zzz().elapsedRealtime() + l;
        if (l < Math.max(0L, (Long)zzal.zzha.get(null)) && !this.zzrq.zzcn()) {
            this.zzad().zzdi().zzaq("Scheduling upload with DelayedRunnable");
            this.zzrq.zzv(l);
        }
        zzq2 = this.zzag();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzad().zzdi().zzaq("Scheduling upload with JobScheduler");
            long l3 = l;
            zzfp zzfp2 = this;
            Context context2 = zzfp2.getContext();
            ComponentName componentName = new ComponentName(context2, "com.google.android.gms.measurement.AppMeasurementJobService");
            int n = zzfp2.getJobId();
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            JobInfo jobInfo = new JobInfo.Builder(n, componentName).setMinimumLatency(l3).setOverrideDeadline(l3 << 1).setExtras(persistableBundle).build();
            zzfp2.zzad().zzdi().zza("Scheduling job. JobID", (Object)n);
            zzh.zza(context2, jobInfo, "com.google.android.gms", "UploadAlarm");
            return;
        }
        this.zzad().zzdi().zzaq("Scheduling upload with AlarmManager");
        this.zzrp.setInexactRepeating(2, l2, Math.max((Long)zzal.zzgv.get(null), l), this.zzft());
    }

    private final int getJobId() {
        if (this.zzrr == null) {
            String string = String.valueOf(this.getContext().getPackageName());
            this.zzrr = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzrr;
    }

    public final void cancel() {
        this.zzah();
        this.zzrp.cancel(this.zzft());
        this.zzrq.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzfs();
        }
    }

    private final PendingIntent zzft() {
        Context context = this.getContext();
        Intent intent = new Intent().setClassName(context, "com.google.android.gms.measurement.AppMeasurementReceiver").setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
    }
}

