/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzab;
import com.google.android.gms.internal.measurement.zzac;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzae;
import com.google.android.gms.internal.measurement.zzaf;
import com.google.android.gms.internal.measurement.zzag;
import com.google.android.gms.internal.measurement.zzah;
import com.google.android.gms.internal.measurement.zzai;
import com.google.android.gms.internal.measurement.zzaj;
import com.google.android.gms.internal.measurement.zzak;
import com.google.android.gms.internal.measurement.zzal;
import com.google.android.gms.internal.measurement.zzam;
import com.google.android.gms.internal.measurement.zzan;
import com.google.android.gms.internal.measurement.zzao;
import com.google.android.gms.internal.measurement.zzap;
import com.google.android.gms.internal.measurement.zzaq;
import com.google.android.gms.internal.measurement.zzar;
import com.google.android.gms.internal.measurement.zzas;
import com.google.android.gms.internal.measurement.zzat;
import com.google.android.gms.internal.measurement.zzau;
import com.google.android.gms.internal.measurement.zzav;
import com.google.android.gms.internal.measurement.zzaw;
import com.google.android.gms.internal.measurement.zzax;
import com.google.android.gms.internal.measurement.zzay;
import com.google.android.gms.internal.measurement.zzaz;
import com.google.android.gms.internal.measurement.zzba;
import com.google.android.gms.internal.measurement.zzbb;
import com.google.android.gms.internal.measurement.zzbc;
import com.google.android.gms.internal.measurement.zzbd;
import com.google.android.gms.internal.measurement.zzbe;
import com.google.android.gms.internal.measurement.zzbf;
import com.google.android.gms.internal.measurement.zzbg;
import com.google.android.gms.internal.measurement.zzbh;
import com.google.android.gms.internal.measurement.zzbi;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbk;
import com.google.android.gms.internal.measurement.zzm;
import com.google.android.gms.internal.measurement.zzn;
import com.google.android.gms.internal.measurement.zzo;
import com.google.android.gms.internal.measurement.zzu;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdb;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class zzaa {
    private static volatile zzaa zzz;
    private final String zzw;
    protected final Clock zzaa;
    private final ExecutorService zzab;
    private final AppMeasurementSdk zzac;
    private Map<zzdb, zzc> zzad;
    private int zzae;
    private static Boolean zzaf;
    private static Boolean zzag;
    @VisibleForTesting
    private static String zzah;
    @VisibleForTesting
    private static String zzai;
    private static boolean zzaj;
    private static boolean zzak;
    private boolean zzal;
    private String zzam;
    private zzn zzan;

    public static zzaa zza(@Nonnull Context context) {
        return com.google.android.gms.internal.measurement.zzaa.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzaa zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzz != null) return zzz;
        Class<zzaa> clazz = zzaa.class;
        synchronized (zzaa.class) {
            if (zzz != null) return zzz;
            zzz = new zzaa(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzz;
        }
    }

    public final AppMeasurementSdk zzh() {
        return this.zzac;
    }

    private zzaa(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzw = string == null || !com.google.android.gms.internal.measurement.zzaa.zza(string2, string3) ? "FA" : string;
        this.zzaa = DefaultClock.getInstance();
        this.zzab = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.zzac = new AppMeasurementSdk(this);
        Context context2 = context;
        if (!(!com.google.android.gms.internal.measurement.zzaa.zzb(context2) || com.google.android.gms.internal.measurement.zzaa.zzi())) {
            this.zzam = null;
            this.zzal = true;
            Log.w((String)this.zzw, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!com.google.android.gms.internal.measurement.zzaa.zza(string2, string3)) {
            this.zzam = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzw, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                this.zzal = true;
                return;
            }
            if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzw, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzam = string2;
        }
        this.zza(new zzab(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzaa zzaa2 = this;
        if (context2 == null) {
            Log.w((String)zzaa2.zzw, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzaa2.new zzd());
    }

    private static boolean zzb(Context context) {
        try {
            GoogleServices.initialize((Context)context);
            return GoogleServices.getGoogleAppId() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zza(String string, String string2) {
        return string2 != null && string != null && !com.google.android.gms.internal.measurement.zzaa.zzi();
    }

    private final void zza(zza zza2) {
        this.zzab.execute(zza2);
    }

    protected final zzn zza(Context context, boolean bl) {
        try {
            return zzo.asInterface(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)(bl ? DynamiteModule.PREFER_HIGHEST_OR_REMOTE_VERSION : DynamiteModule.PREFER_LOCAL), (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzc(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzd(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzal |= bl;
        if (bl) {
            Log.w((String)this.zzw, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzw, (String)string, (Throwable)exception);
    }

    private static boolean zzi() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void zza(zzda zzda2) {
        this.zza(new zzam(this, zzda2));
    }

    public final void zza(zzdb zzdb2) {
        this.zza(new zzax(this, zzdb2));
    }

    public final void zzb(zzdb zzdb2) {
        this.zza(new zzba(this, zzdb2));
    }

    public final void logEvent(@Nonnull String string, Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void logEventInternal(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzbb(this, l, string, string2, bundle, bl, bl2));
    }

    public final void setUserProperty(String string, String string2) {
        this.zza(null, string, string2, false);
    }

    public final void setUserPropertyInternal(String string, String string2, Object object) {
        this.zza(string, string2, object, true);
    }

    private final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzbc(this, string, string2, object, bl));
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.zza(new zzbd(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(new zzac(this, string, string2, bundle));
    }

    public final List<Bundle> getConditionalUserProperties(String string, String string2) {
        zzm zzm2 = new zzm();
        this.zza(new zzad(this, string, string2, zzm2));
        List list = (List)zzm.zza((Bundle)zzm2.zzb(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void setUserId(String string) {
        this.zza(new zzae(this, string));
    }

    public final void setCurrentScreen(Activity activity, String string, String string2) {
        this.zza(new zzaf(this, activity, string, string2));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zza(new zzag(this, bl));
    }

    public final void resetAnalyticsData() {
        this.zza(new zzah(this));
    }

    public final void setMinimumSessionDuration(long l) {
        this.zza(new zzai(this, l));
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zza(new zzaj(this, l));
    }

    public final void beginAdUnitExposure(String string) {
        this.zza(new zzak(this, string));
    }

    public final void endAdUnitExposure(String string) {
        this.zza(new zzal(this, string));
    }

    public final String getGmpAppId() {
        zzm zzm2 = new zzm();
        this.zza(new zzan(this, zzm2));
        return zzm2.zza(500L);
    }

    public final String zzj() {
        zzm zzm2 = new zzm();
        this.zza(new zzao(this, zzm2));
        return zzm2.zza(50L);
    }

    public final long generateEventId() {
        zzm zzm2 = new zzm();
        this.zza(new zzap(this, zzm2));
        Long l = (Long)zzm.zza((Bundle)zzm2.zzb(500L), Long.class);
        if (l == null) {
            zzaa zzaa2 = this;
            return new Random(System.nanoTime() ^ zzaa2.zzaa.currentTimeMillis()).nextLong() + (long)(++zzaa2.zzae);
        }
        return l;
    }

    public final String getCurrentScreenName() {
        zzm zzm2 = new zzm();
        this.zza(new zzaq(this, zzm2));
        return zzm2.zza(500L);
    }

    public final String getCurrentScreenClass() {
        zzm zzm2 = new zzm();
        this.zza(new zzar(this, zzm2));
        return zzm2.zza(500L);
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        zzm zzm2 = new zzm();
        this.zza(new zzas(this, string, string2, bl, zzm2));
        Bundle bundle = zzm2.zzb(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zza(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzat(this, false, 5, string, object, null, null));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zzm zzm2 = new zzm();
        this.zza(new zzau(this, bundle, zzm2));
        if (bl) {
            return zzm2.zzb(5000L);
        }
        return null;
    }

    public final int getMaxUserProperties(String string) {
        zzm zzm2 = new zzm();
        this.zza(new zzav(this, string, zzm2));
        Integer n = (Integer)zzm.zza((Bundle)zzm2.zzb(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    @WorkerThread
    public final String getAppInstanceId() {
        zzm zzm2 = new zzm();
        this.zza(new zzaw(this, zzm2));
        return zzm2.zza(120000L);
    }

    public final String getAppIdOrigin() {
        return this.zzam;
    }

    public final Object zzb(int n) {
        zzm zzm2 = new zzm();
        this.zza(new zzay(this, zzm2, n));
        return zzm.zza((Bundle)zzm2.zzb(15000L), Object.class);
    }

    public final void setDataCollectionEnabled(boolean bl) {
        this.zza(new zzaz(this, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zze(Context context) {
        Class<zzaa> clazz = zzaa.class;
        synchronized (zzaa.class) {
            try {
                if (zzaf != null && zzag != null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (com.google.android.gms.internal.measurement.zzaa.zza(context, "app_measurement_internal_disable_startup_flags")) {
                    zzaf = false;
                    zzag = false;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
                zzaf = sharedPreferences.getBoolean(zzah, false);
                zzag = sharedPreferences.getBoolean(zzai, false);
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.remove(zzah);
                editor.remove(zzai);
                editor.apply();
            }
            catch (ClassCastException | IllegalStateException | NullPointerException runtimeException) {
                Log.e((String)"FA", (String)"Exception reading flag from SharedPreferences.", (Throwable)runtimeException);
                zzaf = false;
                zzag = false;
            }
            return;
        }
    }

    public static boolean zzf(Context context) {
        com.google.android.gms.internal.measurement.zzaa.zze(context);
        return zzaf;
    }

    private static boolean zza(Context context, @Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)context).getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo == null || applicationInfo.metaData == null) {
                return false;
            }
            return applicationInfo.metaData.getBoolean(string);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    static /* synthetic */ Map zza(zzaa zzaa2, Map map) {
        zzaa2.zzad = map;
        return zzaa2.zzad;
    }

    static /* synthetic */ boolean zza(zzaa zzaa2, String string, String string2) {
        return com.google.android.gms.internal.measurement.zzaa.zza(string, string2);
    }

    static /* synthetic */ String zzb(zzaa zzaa2) {
        return zzaa2.zzw;
    }

    static /* synthetic */ void zzg(Context context) {
        com.google.android.gms.internal.measurement.zzaa.zze(context);
    }

    static /* synthetic */ Boolean zzk() {
        return zzag;
    }

    static /* synthetic */ zzn zza(zzaa zzaa2, zzn zzn2) {
        zzaa2.zzan = zzn2;
        return zzaa2.zzan;
    }

    static /* synthetic */ zzn zzc(zzaa zzaa2) {
        return zzaa2.zzan;
    }

    static /* synthetic */ int zzh(Context context) {
        return com.google.android.gms.internal.measurement.zzaa.zzd(context);
    }

    static /* synthetic */ int zzi(Context context) {
        return com.google.android.gms.internal.measurement.zzaa.zzc(context);
    }

    static /* synthetic */ Map zzd(zzaa zzaa2) {
        return zzaa2.zzad;
    }

    static {
        zzaf = null;
        zzag = null;
        zzah = "use_dynamite_api";
        zzai = "allow_remote_dynamite";
        zzaj = false;
        zzak = false;
    }

    final class zzd
    implements Application.ActivityLifecycleCallbacks {
        zzd() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzaa.this.zza(new zzbe(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzaa.this.zza(new zzbf(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzaa.this.zza(new zzbg(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzaa.this.zza(new zzbh(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzaa.this.zza(new zzbi(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzm zzm2 = new zzm();
            zzaa.this.zza(new zzbj(this, activity, zzm2));
            Bundle bundle2 = zzm2.zzb(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzaa.this.zza(new zzbk(this, activity));
        }
    }

    static final class zzb
    extends zzu {
        private final zzda zzbu;

        zzb(zzda zzda2) {
            this.zzbu = zzda2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzbu.interceptEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzbu.hashCode();
        }
    }

    static final class zzc
    extends zzu {
        private final zzdb zzbv;

        zzc(zzdb zzdb2) {
            this.zzbv = zzdb2;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzbv.onEvent(string, string2, bundle, l);
        }

        @Override
        public final int id() {
            return this.zzbv.hashCode();
        }
    }

    abstract class zza
    implements Runnable {
        final long timestamp;
        final long zzbs;
        private final boolean zzbt;

        zza() {
            this(true);
        }

        zza(boolean bl) {
            this.timestamp = zzaa.this.zzaa.currentTimeMillis();
            this.zzbs = zzaa.this.zzaa.elapsedRealtime();
            this.zzbt = bl;
        }

        @Override
        public void run() {
            if (zzaa.this.zzal) {
                this.zzm();
                return;
            }
            try {
                this.zzl();
                return;
            }
            catch (Exception exception) {
                zzaa.this.zza(exception, false, this.zzbt);
                this.zzm();
                return;
            }
        }

        protected void zzm() {
        }

        abstract void zzl() throws RemoteException;
    }
}

