/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzyc;
import com.google.android.gms.internal.ads.zzyr;

@zzare
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AdSizeParcelCreator")
public final class zzyb
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzyb> CREATOR = new zzyc();
    @SafeParcelable.Field(id=2)
    public final String zzaap;
    @SafeParcelable.Field(id=3)
    public final int height;
    @SafeParcelable.Field(id=4)
    public final int heightPixels;
    @SafeParcelable.Field(id=5)
    public final boolean zzchg;
    @SafeParcelable.Field(id=6)
    public final int width;
    @SafeParcelable.Field(id=7)
    public final int widthPixels;
    @SafeParcelable.Field(id=8)
    public final zzyb[] zzchh;
    @SafeParcelable.Field(id=9)
    public final boolean zzbta;
    @SafeParcelable.Field(id=10)
    public final boolean zzchi;
    @SafeParcelable.Field(id=11)
    public boolean zzchj;

    public static int zzb(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzc(DisplayMetrics displayMetrics) {
        return (int)((float)zzyb.zzd(displayMetrics) * displayMetrics.density);
    }

    private static int zzd(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static zzyb zzg(Context context) {
        return new zzyb("320x50_mb", 0, 0, false, 0, 0, null, true, false, false);
    }

    public static zzyb zzou() {
        return new zzyb("reward_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzyb() {
        this("interstitial_mb", 0, 0, true, 0, 0, null, false, false, false);
    }

    public zzyb(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    /*
     * Unable to fully structure code
     */
    public zzyb(Context var1_1, AdSize[] var2_2) {
        block11: {
            block10: {
                super();
                var3_3 = var2_2[0];
                this.zzchg = false;
                this.zzchi = var3_3.isFluid();
                if (this.zzchi) {
                    this.width = AdSize.BANNER.getWidth();
                    this.height = AdSize.BANNER.getHeight();
                } else {
                    this.width = var3_3.getWidth();
                    this.height = var3_3.getHeight();
                }
                var4_4 = this.width == -1;
                var5_5 = this.height == -2;
                var6_6 = var1_1.getResources().getDisplayMetrics();
                if (!var4_4) break block10;
                zzyr.zzpa();
                if (!zzazu.zzbh(var1_1)) ** GOTO lbl-1000
                zzyr.zzpa();
                if (zzazu.zzbi(var1_1)) {
                    v0 = var6_6.widthPixels;
                    zzyr.zzpa();
                    this.widthPixels = v0 - zzazu.zzbj(var1_1);
                } else lbl-1000:
                // 2 sources

                {
                    this.widthPixels = var6_6.widthPixels;
                }
                var9_7 = (float)this.widthPixels / var6_6.density;
                var7_10 = (int)var9_7;
                if (var9_7 - (double)((int)var9_7) >= 0.01) {
                    ++var7_10;
                }
                break block11;
            }
            var7_10 = this.width;
            zzyr.zzpa();
            this.widthPixels = zzazu.zza(var6_6, this.width);
        }
        var8_11 = var5_5 != false ? zzyb.zzd(var6_6) : this.height;
        zzyr.zzpa();
        this.heightPixels = zzazu.zza(var6_6, var8_11);
        if (var4_4 || var5_5) {
            var9_8 = var7_10;
            this.zzaap = new StringBuilder(26).append(var9_8).append("x").append(var8_11).append("_as").toString();
        } else {
            this.zzaap = this.zzchi != false ? "320x50_mb" : var3_3.toString();
        }
        if (var2_2.length > 1) {
            this.zzchh = new zzyb[var2_2.length];
            for (var9_9 = 0; var9_9 < var2_2.length; ++var9_9) {
                this.zzchh[var9_9] = new zzyb(var1_1, var2_2[var9_9]);
            }
        } else {
            this.zzchh = null;
        }
        this.zzbta = false;
        this.zzchj = false;
    }

    @SafeParcelable.Constructor
    zzyb(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) int n3, @SafeParcelable.Param(id=7) int n4, @SafeParcelable.Param(id=8) zzyb[] zzybArray, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) boolean bl3, @SafeParcelable.Param(id=11) boolean bl4) {
        this.zzaap = string;
        this.height = n;
        this.heightPixels = n2;
        this.zzchg = bl;
        this.width = n3;
        this.widthPixels = n4;
        this.zzchh = zzybArray;
        this.zzbta = bl2;
        this.zzchi = bl3;
        this.zzchj = bl4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzyb zzyb2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzyb2.zzaap, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)3, (int)zzyb2.height);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)zzyb2.heightPixels);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)zzyb2.zzchg);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)6, (int)zzyb2.width);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)7, (int)zzyb2.widthPixels);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)8, (Parcelable[])zzyb2.zzchh, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)zzyb2.zzbta);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzyb2.zzchi);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)11, (boolean)zzyb2.zzchj);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

