/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzaqz;
import com.google.android.gms.internal.ads.zzara;
import com.google.android.gms.internal.ads.zzarb;
import com.google.android.gms.internal.ads.zzarc;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzdma;
import com.google.android.gms.internal.ads.zzyr;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;

@zzare
@ParametersAreNonnullByDefault
public final class zzaqy
implements zzarc {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzarc zzdlb = null;
    @VisibleForTesting
    private static zzarc zzdlc = null;
    private final Object zzdld = new Object();
    private final Context zzckp;
    private final WeakHashMap<Thread, Boolean> zzdle = new WeakHashMap();
    private final ExecutorService zzxf = Executors.newCachedThreadPool();
    private final zzbaj zzdlf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzarc zzo(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdlb == null) {
                zzaci<Boolean> zzaci2 = zzact.zzclf;
                zzdlb = zzyr.zzpe().zzd(zzaci2) != false ? new zzaqy(context) : new zzard();
            }
        }
        return zzdlb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzarc zzc(Context context, zzbaj zzbaj2) {
        Object object = lock;
        synchronized (object) {
            if (zzdlc == null) {
                Object object2 = zzact.zzclf;
                if (zzyr.zzpe().zzd(object2).booleanValue()) {
                    zzaqy zzaqy2 = new zzaqy(context, zzbaj2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzaqy zzaqy3 = zzaqy2;
                    if (thread != null) {
                        Object object3 = zzaqy3.zzdld;
                        synchronized (object3) {
                            zzaqy3.zzdle.put(thread, true);
                        }
                        object3 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzara(zzaqy3, (Thread.UncaughtExceptionHandler)object3));
                    }
                    object2 = zzaqy2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzaqz((zzaqy)object2, uncaughtExceptionHandler));
                    zzdlc = zzaqy2;
                } else {
                    zzdlc = new zzard();
                }
            }
        }
        return zzdlc;
    }

    private zzaqy(Context context) {
        this(context, zzbaj.zzxc());
    }

    private zzaqy(Context context, zzbaj zzbaj2) {
        this.zzckp = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdlf = zzbaj2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzaqy zzaqy2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzazu.zzej(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzaqy2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzazu.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdma.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzaqy zzaqy2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzbai zzbai2 = new zzbai();
                zzaqy2.zzxf.submit(new zzarb(zzaqy2, zzbai2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzckp).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzbae.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzckp.getPackageName();
        }
        catch (Throwable throwable) {
            zzbae.zzep("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        zzaci<String> zzaci2 = zzact.zzcwf;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdlf.zzbsy).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzact.zzqn())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "237950021").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzyr.zzpf()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzyr.zzpe().zzd(zzaci2)));
    }
}

