/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.os.RemoteException;
import android.view.View;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaeq;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class NativeAdViewHolder {
    private zzaeq zzbqk;
    public static WeakHashMap<View, NativeAdViewHolder> zzbql = new WeakHashMap();
    private WeakReference<View> zzbqm;

    public NativeAdViewHolder(View view, Map<String, View> map, Map<String, View> map2) {
        HashMap<String, View> hashMap;
        Preconditions.checkNotNull((Object)view, (Object)"ContainerView must not be null");
        if (view instanceof NativeAdView || view instanceof UnifiedNativeAdView) {
            zzbae.zzen("The provided containerView is of type of NativeAdView, which cannot be usedwith NativeAdViewHolder.");
            return;
        }
        if (zzbql.get(view) != null) {
            zzbae.zzen("The provided containerView is already in use with another NativeAdViewHolder.");
            return;
        }
        zzbql.put(view, this);
        this.zzbqm = new WeakReference<View>(view);
        HashMap<String, View> hashMap2 = NativeAdViewHolder.zzb(map);
        HashMap<String, View> hashMap3 = hashMap = NativeAdViewHolder.zzb(map2);
        HashMap<String, View> hashMap4 = hashMap2;
        View view2 = view;
        this.zzbqk = zzyr.zzpb().zza(view2, hashMap4, hashMap3);
    }

    private static HashMap<String, View> zzb(Map<String, View> map) {
        if (map == null) {
            return new HashMap<String, View>();
        }
        return new HashMap<String, View>(map);
    }

    public final void setNativeAd(NativeAd nativeAd) {
        this.zze((IObjectWrapper)nativeAd.zzkq());
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        this.zze((IObjectWrapper)unifiedNativeAd.zzkq());
    }

    private final void zze(IObjectWrapper iObjectWrapper) {
        View view = this.zzbqm != null ? (View)this.zzbqm.get() : null;
        if (view == null) {
            zzbae.zzep("NativeAdViewHolder.setNativeAd containerView doesn't exist, returning");
            return;
        }
        if (!zzbql.containsKey(view)) {
            zzbql.put(view, this);
        }
        if (this.zzbqk != null) {
            try {
                this.zzbqk.zze(iObjectWrapper);
                return;
            }
            catch (RemoteException remoteException) {
                zzbae.zzc("Unable to call setNativeAd on delegate", remoteException);
            }
        }
    }

    public final void unregisterNativeAd() {
        View view;
        if (this.zzbqk != null) {
            try {
                this.zzbqk.unregisterNativeAd();
            }
            catch (RemoteException remoteException) {
                zzbae.zzc("Unable to call unregisterNativeAd on delegate", remoteException);
            }
        }
        if ((view = this.zzbqm != null ? (View)this.zzbqm.get() : null) != null) {
            zzbql.remove(view);
        }
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbqk.zzi(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }
}

