/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfa
extends zzdj<Integer>
implements zzfg<Integer>,
zzgt,
RandomAccess {
    private static final zzfa zzahi = new zzfa(new int[0], 0);
    private int[] zzahj;
    private int size;

    zzfa() {
        this(new int[10], 0);
    }

    private zzfa(int[] nArray, int n) {
        this.zzahj = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzka();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzahj, n2, this.zzahj, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfa)) {
            return super.equals(object);
        }
        zzfa zzfa2 = (zzfa)object;
        if (this.size != zzfa2.size) {
            return false;
        }
        int[] nArray = zzfa2.zzahj;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzahj[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzahj[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzo(n);
        return this.zzahj[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzau(int n) {
        this.zzo(this.size, n);
    }

    private final void zzo(int n, int n2) {
        this.zzka();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
        if (this.size < this.zzahj.length) {
            System.arraycopy(this.zzahj, n, this.zzahj, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzahj, 0, nArray, 0, n);
            System.arraycopy(this.zzahj, n, nArray, n + 1, this.size - n);
            this.zzahj = nArray;
        }
        this.zzahj[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzka();
        zzfb.checkNotNull(collection);
        if (!(collection instanceof zzfa)) {
            return super.addAll(collection);
        }
        zzfa zzfa2 = (zzfa)collection;
        if (zzfa2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfa2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfa2.size;
        if (n > this.zzahj.length) {
            this.zzahj = Arrays.copyOf(this.zzahj, n);
        }
        System.arraycopy(zzfa2.zzahj, 0, this.zzahj, this.size, zzfa2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzka();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzahj[i])) continue;
            System.arraycopy(this.zzahj, i + 1, this.zzahj, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzo(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
    }

    private final String zzp(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzfa zzfa2 = this;
        zzfa2.zzka();
        zzfa2.zzo(n);
        int n4 = zzfa2.zzahj[n];
        zzfa2.zzahj[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfa zzfa2 = this;
        zzfa2.zzka();
        zzfa2.zzo(n);
        int n2 = zzfa2.zzahj[n];
        if (n < zzfa2.size - 1) {
            System.arraycopy(zzfa2.zzahj, n + 1, zzfa2.zzahj, n, zzfa2.size - n - 1);
        }
        --zzfa2.size;
        ++zzfa2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzo(n, n2);
    }

    @Override
    public final /* synthetic */ zzfg zzq(int n) {
        int n2 = n;
        zzfa zzfa2 = this;
        if (n2 < zzfa2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfa(Arrays.copyOf(zzfa2.zzahj, n2), zzfa2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzahi.zzjz();
    }
}

