/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.DynamiteApi;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.measurement.zzo;
import com.google.android.gms.internal.measurement.zzq;
import com.google.android.gms.internal.measurement.zzt;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.internal.measurement.zzy;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdb;
import com.google.android.gms.measurement.internal.zzdd;
import com.google.android.gms.measurement.internal.zzdk;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzi;
import com.google.android.gms.measurement.internal.zzj;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.measurement.internal.zzl;
import java.util.Map;

@DynamiteApi
public class AppMeasurementDynamiteService
extends zzo {
    @VisibleForTesting
    zzby zzl = null;
    private Map<Integer, zzdb> zzad = new ArrayMap();

    public AppMeasurementDynamiteService() {
    }

    private final void zzah() {
        if (this.zzl == null) {
            throw new IllegalStateException("Attempting to perform action before initialize.");
        }
    }

    public void initialize(IObjectWrapper iObjectWrapper, zzy zzy2, long l) throws RemoteException {
        Context context = (Context)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        if (this.zzl == null) {
            this.zzl = zzby.zza((Context)context, (zzy)zzy2);
            return;
        }
        this.zzl.zzad().zzdd().zzaq("Attempting to initialize multiple times");
    }

    public void logEvent(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().logEvent(string, string2, bundle, bl, bl2, l);
    }

    public void setUserProperty(String string, String string2, IObjectWrapper iObjectWrapper, boolean bl, long l) throws RemoteException {
        this.zzah();
        Object object = ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zzl.zzs().zza(string, string2, object, bl, l);
    }

    public void setUserId(String string, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().zza(null, "_id", (Object)string, true, l);
    }

    public void setCurrentScreen(IObjectWrapper iObjectWrapper, String string, String string2, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzv().setCurrentScreen((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), string, string2);
    }

    public void setMeasurementEnabled(boolean bl, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().setMeasurementEnabled(bl);
    }

    public void resetAnalyticsData(long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().resetAnalyticsData(l);
    }

    public void setMinimumSessionDuration(long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().setMinimumSessionDuration(l);
    }

    public void setSessionTimeoutDuration(long l) throws RemoteException {
        this.zzah();
        this.zzl.zzs().setSessionTimeoutDuration(l);
    }

    public void getMaxUserProperties(String string, zzq zzq2) throws RemoteException {
        this.zzah();
        this.zzl.zzs();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        string2 = zzq2;
        this.zzl.zzab().zza((zzq)string2, 25);
    }

    public void getCurrentScreenName(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zza(zzq2, this.zzl.zzs().getCurrentScreenName());
    }

    public void getCurrentScreenClass(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zza(zzq2, this.zzl.zzs().getCurrentScreenClass());
    }

    public void getCachedAppInstanceId(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zza(zzq2, this.zzl.zzs().zzj());
    }

    public void getAppInstanceId(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zzl.zzac().zza((Runnable)new zzh(this, zzq2));
    }

    public void getGmpAppId(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zza(zzq2, this.zzl.zzs().getGmpAppId());
    }

    public void generateEventId(zzq zzq2) throws RemoteException {
        this.zzah();
        long l = this.zzl.zzab().zzgk();
        zzq zzq3 = zzq2;
        this.zzl.zzab().zza(zzq3, l);
    }

    public void beginAdUnitExposure(String string, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzr().beginAdUnitExposure(string, l);
    }

    public void endAdUnitExposure(String string, long l) throws RemoteException {
        this.zzah();
        this.zzl.zzr().endAdUnitExposure(string, l);
    }

    public void initForTests(Map map) throws RemoteException {
        this.zzah();
    }

    public void logEventAndBundle(String string, String string2, Bundle bundle, zzq zzq2, long l) throws RemoteException {
        this.zzah();
        Preconditions.checkNotEmpty((String)string2);
        String string3 = "app";
        (bundle != null ? new Bundle(bundle) : new Bundle()).putString("_o", string3);
        zzaj zzaj2 = new zzaj(string2, new zzag(bundle), string3, l);
        this.zzl.zzac().zza((Runnable)new zzi(this, zzq2, zzaj2, string));
    }

    public void onActivityStarted(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityStarted((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityStopped(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityStopped((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityCreated(IObjectWrapper iObjectWrapper, Bundle bundle, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        this.zzl.zzad().zzdd().zzaq("Got on activity created");
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityCreated((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
    }

    public void onActivityDestroyed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityDestroyed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityPaused(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityPaused((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivityResumed(IObjectWrapper iObjectWrapper, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivityResumed((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        }
    }

    public void onActivitySaveInstanceState(IObjectWrapper iObjectWrapper, zzq zzq2, long l) throws RemoteException {
        this.zzah();
        zzdx zzdx2 = this.zzl.zzs().zzpf;
        Bundle bundle = new Bundle();
        if (zzdx2 != null) {
            this.zzl.zzs().zzeu();
            zzdx2.onActivitySaveInstanceState((Activity)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper), bundle);
        }
        try {
            zzq2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzl.zzad().zzdd().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public void performAction(Bundle bundle, zzq zzq2, long l) throws RemoteException {
        this.zzah();
        zzq2.zzb(null);
    }

    public void getUserProperties(String string, String string2, boolean bl, zzq zzq2) throws RemoteException {
        this.zzah();
        this.zzl.zzac().zza((Runnable)new zzj(this, zzq2, string, string2, bl));
    }

    public void logHealthData(int n, String string, IObjectWrapper iObjectWrapper, IObjectWrapper iObjectWrapper2, IObjectWrapper iObjectWrapper3) throws RemoteException {
        this.zzah();
        Object object = iObjectWrapper == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        Object object2 = iObjectWrapper2 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper2);
        Object object3 = iObjectWrapper3 == null ? null : ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper3);
        this.zzl.zzad().zza(n, true, false, string, object, object2, object3);
    }

    public void setEventInterceptor(zzt zzt2) throws RemoteException {
        this.zzah();
        zza zza2 = new zza(zzt2);
        zzdd zzdd2 = this.zzl.zzs();
        zzdd2.zzo();
        zzdd2.zzah();
        zzdd2.zzac().zza((Runnable)new zzdk(zzdd2, (zzda)zza2));
    }

    public void registerOnMeasurementEventListener(zzt zzt2) throws RemoteException {
        this.zzah();
        zzdb zzdb2 = this.zzad.get(zzt2.id());
        if (zzdb2 == null) {
            zzdb2 = new zzb(zzt2);
            this.zzad.put(zzt2.id(), zzdb2);
        }
        this.zzl.zzs().zza(zzdb2);
    }

    public void unregisterOnMeasurementEventListener(zzt zzt2) throws RemoteException {
        this.zzah();
        zzdb zzdb2 = this.zzad.remove(zzt2.id());
        if (zzdb2 == null) {
            zzdb2 = new zzb(zzt2);
        }
        this.zzl.zzs().zzb(zzdb2);
    }

    public void setInstanceIdProvider(zzw zzw2) throws RemoteException {
        this.zzah();
    }

    public void setConditionalUserProperty(Bundle bundle, long l) throws RemoteException {
        this.zzah();
        if (bundle == null) {
            this.zzl.zzad().zzda().zzaq("Conditional user property must not be null");
            return;
        }
        this.zzl.zzs().setConditionalUserProperty(bundle, l);
    }

    public void clearConditionalUserProperty(String string, String string2, Bundle bundle) throws RemoteException {
        this.zzah();
        this.zzl.zzs().clearConditionalUserProperty(string, string2, bundle);
    }

    public void getConditionalUserProperties(String string, String string2, zzq zzq2) throws RemoteException {
        this.zzah();
        this.zzl.zzac().zza((Runnable)new zzk(this, zzq2, string, string2));
    }

    public void getTestFlag(zzq zzq2, int n) throws RemoteException {
        this.zzah();
        switch (n) {
            case 0: {
                this.zzl.zzab().zzb(zzq2, this.zzl.zzs().zzew());
                return;
            }
            case 1: {
                this.zzl.zzab().zza(zzq2, this.zzl.zzs().zzex().longValue());
                return;
            }
            case 2: {
                double d = this.zzl.zzs().zzez();
                zzq zzq3 = zzq2;
                zzgd zzgd2 = this.zzl.zzab();
                Bundle bundle = new Bundle();
                bundle.putDouble("r", d);
                try {
                    zzq3.zzb(bundle);
                    return;
                }
                catch (RemoteException remoteException) {
                    zzgd2.zzl.zzad().zzdd().zza("Error returning double value to wrapper", (Object)remoteException);
                    return;
                }
            }
            case 3: {
                this.zzl.zzab().zza(zzq2, this.zzl.zzs().zzey().intValue());
                return;
            }
            case 4: {
                this.zzl.zzab().zza(zzq2, this.zzl.zzs().zzev().booleanValue());
            }
        }
    }

    private final void zza(zzq zzq2, String string) {
        this.zzl.zzab().zzb(zzq2, string);
    }

    public void setDataCollectionEnabled(boolean bl) throws RemoteException {
        this.zzah();
        this.zzl.zzs().zza(bl);
    }

    public void isDataCollectionEnabled(zzq zzq2) throws RemoteException {
        this.zzah();
        this.zzl.zzac().zza((Runnable)new zzl(this, zzq2));
    }

    final class zza
    implements zzda {
        private zzt zzdm;

        zza(zzt zzt2) {
            this.zzdm = zzt2;
        }

        public final void interceptEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zzdm.onEvent(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zzl.zzad().zzdd().zza("Event interceptor threw exception", (Object)remoteException);
                return;
            }
        }
    }

    final class zzb
    implements zzdb {
        private zzt zzdm;

        zzb(zzt zzt2) {
            this.zzdm = zzt2;
        }

        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            try {
                this.zzdm.onEvent(string, string2, bundle, l);
                return;
            }
            catch (RemoteException remoteException) {
                AppMeasurementDynamiteService.this.zzl.zzad().zzdd().zza("Event listener threw exception", (Object)remoteException);
                return;
            }
        }
    }
}

