/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzum;
import com.google.android.gms.internal.ads.zzun;
import com.google.android.gms.internal.ads.zzut;
import com.google.android.gms.internal.ads.zzuu;
import com.google.android.gms.internal.ads.zzuw;
import com.google.android.gms.internal.ads.zzyr;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzus
extends Thread {
    private boolean started = false;
    private boolean zzbva = false;
    private boolean zzbvb = false;
    private final Object lock;
    private final zzun zzbvc;
    private final int zzbvd;
    private final int zzbua;
    private final int zzbve;
    private final int zzbuc;
    private final int zzbvf;
    private final int zzbvg;
    private final int zzbvh;
    private final int zzbvi;
    private final String zzbvj;
    private final boolean zzbvk;
    private final boolean zzbud;
    private final boolean zzbvl;

    public zzus() {
        this(new zzun());
    }

    @VisibleForTesting
    private zzus(zzun zzun2) {
        this.zzbvc = zzun2;
        this.lock = new Object();
        zzaci zzaci2 = zzact.zzcnc;
        this.zzbua = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnd;
        this.zzbve = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcne;
        this.zzbuc = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnf;
        this.zzbvf = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnh;
        this.zzbvg = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcni;
        this.zzbvh = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnj;
        this.zzbvi = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcng;
        this.zzbvd = (Integer)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnl;
        this.zzbvj = (String)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnm;
        this.zzbvk = (Boolean)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnq;
        this.zzbud = (Boolean)zzyr.zzpe().zzd(zzaci2);
        zzaci2 = zzact.zzcnr;
        this.zzbvl = (Boolean)zzyr.zzpe().zzd(zzaci2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmv() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                zzaxa.zzdp((String)"Content hash thread already started, quiting...");
                return;
            }
            this.started = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzus.zzmw()) {
                    object = zzk.zzlj().getActivity();
                    if (object == null) {
                        zzaxa.zzdp((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzmy();
                    } else {
                        Activity activity = object;
                        zzus zzus2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzk.zzlk().zza(exception, "ContentFetchTask.extractContent");
                                zzaxa.zzdp((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzus zzus3 = zzus2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzut(zzus3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzaxa.zzdp((String)"ContentFetchTask: sleeping");
                    this.zzmy();
                }
                Thread.sleep(this.zzbvd * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzaxa.zzc((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzaxa.zzc((String)"Error in ContentFetchTask", (Throwable)exception);
                zzk.zzlk().zza(exception, "ContentFetchTask.run");
            }
            object = this.lock;
            synchronized (object) {
                while (this.zzbva) {
                    try {
                        zzaxa.zzdp((String)"ContentFetchTask: waiting");
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzi(View view) {
        try {
            zzum zzum2 = new zzum(this.zzbua, this.zzbve, this.zzbuc, this.zzbvf, this.zzbvg, this.zzbvh, this.zzbvi, this.zzbud);
            Context context = zzk.zzlj().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzbvj)) {
                zzaci zzaci2 = zzact.zzcnk;
                int n = context.getResources().getIdentifier((String)zzyr.zzpe().zzd(zzaci2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzbvj)) {
                    return;
                }
            }
            zzuw zzuw2 = this.zza(view, zzum2);
            zzum2.zzmt();
            if (zzuw2.zzbvt == 0 && zzuw2.zzbvu == 0) {
                return;
            }
            if (zzuw2.zzbvu == 0 && zzum2.zzmu() == 0) {
                return;
            }
            if (zzuw2.zzbvu == 0 && this.zzbvc.zza(zzum2)) {
                return;
            }
            this.zzbvc.zzc(zzum2);
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzk.zzlk().zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzmw() {
        try {
            Context context = zzk.zzlj().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzk.zzlk().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzuw zza(@Nullable View view, zzum zzum2) {
        if (view == null) {
            return new zzuw(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzum2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzuw(this, 1, 0);
            }
            return new zzuw(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzbha)) {
            boolean bl2;
            zzum zzum3 = zzum2;
            WebView webView = (WebView)view;
            zzus zzus2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzum3.zzmr();
                webView.post((Runnable)new zzuu(zzus2, zzum3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzuw(this, 0, 1);
            }
            return new zzuw(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzuw zzuw2 = this.zza(viewGroup.getChildAt(i), zzum2);
                n += zzuw2.zzbvt;
                n2 += zzuw2.zzbvu;
            }
            return new zzuw(this, n, n2);
        }
        return new zzuw(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzum zzum2, WebView webView, String string2, boolean bl) {
        zzum2.zzmq();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzbvk && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzum2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzum2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzum2.zzml()) {
                this.zzbvc.zzb(zzum2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzaxa.zzdp((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzaxa.zzb((String)"Failed to get webview content.", (Throwable)throwable);
            zzk.zzlk().zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzum zzmx() {
        return this.zzbvc.zzo(this.zzbvl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.zzbva = false;
            this.lock.notifyAll();
            zzaxa.zzdp((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzmy() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.zzbva = true;
            zzaxa.zzdp((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzmz() {
        return this.zzbva;
    }
}

