/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListView;
import android.widget.ScrollView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzazk;
import com.google.android.gms.internal.ads.zztz;
import com.google.android.gms.internal.ads.zzua;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@zzare
@TargetApi(value=14)
public final class zzty
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzbtf;
    private final Context zzys;
    private Application zzww;
    private final WindowManager zzbtg;
    private final PowerManager zzyt;
    private final KeyguardManager zzyu;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzbth;
    private WeakReference<ViewTreeObserver> zzyw;
    private WeakReference<View> zzbti;
    private zzud zzbtj;
    private zzazk zzbtk = new zzazk(zzbtf);
    private boolean zzbtl = false;
    private int zzza = -1;
    private final HashSet<zzuc> zzbtm = new HashSet();
    private final DisplayMetrics zzwb;
    private final Rect zzbtn;

    public zzty(Context context, View view) {
        this.zzys = context.getApplicationContext();
        this.zzbtg = (WindowManager)context.getSystemService("window");
        this.zzyt = (PowerManager)this.zzys.getSystemService("power");
        this.zzyu = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzys instanceof Application) {
            this.zzww = (Application)this.zzys;
            this.zzbtj = new zzud((Application)this.zzys, this);
        }
        this.zzwb = context.getResources().getDisplayMetrics();
        this.zzbtn = new Rect();
        this.zzbtn.right = this.zzbtg.getDefaultDisplay().getWidth();
        this.zzbtn.bottom = this.zzbtg.getDefaultDisplay().getHeight();
        View view2 = view;
        zzty zzty2 = this;
        View view3 = zzty2.zzbti != null ? (View)zzty2.zzbti.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzty2);
            zzty2.zzf(view3);
        }
        zzty2.zzbti = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzk.zzli().isAttachedToWindow(view2)) {
                zzty2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzty2);
        }
    }

    public final void zza(zzuc zzuc2) {
        this.zzbtm.add(zzuc2);
        this.zzbu(3);
    }

    public final void zzb(zzuc zzuc2) {
        this.zzbtm.remove(zzuc2);
    }

    private final void zzcu() {
        zzk.zzlg();
        zzaxj.zzdvx.post((Runnable)new zztz(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzza = -1;
        this.zze(view);
        this.zzbu(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzza = -1;
        this.zzbu(3);
        this.zzcu();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzbti == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzbti.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzza = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onGlobalLayout() {
        this.zzbu(2);
        this.zzcu();
    }

    public final void onScrollChanged() {
        this.zzbu(1);
    }

    private final void zzbu(int n) {
        boolean bl;
        if (this.zzbtm.size() == 0) {
            return;
        }
        if (this.zzbti == null) {
            return;
        }
        View view = (View)this.zzbti.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzaxa.zzc((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        zzaci zzaci2 = zzact.zzcqm;
        List<Rect> list = (Boolean)zzyr.zzpe().zzd(zzaci2) != false && view != null ? this.zzh(view) : Collections.emptyList();
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzza != -1 ? this.zzza : n2;
        boolean bl6 = bl = !bl3 && zzk.zzlg().zza(view, this.zzyt, this.zzyu) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzbtk.tryAcquire() && bl == this.zzbtl) {
            return;
        }
        if (!bl && !this.zzbtl && n == 1) {
            return;
        }
        zzub zzub2 = new zzub(zzk.zzln().elapsedRealtime(), this.zzyt.isScreenOn(), view != null && zzk.zzli().isAttachedToWindow(view), view != null ? view.getWindowVisibility() : 8, this.zza(this.zzbtn), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwb.density, bl, list);
        Iterator<zzuc> iterator = this.zzbtm.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzub2);
        }
        this.zzbtl = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzbv(rect.left), this.zzbv(rect.top), this.zzbv(rect.right), this.zzbv(rect.bottom));
    }

    private final int zzbv(int n) {
        float f = this.zzwb.density;
        return (int)((float)n / f);
    }

    private final List<Rect> zzh(View view) {
        try {
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof View) {
                View view2 = (View)viewParent;
                Rect rect = new Rect();
                View view3 = view2;
                if ((Build.VERSION.SDK_INT >= 16 ? view3.isScrollContainer() : view3 instanceof ScrollView || view3 instanceof ListView) && view2.getGlobalVisibleRect(rect)) {
                    arrayList.add(this.zza(rect));
                }
                viewParent = viewParent.getParent();
            }
            return arrayList;
        }
        catch (Exception exception) {
            zzk.zzlk().zza(exception, "PositionWatcher.getParentScrollViewRects");
            return Collections.emptyList();
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzyw = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzty zzty2 = this;
        if (zzty2.zzbth == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzty2.zzbth = new zzua(zzty2);
            zzk.zzmb().zza(zzty2.zzys, zzty2.zzbth, intentFilter);
        }
        if (this.zzww != null) {
            try {
                this.zzww.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbtj);
                return;
            }
            catch (Exception exception) {
                zzaxa.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzyw != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzyw.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzyw = null;
            }
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzty zzty2 = this;
        if (zzty2.zzbth != null) {
            try {
                zzk.zzmb().zza(zzty2.zzys, zzty2.zzbth);
            }
            catch (IllegalStateException illegalStateException) {
                zzaxa.zzc((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzk.zzlk().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzty2.zzbth = null;
        }
        if (this.zzww != null) {
            try {
                this.zzww.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbtj);
                return;
            }
            catch (Exception exception) {
                zzaxa.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public final void zzes(long l) {
        this.zzbtk.zzfe(l);
    }

    public final void zzmk() {
        this.zzbtk.zzfe(zzbtf);
    }

    static /* synthetic */ void zza(zzty zzty2, int n) {
        zzty2.zzbu(3);
    }

    static {
        zzaci zzaci2 = zzact.zzcqj;
        zzbtf = (Long)zzyr.zzpe().zzd(zzaci2);
    }
}

