/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioTrack;
import android.os.ConditionVariable;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.internal.ads.zzkt;
import com.google.android.gms.internal.ads.zzln;
import com.google.android.gms.internal.ads.zzlv;
import com.google.android.gms.internal.ads.zzlw;
import com.google.android.gms.internal.ads.zzlx;
import com.google.android.gms.internal.ads.zzly;
import com.google.android.gms.internal.ads.zzmi;
import com.google.android.gms.internal.ads.zzmj;
import com.google.android.gms.internal.ads.zzmk;
import com.google.android.gms.internal.ads.zzml;
import com.google.android.gms.internal.ads.zzmm;
import com.google.android.gms.internal.ads.zzmn;
import com.google.android.gms.internal.ads.zzmo;
import com.google.android.gms.internal.ads.zzmp;
import com.google.android.gms.internal.ads.zzmq;
import com.google.android.gms.internal.ads.zzmr;
import com.google.android.gms.internal.ads.zzmv;
import com.google.android.gms.internal.ads.zzmx;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsy;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;

public final class zzmh {
    private static boolean zzagc = false;
    private static boolean zzavt = false;
    private final zzlw zzavu = null;
    private final zzmq zzavv;
    private final zzmx zzavw;
    private final zzlx[] zzavx;
    private final zzmn zzavy;
    private final ConditionVariable zzagd;
    private final long[] zzage;
    private final zzmj zzavz;
    private final LinkedList<zzmo> zzawa;
    private AudioTrack zzagg;
    private int zzafv;
    private int zzagh;
    private int zzagi;
    private int zzawb;
    private int streamType;
    private boolean zzawc;
    private int zzagl;
    private long zzawd;
    private zzln zzawe;
    private zzln zzasc;
    private long zzawf;
    private long zzawg;
    private ByteBuffer zzawh;
    private int zzawi;
    private int zzagm;
    private int zzagn;
    private long zzago;
    private long zzagp;
    private boolean zzagq;
    private long zzagr;
    private Method zzags;
    private int zzawj;
    private long zzawk;
    private long zzawl;
    private int zzawm;
    private long zzawn;
    private long zzawo;
    private int zzawp;
    private int zzagu;
    private long zzagv;
    private long zzagw;
    private long zzagx;
    private float zzcv;
    private zzlx[] zzawq;
    private ByteBuffer[] zzadt;
    private ByteBuffer zzawr;
    private ByteBuffer zzaws;
    private byte[] zzawt;
    private int zzawu;
    private int zzawv;
    private boolean zzaww;
    private boolean zzawx;
    private int zzada;
    private boolean zzawy;
    private boolean zzawz;
    private long zzaxa;

    public zzmh(zzlw zzlw2, zzlx[] zzlxArray, zzmn zzmn2) {
        this.zzavy = zzmn2;
        this.zzagd = new ConditionVariable(true);
        if (zzsy.SDK_INT >= 18) {
            try {
                this.zzags = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        this.zzavz = zzsy.SDK_INT >= 19 ? new zzmk() : new zzmj(null);
        this.zzavv = new zzmq();
        this.zzavw = new zzmx();
        this.zzavx = new zzlx[3 + zzlxArray.length];
        this.zzavx[0] = new zzmv();
        this.zzavx[1] = this.zzavv;
        System.arraycopy(zzlxArray, 0, this.zzavx, 2, zzlxArray.length);
        this.zzavx[2 + zzlxArray.length] = this.zzavw;
        this.zzage = new long[10];
        this.zzcv = 1.0f;
        this.zzagu = 0;
        this.streamType = 3;
        this.zzada = 0;
        this.zzasc = zzln.zzaug;
        this.zzawv = -1;
        this.zzawq = new zzlx[0];
        this.zzadt = new ByteBuffer[0];
        this.zzawa = new LinkedList();
    }

    public final boolean zzaz(String string2) {
        return this.zzavu != null && this.zzavu.zzaf(zzmh.zzba(string2));
    }

    public final long zzf(boolean bl) {
        long l;
        long l2;
        zzmh zzmh2 = this;
        if (!(zzmh2.isInitialized() && zzmh2.zzagu != 0)) {
            return Long.MIN_VALUE;
        }
        if (this.zzagg.getPlayState() == 3) {
            zzmh2 = this;
            l2 = zzmh2.zzavz.zzdv();
            if (l2 != 0L) {
                long l3 = System.nanoTime() / 1000L;
                if (l3 - zzmh2.zzagp >= 30000L) {
                    zzmh2.zzage[zzmh2.zzagm] = l2 - l3;
                    zzmh2.zzagm = (zzmh2.zzagm + 1) % 10;
                    if (zzmh2.zzagn < 10) {
                        ++zzmh2.zzagn;
                    }
                    zzmh2.zzagp = l3;
                    zzmh2.zzago = 0L;
                    for (int i = 0; i < zzmh2.zzagn; ++i) {
                        zzmh2.zzago += zzmh2.zzage[i] / (long)zzmh2.zzagn;
                    }
                }
                if (!zzmh2.zzhu() && l3 - zzmh2.zzagr >= 500000L) {
                    zzmh2.zzagq = zzmh2.zzavz.zzex();
                    if (zzmh2.zzagq) {
                        String string2;
                        long l4 = zzmh2.zzavz.zzey() / 1000L;
                        long l5 = zzmh2.zzavz.zzez();
                        if (l4 < zzmh2.zzagw) {
                            zzmh2.zzagq = false;
                        } else if (Math.abs(l4 - l3) > 5000000L) {
                            string2 = new StringBuilder(136).append("Spurious audio timestamp (system clock mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzmh2.zzagq = false;
                        } else if (Math.abs(zzmh2.zzdo(l5) - l2) > 5000000L) {
                            string2 = new StringBuilder(138).append("Spurious audio timestamp (frame position mismatch): ").append(l5).append(", ").append(l4).append(", ").append(l3).append(", ").append(l2).toString();
                            Log.w((String)"AudioTrack", (String)string2);
                            zzmh2.zzagq = false;
                        }
                    }
                    if (zzmh2.zzags != null && !zzmh2.zzawc) {
                        try {
                            zzmh2.zzagx = (long)((Integer)zzmh2.zzags.invoke((Object)zzmh2.zzagg, null)).intValue() * 1000L - zzmh2.zzawd;
                            zzmh2.zzagx = Math.max(zzmh2.zzagx, 0L);
                            if (zzmh2.zzagx > 5000000L) {
                                long l6 = zzmh2.zzagx;
                                Log.w((String)"AudioTrack", (String)new StringBuilder(61).append("Ignoring impossibly large audio latency: ").append(l6).toString());
                                zzmh2.zzagx = 0L;
                            }
                        }
                        catch (Exception exception) {
                            zzmh2.zzags = null;
                        }
                    }
                    zzmh2.zzagr = l3;
                }
            }
        }
        long l7 = System.nanoTime() / 1000L;
        if (this.zzagq) {
            long l8 = l7 - this.zzavz.zzey() / 1000L;
            long l9 = this.zzdp(l8);
            long l10 = this.zzavz.zzez() + l9;
            l = this.zzdo(l10);
        } else {
            l = this.zzagn == 0 ? this.zzavz.zzdv() : l7 + this.zzago;
            if (!bl) {
                l -= this.zzagx;
            }
        }
        l2 = l;
        zzmh2 = this;
        while (!zzmh2.zzawa.isEmpty() && l2 >= zzmo.zzb(zzmh2.zzawa.getFirst())) {
            zzmo zzmo2 = zzmh2.zzawa.remove();
            zzmh2.zzasc = zzmo.zza(zzmo2);
            zzmh2.zzawg = zzmo.zzb(zzmo2);
            zzmh2.zzawf = zzmo.zzc(zzmo2) - zzmh2.zzagv;
        }
        return this.zzagv + (zzmh2.zzasc.zzauh == 1.0f ? l2 + zzmh2.zzawf - zzmh2.zzawg : (zzmh2.zzawa.isEmpty() && zzmh2.zzavw.zzia() >= 1024L ? zzmh2.zzawf + zzsy.zza(l2 - zzmh2.zzawg, zzmh2.zzavw.zzhz(), zzmh2.zzavw.zzia()) : zzmh2.zzawf + (long)((double)zzmh2.zzasc.zzauh * (double)(l2 - zzmh2.zzawg))));
    }

    public final void zza(String string2, int n, int n2, int n3, int n4, int[] nArray) throws zzml {
        int n5;
        zzmh zzmh2;
        int n6;
        int n7;
        int n8;
        boolean bl = !"audio/raw".equals(string2);
        int n9 = bl ? zzmh.zzba(string2) : n3;
        boolean bl2 = false;
        if (!bl) {
            this.zzawj = zzsy.zzg(n3, n);
            this.zzavv.zzb(nArray);
            zzlx[] zzlxArray = this.zzavx;
            n8 = this.zzavx.length;
            for (n7 = 0; n7 < n8; ++n7) {
                zzlx zzlx2 = zzlxArray[n7];
                try {
                    bl2 |= zzlx2.zzb(n2, n, n9);
                }
                catch (zzly zzly2) {
                    throw new zzml(zzly2);
                }
                if (!zzlx2.isActive()) continue;
                n = zzlx2.zzhj();
                n9 = zzlx2.zzhk();
            }
            if (bl2) {
                this.zzhn();
            }
        }
        switch (n) {
            case 1: {
                n6 = 4;
                break;
            }
            case 2: {
                n6 = 12;
                break;
            }
            case 3: {
                n6 = 28;
                break;
            }
            case 4: {
                n6 = 204;
                break;
            }
            case 5: {
                n6 = 220;
                break;
            }
            case 6: {
                n6 = 252;
                break;
            }
            case 7: {
                n6 = 1276;
                break;
            }
            case 8: {
                n6 = zzkt.CHANNEL_OUT_7POINT1_SURROUND;
                break;
            }
            default: {
                n8 = n;
                throw new zzml(new StringBuilder(38).append("Unsupported channel count: ").append(n8).toString());
            }
        }
        if (zzsy.SDK_INT <= 23 && "foster".equals(zzsy.DEVICE) && "NVIDIA".equals(zzsy.MANUFACTURER)) {
            switch (n) {
                case 7: {
                    n6 = zzkt.CHANNEL_OUT_7POINT1_SURROUND;
                    break;
                }
                case 3: 
                case 5: {
                    n6 = 252;
                }
            }
        }
        if (zzsy.SDK_INT <= 25 && "fugu".equals(zzsy.DEVICE) && bl && n == 1) {
            n6 = 12;
        }
        if (!bl2 && this.isInitialized() && this.zzagi == n9 && this.zzafv == n2 && this.zzagh == n6) {
            return;
        }
        this.reset();
        this.zzagi = n9;
        this.zzawc = bl;
        this.zzafv = n2;
        this.zzagh = n6;
        this.zzawb = bl ? n9 : 2;
        this.zzawm = zzsy.zzg(2, n);
        if (bl) {
            if (this.zzawb == 5 || this.zzawb == 6) {
                zzmh2 = this;
                n5 = 20480;
            } else {
                zzmh2 = this;
                n5 = 49152;
            }
        } else {
            n8 = AudioTrack.getMinBufferSize((int)n2, (int)n6, (int)this.zzawb);
            zzsk.checkState(n8 != -2);
            n7 = n8 << 2;
            int n10 = (int)this.zzdp(250000L) * this.zzawm;
            int n11 = (int)Math.max((long)n8, this.zzdp(750000L) * (long)this.zzawm);
            zzmh2 = this;
            n5 = n7 < n10 ? n10 : (n7 > n11 ? n11 : n7);
        }
        zzmh2.zzagl = n5;
        this.zzawd = bl ? -9223372036854775807L : this.zzdo(this.zzagl / this.zzawm);
        this.zzb(this.zzasc);
    }

    private final void zzhn() {
        ArrayList<zzlx> arrayList = new ArrayList<zzlx>();
        zzlx[] zzlxArray = this.zzavx;
        int n = this.zzavx.length;
        for (int i = 0; i < n; ++i) {
            zzlx zzlx2 = zzlxArray[i];
            if (zzlx2.isActive()) {
                arrayList.add(zzlx2);
                continue;
            }
            zzlx2.flush();
        }
        int n2 = arrayList.size();
        this.zzawq = arrayList.toArray(new zzlx[n2]);
        this.zzadt = new ByteBuffer[n2];
        for (n = 0; n < n2; ++n) {
            zzlx zzlx3 = this.zzawq[n];
            zzlx3.flush();
            this.zzadt[n] = zzlx3.zzhm();
        }
    }

    public final void play() {
        this.zzawx = true;
        if (this.isInitialized()) {
            this.zzagw = System.nanoTime() / 1000L;
            this.zzagg.play();
        }
    }

    public final void zzeq() {
        if (this.zzagu == 1) {
            this.zzagu = 2;
        }
    }

    public final boolean zza(ByteBuffer byteBuffer, long l) throws zzmm, zzmp {
        long l2;
        zzmh zzmh2;
        zzsk.checkArgument(this.zzawr == null || byteBuffer == this.zzawr);
        if (!this.isInitialized()) {
            int n;
            zzmh2 = this;
            zzmh2.zzagd.block();
            if (zzmh2.zzawy) {
                int n2 = zzmh2.zzada;
                int n3 = zzmh2.zzagl;
                int n4 = zzmh2.zzawb;
                n = zzmh2.zzagh;
                int n5 = zzmh2.zzafv;
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).setFlags(16).build();
                AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(n).setEncoding(n4).setSampleRate(n5).build();
                zzmh2.zzagg = new AudioTrack(audioAttributes, audioFormat, n3, 1, n2);
            } else {
                zzmh2.zzagg = zzmh2.zzada == 0 ? new AudioTrack(zzmh2.streamType, zzmh2.zzafv, zzmh2.zzagh, zzmh2.zzawb, zzmh2.zzagl, 1) : new AudioTrack(zzmh2.streamType, zzmh2.zzafv, zzmh2.zzagh, zzmh2.zzawb, zzmh2.zzagl, 1, zzmh2.zzada);
            }
            zzmh zzmh3 = zzmh2;
            n = zzmh3.zzagg.getState();
            if (n != 1) {
                try {
                    zzmh3.zzagg.release();
                }
                catch (Exception exception) {
                }
                finally {
                    zzmh3.zzagg = null;
                }
                throw new zzmm(n, zzmh3.zzafv, zzmh3.zzagh, zzmh3.zzagl);
            }
            int n6 = zzmh2.zzagg.getAudioSessionId();
            if (zzmh2.zzada != n6) {
                zzmh2.zzada = n6;
                zzmh2.zzavy.zzag(n6);
            }
            zzmh2.zzavz.zza(zzmh2.zzagg, zzmh2.zzhu());
            zzmh2.zzhs();
            zzmh2.zzawz = false;
            if (this.zzawx) {
                this.play();
            }
        }
        if (this.zzhu()) {
            if (this.zzagg.getPlayState() == 2) {
                this.zzawz = false;
                return false;
            }
            if (this.zzagg.getPlayState() == 1 && this.zzavz.zzev() != 0L) {
                return false;
            }
        }
        boolean bl = this.zzawz;
        this.zzawz = this.zzer();
        if (bl && !this.zzawz && this.zzagg.getPlayState() != 1) {
            l2 = SystemClock.elapsedRealtime() - this.zzaxa;
            this.zzavy.zze(this.zzagl, zzkt.zzdz(this.zzawd), l2);
        }
        if (this.zzawr == null) {
            if (!byteBuffer.hasRemaining()) {
                return true;
            }
            if (this.zzawc && this.zzawp == 0) {
                int n;
                ByteBuffer byteBuffer2 = byteBuffer;
                int n7 = this.zzawb;
                if (n7 == 7 || n7 == 8) {
                    n = zzmr.zzj(byteBuffer2);
                } else if (n7 == 5) {
                    n = zzlv.zzhi();
                } else if (n7 == 6) {
                    n = zzlv.zzh(byteBuffer2);
                } else {
                    throw new IllegalStateException(new StringBuilder(38).append("Unexpected audio encoding: ").append(n7).toString());
                }
                this.zzawp = n;
            }
            if (this.zzawe != null) {
                if (!this.zzhp()) {
                    return false;
                }
                this.zzawa.add(new zzmo(this.zzawe, Math.max(0L, l), this.zzdo(this.zzht()), null));
                this.zzawe = null;
                this.zzhn();
            }
            if (this.zzagu == 0) {
                this.zzagv = Math.max(0L, l);
                this.zzagu = 1;
            } else {
                zzmh2 = this;
                l2 = this.zzagv + this.zzdo(zzmh2.zzawc ? zzmh2.zzawl : zzmh2.zzawk / (long)zzmh2.zzawj);
                if (this.zzagu == 1 && Math.abs(l2 - l) > 200000L) {
                    Log.e((String)"AudioTrack", (String)new StringBuilder(80).append("Discontinuity detected [expected ").append(l2).append(", got ").append(l).append("]").toString());
                    this.zzagu = 2;
                }
                if (this.zzagu == 2) {
                    this.zzagv += l - l2;
                    this.zzagu = 1;
                    this.zzavy.zzgt();
                }
            }
            if (this.zzawc) {
                this.zzawl += (long)this.zzawp;
            } else {
                this.zzawk += (long)byteBuffer.remaining();
            }
            this.zzawr = byteBuffer;
        }
        if (this.zzawc) {
            this.zzb(this.zzawr, l);
        } else {
            this.zzeg(l);
        }
        if (!this.zzawr.hasRemaining()) {
            this.zzawr = null;
            return true;
        }
        return false;
    }

    private final void zzeg(long l) throws zzmp {
        int n;
        int n2 = n = this.zzawq.length;
        while (n2 >= 0) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2 = n2 > 0 ? this.zzadt[n2 - 1] : (byteBuffer = this.zzawr != null ? this.zzawr : zzlx.zzavh);
            if (n2 == n) {
                this.zzb(byteBuffer, l);
            } else {
                ByteBuffer byteBuffer3;
                zzlx zzlx2 = this.zzawq[n2];
                zzlx2.zzi(byteBuffer);
                this.zzadt[n2] = byteBuffer3 = zzlx2.zzhm();
                if (byteBuffer3.hasRemaining()) {
                    ++n2;
                    continue;
                }
            }
            if (byteBuffer.hasRemaining()) {
                return;
            }
            --n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean zzb(ByteBuffer var1_1, long var2_2) throws zzmp {
        block19: {
            block20: {
                block18: {
                    if (!var1_1.hasRemaining()) {
                        return true;
                    }
                    if (this.zzaws != null) {
                        zzsk.checkArgument(this.zzaws == var1_1);
                    } else {
                        this.zzaws = var1_1;
                        if (zzsy.SDK_INT < 21) {
                            var4_3 = var1_1.remaining();
                            if (this.zzawt == null || this.zzawt.length < var4_3) {
                                this.zzawt = new byte[var4_3];
                            }
                            var5_4 = var1_1.position();
                            var1_1.get(this.zzawt, 0, var4_3);
                            var1_1.position(var5_4);
                            this.zzawu = 0;
                        }
                    }
                    var4_3 = var1_1.remaining();
                    var5_4 = 0;
                    if (zzsy.SDK_INT >= 21) break block18;
                    var6_5 = (int)(this.zzawn - this.zzavz.zzev() * (long)this.zzawm);
                    var7_6 = this.zzagl - var6_5;
                    if (var7_6 > 0 && (var5_4 = this.zzagg.write(this.zzawt, this.zzawu, var7_6 = Math.min(var4_3, var7_6))) > 0) {
                        this.zzawu += var5_4;
                        var1_1.position(var1_1.position() + var5_4);
                    }
                    break block19;
                }
                if (!this.zzawy) break block20;
                zzsk.checkState(var2_2 != -9223372036854775807L);
                var11_7 = var2_2;
                var10_8 = var1_1;
                var9_9 = this.zzagg;
                var8_11 = this;
                if (var8_11.zzawh == null) {
                    var8_11.zzawh = ByteBuffer.allocate(16);
                    var8_11.zzawh.order(ByteOrder.BIG_ENDIAN);
                    var8_11.zzawh.putInt(0x55550001);
                }
                if (var8_11.zzawi == 0) {
                    var8_11.zzawh.putInt(4, var4_3);
                    var8_11.zzawh.putLong(8, var11_7 * 1000L);
                    var8_11.zzawh.position(0);
                    var8_11.zzawi = var4_3;
                }
                if ((var13_12 = var8_11.zzawh.remaining()) <= 0) ** GOTO lbl-1000
                var14_13 = var9_9.write(var8_11.zzawh, var13_12, 1);
                if (var14_13 < 0) {
                    var8_11.zzawi = 0;
                    v0 = var14_13;
                } else if (var14_13 < var13_12) {
                    v0 = 0;
                } else if ((var14_13 = var9_9.write(var15_14 = var10_8, var4_3, 1)) < 0) {
                    var8_11.zzawi = 0;
                    v0 = var14_13;
                } else {
                    var8_11.zzawi -= var14_13;
                    v0 = var14_13;
                }
                var5_4 = v0;
                break block19;
            }
            var9_10 = var1_1;
            var5_4 = this.zzagg.write(var9_10, var4_3, 1);
        }
        this.zzaxa = SystemClock.elapsedRealtime();
        if (var5_4 < 0) {
            throw new zzmp(var5_4);
        }
        if (!this.zzawc) {
            this.zzawn += (long)var5_4;
        }
        if (var5_4 == var4_3) {
            if (this.zzawc) {
                this.zzawo += (long)this.zzawp;
            }
            this.zzaws = null;
            return true;
        }
        return false;
    }

    public final void zzho() throws zzmp {
        if (this.zzaww || !this.isInitialized()) {
            return;
        }
        if (this.zzhp()) {
            this.zzavz.zzeh(this.zzht());
            this.zzawi = 0;
            this.zzaww = true;
        }
    }

    private final boolean zzhp() throws zzmp {
        boolean bl = false;
        if (this.zzawv == -1) {
            this.zzawv = this.zzawc ? this.zzawq.length : 0;
            bl = true;
        }
        while (this.zzawv < this.zzawq.length) {
            zzlx zzlx2 = this.zzawq[this.zzawv];
            if (bl) {
                zzlx2.zzhl();
            }
            this.zzeg(-9223372036854775807L);
            if (!zzlx2.zzdx()) {
                return false;
            }
            bl = true;
            ++this.zzawv;
        }
        if (this.zzaws != null) {
            this.zzb(this.zzaws, -9223372036854775807L);
            if (this.zzaws != null) {
                return false;
            }
        }
        this.zzawv = -1;
        return true;
    }

    public final boolean zzdx() {
        return !this.isInitialized() || this.zzaww && !this.zzer();
    }

    public final boolean zzer() {
        zzmh zzmh2;
        return this.isInitialized() && (this.zzht() > this.zzavz.zzev() || (zzmh2 = this).zzhu() && zzmh2.zzagg.getPlayState() == 2 && zzmh2.zzagg.getPlaybackHeadPosition() == 0);
    }

    public final zzln zzb(zzln zzln2) {
        zzln zzln3;
        if (this.zzawc) {
            this.zzasc = zzln.zzaug;
            return this.zzasc;
        }
        zzln2 = new zzln(this.zzavw.zzb(zzln2.zzauh), this.zzavw.zzc(zzln2.zzaui));
        zzln zzln4 = this.zzawe != null ? this.zzawe : (zzln3 = !this.zzawa.isEmpty() ? zzmo.zza(this.zzawa.getLast()) : this.zzasc);
        if (!zzln2.equals(zzln3)) {
            if (this.isInitialized()) {
                this.zzawe = zzln2;
            } else {
                this.zzasc = zzln2;
            }
        }
        return this.zzasc;
    }

    public final zzln zzhq() {
        return this.zzasc;
    }

    public final void setStreamType(int n) {
        if (this.streamType == n) {
            return;
        }
        this.streamType = n;
        if (this.zzawy) {
            return;
        }
        this.reset();
        this.zzada = 0;
    }

    public final void zzai(int n) {
        zzsk.checkState(zzsy.SDK_INT >= 21);
        if (!this.zzawy || this.zzada != n) {
            this.zzawy = true;
            this.zzada = n;
            this.reset();
        }
    }

    public final void zzhr() {
        if (this.zzawy) {
            this.zzawy = false;
            this.zzada = 0;
            this.reset();
        }
    }

    public final void setVolume(float f) {
        if (this.zzcv != f) {
            this.zzcv = f;
            this.zzhs();
        }
    }

    private final void zzhs() {
        if (this.isInitialized()) {
            if (zzsy.SDK_INT >= 21) {
                float f = this.zzcv;
                this.zzagg.setVolume(f);
                return;
            }
            float f = this.zzcv;
            this.zzagg.setStereoVolume(f, f);
        }
    }

    public final void pause() {
        this.zzawx = false;
        if (this.isInitialized()) {
            this.zzet();
            this.zzavz.pause();
        }
    }

    public final void reset() {
        if (this.isInitialized()) {
            zzlx zzlx2;
            this.zzawk = 0L;
            this.zzawl = 0L;
            this.zzawn = 0L;
            this.zzawo = 0L;
            this.zzawp = 0;
            if (this.zzawe != null) {
                this.zzasc = this.zzawe;
                this.zzawe = null;
            } else if (!this.zzawa.isEmpty()) {
                this.zzasc = zzmo.zza(this.zzawa.getLast());
            }
            this.zzawa.clear();
            this.zzawf = 0L;
            this.zzawg = 0L;
            this.zzawr = null;
            this.zzaws = null;
            for (int i = 0; i < this.zzawq.length; ++i) {
                zzlx2 = this.zzawq[i];
                zzlx2.flush();
                this.zzadt[i] = zzlx2.zzhm();
            }
            this.zzaww = false;
            this.zzawv = -1;
            this.zzawh = null;
            this.zzawi = 0;
            this.zzagu = 0;
            this.zzagx = 0L;
            this.zzet();
            if (this.zzagg.getPlayState() == 3) {
                this.zzagg.pause();
            }
            zzlx2 = this.zzagg;
            this.zzagg = null;
            this.zzavz.zza(null, false);
            this.zzagd.close();
            new zzmi(this, (AudioTrack)zzlx2).start();
        }
    }

    public final void release() {
        this.reset();
        zzlx[] zzlxArray = this.zzavx;
        int n = this.zzavx.length;
        for (int i = 0; i < n; ++i) {
            zzlxArray[i].reset();
        }
        this.zzada = 0;
        this.zzawx = false;
    }

    private final boolean isInitialized() {
        return this.zzagg != null;
    }

    private final long zzdo(long l) {
        return l * 1000000L / (long)this.zzafv;
    }

    private final long zzdp(long l) {
        return l * (long)this.zzafv / 1000000L;
    }

    private final long zzht() {
        if (this.zzawc) {
            return this.zzawo;
        }
        return this.zzawn / (long)this.zzawm;
    }

    private final void zzet() {
        this.zzago = 0L;
        this.zzagn = 0;
        this.zzagm = 0;
        this.zzagp = 0L;
        this.zzagq = false;
        this.zzagr = 0L;
    }

    private final boolean zzhu() {
        return zzsy.SDK_INT < 23 && (this.zzawb == 5 || this.zzawb == 6);
    }

    private static int zzba(String string2) {
        switch (string2) {
            case "audio/ac3": {
                return 5;
            }
            case "audio/eac3": {
                return 6;
            }
            case "audio/vnd.dts": {
                return 7;
            }
            case "audio/vnd.dts.hd": {
                return 8;
            }
        }
        return 0;
    }

    static /* synthetic */ ConditionVariable zza(zzmh zzmh2) {
        return zzmh2.zzagd;
    }
}

