/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdbx;
import com.google.android.gms.internal.ads.zzdkw;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzdlk
implements zzdbx {
    private Mac zzhbh;
    private final int zzhbi;
    private final String zzhbj;
    private final Key zzhbk;

    public zzdlk(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzhbj = string2;
        this.zzhbi = n;
        this.zzhbk = key;
        this.zzhbh = zzdkw.zzhaq.zzgt(string2);
        this.zzhbh.init(key);
    }

    @Override
    public final byte[] zzk(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzhbh.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzdkw.zzhaq.zzgt(this.zzhbj);
            mac.init(this.zzhbk);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzhbi];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzhbi);
        return byArray2;
    }
}

