/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdbj;
import com.google.android.gms.internal.ads.zzdbr;
import com.google.android.gms.internal.ads.zzdbt;
import com.google.android.gms.internal.ads.zzdbz;
import com.google.android.gms.internal.ads.zzdca;
import com.google.android.gms.internal.ads.zzdcb;
import com.google.android.gms.internal.ads.zzdcg;
import com.google.android.gms.internal.ads.zzdgq;
import com.google.android.gms.internal.ads.zzdgt;
import com.google.android.gms.internal.ads.zzdgv;
import com.google.android.gms.internal.ads.zzdgz;
import com.google.android.gms.internal.ads.zzdmq;
import com.google.android.gms.internal.ads.zzdpj;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdce {
    private static final Logger logger = Logger.getLogger(zzdce.class.getName());
    private static final ConcurrentMap<String, zzdbr> zzgpp = new ConcurrentHashMap<String, zzdbr>();
    private static final ConcurrentMap<String, Boolean> zzgpq = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzdbj> zzgpr = new ConcurrentHashMap<String, zzdbj>();
    private static final ConcurrentMap<Class<?>, zzdcb<?>> zzgps = new ConcurrentHashMap();

    public static synchronized void zza(String string2, zzdbj<?> zzdbj2) throws GeneralSecurityException {
        if (zzgpr.containsKey(string2.toLowerCase())) {
            zzdbj zzdbj3 = (zzdbj)zzgpr.get(string2.toLowerCase());
            if (!zzdbj2.getClass().equals(zzdbj3.getClass())) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "addCatalogue", string3.length() != 0 ? "Attempted overwrite of a catalogueName catalogue for name ".concat(string3) : new String("Attempted overwrite of a catalogueName catalogue for name "));
                throw new GeneralSecurityException(new StringBuilder(47 + String.valueOf(string2).length()).append("catalogue for name ").append(string2).append(" has been already registered").toString());
            }
        }
        zzgpr.put(string2.toLowerCase(), zzdbj2);
    }

    public static zzdbj<?> zzgi(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzdbj zzdbj2 = (zzdbj)zzgpr.get(string2.toLowerCase());
        if (zzdbj2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.register().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.register().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.register().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzdbj2;
    }

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static synchronized <P> void zza(zzdbr<P> zzdbr2) throws GeneralSecurityException {
        zzdce.zza(zzdbr2, true);
    }

    public static synchronized <P> void zza(zzdbr<P> zzdbr2, boolean bl) throws GeneralSecurityException {
        if (zzdbr2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String string2 = zzdbr2.getKeyType();
        if (zzgpp.containsKey(string2)) {
            zzdbr<P> zzdbr3 = zzdce.zza(string2, null);
            boolean bl2 = (Boolean)zzgpq.get(string2);
            if (!zzdbr2.getClass().equals(zzdbr3.getClass()) || !bl2 && bl) {
                String string3 = String.valueOf(string2);
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerKeyManager", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
                throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zzdbr3.getClass().getName(), zzdbr2.getClass().getName()));
            }
        }
        zzgpp.put(string2, zzdbr2);
        zzgpq.put(string2, bl);
    }

    public static synchronized <P> void zza(zzdcb<P> zzdcb2) throws GeneralSecurityException {
        if (zzdcb2 == null) {
            throw new IllegalArgumentException("wrapper must be non-null");
        }
        Class<P> clazz = zzdcb2.zzanr();
        if (zzgps.containsKey(clazz)) {
            zzdcb zzdcb3 = (zzdcb)zzgps.get(clazz);
            if (!zzdcb2.getClass().equals(zzdcb3.getClass())) {
                String string2 = String.valueOf(clazz.toString());
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", string2.length() != 0 ? "Attempted overwrite of a registered SetWrapper for type ".concat(string2) : new String("Attempted overwrite of a registered SetWrapper for type "));
                throw new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", clazz.getName(), zzdcb3.getClass().getName(), zzdcb2.getClass().getName()));
            }
        }
        zzgps.put(clazz, zzdcb2);
    }

    private static <P> zzdbr<P> zza(String string2, Class<P> clazz) throws GeneralSecurityException {
        zzdbr zzdbr2 = (zzdbr)zzgpp.get(string2);
        if (zzdbr2 == null) {
            throw new GeneralSecurityException(new StringBuilder(78 + String.valueOf(string2).length()).append("No key manager found for key type: ").append(string2).append(".  Check the configuration of the registry.").toString());
        }
        if (clazz != null && !zzdbr2.zzanr().equals(clazz)) {
            String string3 = zzdbr2.zzanr().getName();
            String string4 = clazz.getName();
            throw new GeneralSecurityException(new StringBuilder(80 + String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string4).length()).append("Primitive type ").append(string3).append(" of keymanager for type ").append(string2).append(" does not match requested primitive type ").append(string4).toString());
        }
        return zzdbr2;
    }

    public static synchronized zzdgq zza(zzdgv zzdgv2) throws GeneralSecurityException {
        zzdbr zzdbr2 = zzdce.zza(zzdgv2.zzart(), null);
        if (((Boolean)zzgpq.get(zzdgv2.zzart())).booleanValue()) {
            return zzdbr2.zzr(zzdgv2.zzaru());
        }
        String string2 = String.valueOf(zzdgv2.zzart());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdpj zzb(zzdgv zzdgv2) throws GeneralSecurityException {
        zzdbr zzdbr2 = zzdce.zza(zzdgv2.zzart(), null);
        if (((Boolean)zzgpq.get(zzdgv2.zzart())).booleanValue()) {
            return zzdbr2.zzq(zzdgv2.zzaru());
        }
        String string2 = String.valueOf(zzdgv2.zzart());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzdpj zza(String string2, zzdpj zzdpj2) throws GeneralSecurityException {
        zzdbr zzdbr2 = zzdce.zza(string2, null);
        if (((Boolean)zzgpq.get(string2)).booleanValue()) {
            return zzdbr2.zzb(zzdpj2);
        }
        String string3 = String.valueOf(string2);
        throw new GeneralSecurityException(string3.length() != 0 ? "newKey-operation not permitted for key type ".concat(string3) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zza(String string2, zzdpj zzdpj2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdce.checkNotNull(clazz);
        zzdpj zzdpj3 = zzdpj2;
        return zzdce.zza(string2, clazz2).zza(zzdpj3);
    }

    private static <P> P zza(String string2, zzdmq zzdmq2, Class<P> clazz) throws GeneralSecurityException {
        return zzdce.zza(string2, clazz).zzp(zzdmq2);
    }

    public static <P> P zza(String string2, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = clazz;
        zzdmq zzdmq2 = zzdmq.zzz((byte[])byArray);
        return zzdce.zza(string2, zzdmq2, zzdce.checkNotNull(clazz2));
    }

    public static <P> zzdbz<P> zza(zzdbt zzdbt2, zzdbr<P> zzdbr2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdce.checkNotNull(clazz);
        zzdbt zzdbt3 = zzdbt2;
        zzdcg.zzd(zzdbt3.zzant());
        zzdbz<P> zzdbz2 = zzdbz.zza(clazz2);
        for (zzdgz.zzb zzb2 : zzdbt3.zzant().zzasi()) {
            if (zzb2.zzaso() != zzdgt.zzgul) continue;
            P p = zzdce.zza(zzb2.zzasn().zzart(), zzb2.zzasn().zzaru(), clazz2);
            zzdca<P> zzdca2 = zzdbz2.zza(p, zzb2);
            if (zzb2.zzasp() != zzdbt3.zzant().zzash()) continue;
            zzdbz2.zza(zzdca2);
        }
        return zzdbz2;
    }

    public static <P> P zza(zzdbz<P> zzdbz2) throws GeneralSecurityException {
        zzdcb zzdcb2 = (zzdcb)zzgps.get(zzdbz2.zzanr());
        if (zzdcb2 == null) {
            String string2 = String.valueOf(zzdbz2.zzanr().getName());
            throw new GeneralSecurityException(string2.length() != 0 ? "No wrapper found for ".concat(string2) : new String("No wrapper found for "));
        }
        return zzdcb2.zza(zzdbz2);
    }
}

