/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzadu;
import com.google.android.gms.internal.ads.zzajc;
import com.google.android.gms.internal.ads.zzajd;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbca;
import com.google.android.gms.internal.ads.zzbpb;
import com.google.android.gms.internal.ads.zzbym;
import com.google.android.gms.internal.ads.zzbys;
import com.google.android.gms.internal.ads.zzcbw;
import java.util.Collections;

public final class zzcbv
extends zzajc
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzadu {
    private View zzfom;
    private zzaap zzfoh;
    private zzbym zzfpj;
    private boolean zzela;
    private boolean zzfsb;

    public zzcbv(zzbym zzbym2, zzbys zzbys2) {
        this.zzfom = zzbys2.zzahy();
        this.zzfoh = zzbys2.getVideoController();
        this.zzfpj = zzbym2;
        this.zzela = false;
        this.zzfsb = false;
        if (zzbys2.zzahz() != null) {
            zzbys2.zzahz().zza(this);
        }
    }

    public final void zza(IObjectWrapper iObjectWrapper, zzajd zzajd2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzela) {
            zzaxa.zzen((String)"Instream ad is destroyed already.");
            zzcbv.zza(zzajd2, 2);
            return;
        }
        if (this.zzfom == null || this.zzfoh == null) {
            String string2 = String.valueOf(this.zzfom == null ? "can not get video view." : "can not get video controller.");
            zzaxa.zzen((String)(string2.length() != 0 ? "Instream internal error: ".concat(string2) : new String("Instream internal error: ")));
            zzcbv.zza(zzajd2, 0);
            return;
        }
        if (this.zzfsb) {
            zzaxa.zzen((String)"Instream ad should not be used again.");
            zzcbv.zza(zzajd2, 1);
            return;
        }
        this.zzfsb = true;
        this.zzajf();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(this.zzfom, new ViewGroup.LayoutParams(-1, -1));
        zzk.zzmd();
        zzbca.zza(this.zzfom, this);
        zzk.zzmd();
        zzbca.zza(this.zzfom, this);
        this.zzajg();
        zzajd zzajd3 = zzajd2;
        try {
            zzajd3.zzrt();
            return;
        }
        catch (RemoteException remoteException) {
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final zzaap getVideoController() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzela) {
            zzaxa.zzen((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzfoh;
    }

    public final void destroy() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzajf();
        if (this.zzfpj != null) {
            ((zzbpb)this.zzfpj).destroy();
        }
        this.zzfpj = null;
        this.zzfom = null;
        this.zzfoh = null;
        this.zzela = true;
    }

    private final void zzajf() {
        if (this.zzfom == null) {
            return;
        }
        ViewParent viewParent = this.zzfom.getParent();
        if (viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzfom);
        }
    }

    public final void onGlobalLayout() {
        this.zzajg();
    }

    public final void onScrollChanged() {
        this.zzajg();
    }

    @Override
    public final void zzre() {
        zzaxj.zzdvx.post((Runnable)new zzcbw(this));
    }

    private final void zzajg() {
        if (this.zzfpj != null && this.zzfom != null) {
            this.zzfpj.zzb(this.zzfom, Collections.emptyMap(), Collections.emptyMap(), zzbym.zzx(this.zzfom));
        }
    }

    private static void zza(zzajd zzajd2, int n) {
        try {
            zzajd2.zzcq(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzajh() {
        try {
            this.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

