/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzj;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzada;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzadu;
import com.google.android.gms.internal.ads.zzadw;
import com.google.android.gms.internal.ads.zzahn;
import com.google.android.gms.internal.ads.zzajr;
import com.google.android.gms.internal.ads.zzajs;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzayb;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbha;
import com.google.android.gms.internal.ads.zzbhr;
import com.google.android.gms.internal.ads.zzbhu;
import com.google.android.gms.internal.ads.zzbie;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzbio;
import com.google.android.gms.internal.ads.zzbip;
import com.google.android.gms.internal.ads.zzbix;
import com.google.android.gms.internal.ads.zzbiy;
import com.google.android.gms.internal.ads.zzbiz;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdoa;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzwh;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzwr;
import com.google.android.gms.internal.ads.zzxl;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@zzare
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbiw
extends zzbjc
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzajr,
zzbha {
    private final zzbin zzekp;
    private final zzbip zzemp;
    @Nullable
    private final zzdh zzekq;
    private final zzbaj zzbtd;
    private final zzj zzekr;
    private final zza zzeks;
    private final DisplayMetrics zzwb;
    private final zzwh zzejf;
    @GuardedBy(value="this")
    private zzd zzekx;
    @GuardedBy(value="this")
    private zzbio zzekz;
    @GuardedBy(value="this")
    private String zzaap;
    @GuardedBy(value="this")
    private boolean zzdkq;
    @GuardedBy(value="this")
    private boolean zzelb;
    @GuardedBy(value="this")
    private boolean zzelc;
    @GuardedBy(value="this")
    private int zzeld;
    @GuardedBy(value="this")
    private boolean zzele = true;
    @GuardedBy(value="this")
    private boolean zzelf = false;
    @GuardedBy(value="this")
    private String zzdlz = "";
    @GuardedBy(value="this")
    private zzbhr zzelg;
    @GuardedBy(value="this")
    private boolean zzelh;
    @GuardedBy(value="this")
    private boolean zzeli;
    @GuardedBy(value="this")
    private zzadw zzelj;
    @GuardedBy(value="this")
    private zzadu zzelk;
    @GuardedBy(value="this")
    private int zzell;
    @GuardedBy(value="this")
    private int zzelm;
    private zzadf zzeln;
    private zzadf zzeeo;
    private zzadf zzelo;
    private zzadg zzelp;
    private WeakReference<View.OnClickListener> zzelq;
    @GuardedBy(value="this")
    private zzd zzelr;
    private zzazt zzelt;
    private final AtomicReference<IObjectWrapper> zzemq = new AtomicReference();
    private int zzdlw = -1;
    private int zzdlv = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbfu> zzelu;
    private final WindowManager zzbtg;

    @VisibleForTesting
    protected zzbiw(zzbin zzbin2, zzbip zzbip2, zzbio zzbio2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbaj zzbaj2, zzadh zzadh2, zzj zzj2, zza zza2, zzwh zzwh2) {
        super((Context)zzbin2, zzbip2);
        this.zzekp = zzbin2;
        this.zzemp = zzbip2;
        this.zzekz = zzbio2;
        this.zzaap = string2;
        this.zzelb = bl;
        this.zzeld = -1;
        this.zzekq = zzdh2;
        this.zzbtd = zzbaj2;
        this.zzekr = zzj2;
        this.zzeks = zza2;
        this.zzbtg = (WindowManager)this.getContext().getSystemService("window");
        zzk.zzlg();
        this.zzwb = zzaxj.zza(this.zzbtg);
        this.zzejf = zzwh2;
        this.zzelt = new zzazt(this.zzekp.zzyd(), (View)this, this, null);
        zzk.zzlg().zza((Context)zzbin2, zzbaj2.zzbsy, this.getSettings());
        this.setDownloadListener(this);
        this.zzabn();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            ((zzbiz)this).addJavascriptInterface(zzbhu.zzc(this), "googleAdsJsInterface");
        }
        zzadh zzadh3 = zzadh2;
        zzbiw zzbiw2 = this;
        zzbiw2.zzabr();
        zzbiw2.zzelp = new zzadg(new zzadh(true, "make_wv", zzbiw2.zzaap));
        zzbiw2.zzelp.zzqw().zzc(zzadh3);
        zzbiw2.zzeeo = zzada.zzb(zzbiw2.zzelp.zzqw());
        zzbiw2.zzelp.zza("native:view_create", zzbiw2.zzeeo);
        zzbiw2.zzelo = null;
        zzbiw2.zzeln = null;
        zzk.zzli().zzay((Context)zzbin2);
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zza zzye() {
        return this.zzeks;
    }

    private final boolean zzabk() {
        int n;
        int n2;
        if (!this.zzemp.zzaay() && !this.zzemp.zzaaz()) {
            return false;
        }
        zzyr.zzpa();
        int n3 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.widthPixels);
        zzyr.zzpa();
        int n4 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.heightPixels);
        Activity activity = this.zzekp.zzyd();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzk.zzlg();
            int[] nArray = zzaxj.zzd(activity);
            zzyr.zzpa();
            n2 = zzazu.zzb((DisplayMetrics)this.zzwb, (int)nArray[0]);
            zzyr.zzpa();
            n = zzazu.zzb((DisplayMetrics)this.zzwb, (int)nArray[1]);
        }
        if (this.zzdlv == n3 && this.zzdlw == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdlv != n3 || this.zzdlw != n4;
        this.zzdlv = n3;
        this.zzdlw = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzaqc(this).zza(n3, n4, n2, n, this.zzwb.density, this.zzbtg.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        zzaci zzaci2 = zzact.zzcol;
        String string5 = (Boolean)zzyr.zzpe().zzd(zzaci2) != false ? zzbie.zzf(string3, zzbie.zzabt()) : string3;
        super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzco(String string2) {
        if (!this.isDestroyed()) {
            super.zzco(string2);
            return;
        }
        zzaxa.zzep((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzaab() {
        this.zzabm();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtd.zzbsy);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzajs.zza((zzajr)this, "onhide", hashMap2);
    }

    @Override
    public final void zzdi(int n) {
        if (n == 0) {
            zzbiw zzbiw2 = this;
            zzada.zza(zzbiw2.zzelp.zzqw(), zzbiw2.zzeeo, "aebb2");
        }
        this.zzabm();
        if (this.zzelp.zzqw() != null) {
            this.zzelp.zzqw().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzbtd.zzbsy);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzajs.zza((zzajr)this, "onhide", hashMap2);
    }

    private final void zzabm() {
        zzada.zza(this.zzelp.zzqw(), this.zzeeo, "aeh2");
    }

    @Override
    public final void zztl() {
        if (this.zzeln == null) {
            zzada.zza(this.zzelp.zzqw(), this.zzeeo, "aes2");
            this.zzeln = zzada.zzb(this.zzelp.zzqw());
            this.zzelp.zza("native:view_show", this.zzeln);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtd.zzbsy);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzajs.zza((zzajr)this, "onshow", hashMap2);
    }

    @Override
    public final void zzaac() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzk.zzll().zzpr()));
        hashMap.put("app_volume", String.valueOf(zzk.zzll().zzpq()));
        hashMap.put("device_volume", String.valueOf(zzayb.zzba(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzajs.zza((zzajr)this, "volume", hashMap2);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onCacheAccessComplete";
        zzajs.zza((zzajr)this, "onCacheAccessComplete", hashMap2);
    }

    @Override
    public final synchronized zzd zzaae() {
        return this.zzekx;
    }

    @Override
    public final IObjectWrapper zzaam() {
        return this.zzemq.get();
    }

    @Override
    public final synchronized zzd zzaaf() {
        return this.zzelr;
    }

    @Override
    public final synchronized zzbio zzaag() {
        return this.zzekz;
    }

    @Override
    public final synchronized String zzaah() {
        return this.zzaap;
    }

    @Override
    public final WebViewClient zzaaj() {
        return this.zzemp;
    }

    @Override
    public final synchronized boolean zzaak() {
        return this.zzdkq;
    }

    @Override
    public final zzdh zzaal() {
        return this.zzekq;
    }

    @Override
    public final zzbaj zzyh() {
        return this.zzbtd;
    }

    @Override
    public final synchronized boolean zzaan() {
        return this.zzelb;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzk.zzlg();
            zzaxj.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzaxa.zzdp((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzemp.zzaaz()) {
            zzbiw zzbiw2 = this;
            synchronized (zzbiw2) {
                if (this.zzelj != null) {
                    this.zzelj.zzc(motionEvent);
                }
            }
        } else if (this.zzekq != null) {
            this.zzekq.zza(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzelb || this.zzekz.zzaby()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekz.zzaca()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekz.zzabz()) {
            zzaci zzaci2 = zzact.zzcsl;
            if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbhr zzbhr2 = this.zzyb();
            if (zzbhr2 != null) {
                f = zzbhr2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzekz.isFluid()) {
            int n11;
            Object object = zzact.zzcso;
            if (((Boolean)zzyr.zzpe().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbiy((zzbiw)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzbiz)this).zzco(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzelm) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzelm * this.zzwb.density);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzekz.zzabx()) {
            this.setMeasuredDimension(this.zzwb.widthPixels, this.zzwb.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzekz.widthPixels > n17 || this.zzekz.heightPixels > n18 ? 1 : 0;
        zzaci zzaci3 = zzact.zzcvh;
        if (((Boolean)zzyr.zzpe().zzd(zzaci3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzekz.widthPixels / this.zzwb.density > (float)n17 / this.zzwb.density) && !((float)this.zzekz.heightPixels / this.zzwb.density > (float)n18 / this.zzwb.density) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzekz.widthPixels / this.zzwb.density);
            int n21 = (int)((float)this.zzekz.heightPixels / this.zzwb.density);
            int n22 = (int)((float)n14 / this.zzwb.density);
            int n23 = (int)((float)n16 / this.zzwb.density);
            zzaxa.zzep((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzekz.widthPixels, this.zzekz.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzabk();
        zzd zzd2 = this.zzaae();
        if (zzd2 != null && bl) {
            zzd2.zztk();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzekx = zzd2;
    }

    @Override
    public final void zzam(IObjectWrapper iObjectWrapper) {
        this.zzemq.set(iObjectWrapper);
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzelr = zzd2;
    }

    @Override
    public final synchronized void zza(zzbio zzbio2) {
        this.zzekz = zzbio2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzelb;
        this.zzelb = bl;
        this.zzabn();
        if (bl2) {
            new zzaqc(this).zzdj(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzaar() {
        this.zzelt.zzwt();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzelt.onAttachedToWindow();
        }
        boolean bl = this.zzelh;
        if (this.zzemp != null && this.zzemp.zzaaz()) {
            bl = true;
            if (!this.zzeli) {
                this.zzemp.zzaba();
                this.zzemp.zzabb();
                this.zzeli = true;
            }
            this.zzabk();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbiw zzbiw2 = this;
        synchronized (zzbiw2) {
            if (!this.isDestroyed()) {
                this.zzelt.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzeli && this.zzemp != null && this.zzemp.zzaaz() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzemp.zzaba();
                this.zzemp.zzabb();
                this.zzeli = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbn(Context context) {
        this.zzekp.setBaseContext(context);
        this.zzelt.zzh(this.zzekp.zzyd());
    }

    @Override
    public final synchronized void zzaf(boolean bl) {
        if (this.zzekx != null) {
            this.zzekx.zza(this.zzemp.zzaay(), bl);
            return;
        }
        this.zzdkq = bl;
    }

    @Override
    public final void zzaao() {
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzeld = n;
        if (this.zzekx != null) {
            this.zzekx.setRequestedOrientation(this.zzeld);
        }
    }

    @Override
    public final Activity zzyd() {
        return this.zzekp.zzyd();
    }

    @Override
    public final Context zzaad() {
        return this.zzekp.zzaad();
    }

    private final synchronized void zzabn() {
        if (this.zzelb || this.zzekz.zzabx()) {
            zzaxa.zzdp((String)"Enabling hardware acceleration on an overlay.");
            this.zzabp();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzaxa.zzdp((String)"Disabling hardware acceleration on an AdView.");
            this.zzabo();
            return;
        }
        zzaxa.zzdp((String)"Enabling hardware acceleration on an AdView.");
        this.zzabp();
    }

    private final synchronized void zzabo() {
        if (!this.zzelc) {
            zzk.zzli();
            this.setLayerType(1, null);
        }
        this.zzelc = true;
    }

    private final synchronized void zzabp() {
        if (this.zzelc) {
            zzk.zzli();
            this.setLayerType(0, null);
        }
        this.zzelc = false;
    }

    @Override
    protected final synchronized void zzaw(boolean bl) {
        if (!bl) {
            this.zzabr();
            this.zzelt.zzwu();
            if (this.zzekx != null) {
                this.zzekx.close();
                this.zzekx.onDestroy();
                this.zzekx = null;
            }
        }
        this.zzemq.set(null);
        this.zzemp.destroy();
        zzk.zzmc();
        zzbft.zzc(this);
        this.zzabq();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public final void zzaas() {
        if (this.zzelo == null) {
            this.zzelo = zzada.zzb(this.zzelp.zzqw());
            this.zzelp.zza("native:view_load", this.zzelo);
        }
    }

    @Override
    public final void onPause() {
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzaav() {
        zzaxa.zzds("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzemp.zzat(bl);
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzele = bl;
    }

    @Override
    public final synchronized boolean zzaap() {
        return this.zzele;
    }

    @Override
    public final synchronized void zzlc() {
        this.zzelf = true;
        if (this.zzekr != null) {
            this.zzekr.zzlc();
        }
    }

    @Override
    public final synchronized void zzld() {
        this.zzelf = false;
        if (this.zzekr != null) {
            this.zzekr.zzld();
        }
    }

    private final synchronized void zzabq() {
        if (this.zzelu != null) {
            Iterator<zzbfu> iterator = this.zzelu.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzelu = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbfu zzbfu2) {
        if (this.zzelu == null) {
            this.zzelu = new HashMap<String, zzbfu>();
        }
        this.zzelu.put(string2, zzbfu2);
    }

    @Override
    public final synchronized zzbfu zzet(String string2) {
        if (this.zzelu == null) {
            return null;
        }
        return this.zzelu.get(string2);
    }

    @Override
    public final synchronized String zzyf() {
        return this.zzdlz;
    }

    @Override
    public final zzbcx zzya() {
        return null;
    }

    @Override
    public final zzadf zzyc() {
        return this.zzeeo;
    }

    @Override
    public final zzadg zzyg() {
        return this.zzelp;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzelq = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzadw zzadw2) {
        this.zzelj = zzadw2;
    }

    @Override
    public final synchronized zzadw zzaat() {
        return this.zzelj;
    }

    @Override
    public final synchronized void zzyk() {
        if (this.zzelk != null) {
            this.zzelk.zzre();
        }
    }

    @Override
    public final synchronized void zza(zzadu zzadu2) {
        this.zzelk = zzadu2;
    }

    @Override
    public final synchronized zzbhr zzyb() {
        return this.zzelg;
    }

    @Override
    public final synchronized void zza(zzbhr zzbhr2) {
        if (this.zzelg != null) {
            zzaxa.zzen((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzelg = zzbhr2;
    }

    @Override
    public final synchronized boolean zzaaq() {
        return this.zzell > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzell += bl ? 1 : -1;
        if (this.zzell <= 0 && this.zzekx != null) {
            this.zzekx.zztn();
        }
    }

    private final void zzabr() {
        if (this.zzelp == null) {
            return;
        }
        zzadh zzadh2 = this.zzelp.zzqw();
        if (zzadh2 != null && zzk.zzlk().zzuw() != null) {
            zzk.zzlk().zzuw().zza(zzadh2);
        }
    }

    @Override
    public final void zzaau() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzemp.zzao(bl);
    }

    @Override
    public final void zztm() {
        zzd zzd2 = this.zzaae();
        if (zzd2 != null) {
            zzd2.zztm();
        }
    }

    @Override
    public final int zzyi() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzyj() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzemp.zza(zzc2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzemp.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzemp.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzemp.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzub zzub2) {
        zzbiw zzbiw2 = this;
        synchronized (zzbiw2) {
            this.zzelh = zzub2.zzbtl;
        }
        this.zzav(zzub2.zzbtl);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzajs.zza((zzajr)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzahn<? super zzbha> zzahn2) {
        if (this.zzemp != null) {
            this.zzemp.zza(string2, zzahn2);
        }
    }

    @Override
    public final void zzb(String string2, zzahn<? super zzbha> zzahn2) {
        if (this.zzemp != null) {
            this.zzemp.zzb(string2, zzahn2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzahn<? super zzbha>> predicate) {
        if (this.zzemp != null) {
            this.zzemp.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzejf.zza(new zzbix(bl, n));
        this.zzejf.zza(zzwj.zza.zzb.zzbyz);
        return true;
    }

    @Override
    public final boolean zzaaw() {
        return false;
    }

    @Override
    public final /* synthetic */ zzbij zzaai() {
        return this.zzemp;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zzxl zzxl2) {
        zzwr.zzv.zza zza2 = zzwr.zzv.zzop();
        if (zza2.zzoo() != bl) {
            zza2.zzr(bl);
        }
        zza2.zzcm(n);
        zzxl2.zzcfo = (zzwr.zzv)((zzdoa)zza2.zzaya());
    }

    static /* synthetic */ int zza(zzbiw zzbiw2) {
        return zzbiw2.zzelm;
    }

    static /* synthetic */ int zza(zzbiw zzbiw2, int n) {
        zzbiw2.zzelm = n;
        return zzbiw2.zzelm;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzajs.zza((zzajr)this, string2, jSONObject);
    }

    @Override
    public final void zzi(String string2, String string3) {
        zzajs.zza((zzajr)this, string2, string3);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzajs.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzajs.zza((zzajr)this, string2, map);
    }
}

