/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbfb;
import com.google.android.gms.internal.ads.zzbfj;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbgr;
import com.google.android.gms.internal.ads.zzkv;
import com.google.android.gms.internal.ads.zzyr;
import java.io.IOException;

@zzare
@TargetApi(value=16)
public final class zzbgq
extends zzbfu
implements zzbfj {
    private zzbfb zzeiw;
    private String zzech;
    private boolean zzeij;
    private Exception zzeix;
    private boolean zzeiy;

    public zzbgq(zzbdg zzbdg2, zzbdf zzbdf2) {
        super(zzbdg2);
        zzbdf zzbdf3 = zzbdf2;
        Context context = zzbdg2.getContext();
        this.zzeiw = new zzbfb(context, zzbdf3);
        this.zzeiw.zza(this);
    }

    @Override
    public final void zzd(boolean bl, long l) {
        zzbdg zzbdg2 = (zzbdg)this.zzehv.get();
        if (zzbdg2 != null) {
            zzbbn.zzeag.execute(new zzbgr(zzbdg2, bl, l));
        }
    }

    @Override
    public final void zzde(int n) {
    }

    @Override
    public final void zzo(int n, int n2) {
    }

    @Override
    public final void zza(String string2, Exception exception) {
        this.zzeix = exception;
        zzaxa.zzd((String)"Precache error", (Throwable)exception);
        this.zzfb(string2);
    }

    @Override
    public final void zzcz(int n) {
        this.zzeiw.zzzu().zzdh(n);
    }

    @Override
    public final void zzcy(int n) {
        this.zzeiw.zzzu().zzdg(n);
    }

    @Override
    public final void zzda(int n) {
        this.zzeiw.zzzu().zzda(n);
    }

    @Override
    public final void zzdb(int n) {
        this.zzeiw.zzzu().zzdb(n);
    }

    @Override
    public final void release() {
        if (this.zzeiw != null) {
            this.zzeiw.zza((zzbfj)null);
            this.zzeiw.release();
        }
        super.release();
    }

    @Override
    protected final String zzey(String string2) {
        String string3 = String.valueOf("cache:");
        String string4 = String.valueOf(super.zzey(string2));
        if (string4.length() != 0) {
            return string3.concat(string4);
        }
        return new String(string3);
    }

    @Override
    public final boolean zzex(String string2) {
        return ((zzbfu)this).zze(string2, new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean zze(String string2, String[] stringArray) {
        this.zzech = string2;
        String string3 = ((zzbfu)this).zzey(string2);
        String string4 = "error";
        try {
            Uri[] uriArray = new Uri[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                uriArray[i] = Uri.parse((String)stringArray[i]);
            }
            this.zzeiw.zza(uriArray, this.zzdyd);
            zzbdg zzbdg2 = (zzbdg)this.zzehv.get();
            if (zzbdg2 != null) {
                zzbdg2.zza(string3, this);
            }
            Clock clock = zzk.zzln();
            long l = clock.currentTimeMillis();
            zzaci zzaci2 = zzact.zzclz;
            long l2 = (Long)zzyr.zzpe().zzd(zzaci2);
            zzaci2 = zzact.zzcly;
            long l3 = (Long)zzyr.zzpe().zzd(zzaci2) * 1000L;
            zzaci2 = zzact.zzclx;
            long l4 = ((Integer)zzyr.zzpe().zzd(zzaci2)).intValue();
            long l5 = -1L;
            while (true) {
                zzbgq zzbgq2 = this;
                synchronized (zzbgq2) {
                    if (clock.currentTimeMillis() - l > l3) {
                        string4 = "downloadTimeout";
                        throw new IOException(new StringBuilder(47).append("Timeout reached. Limit: ").append(l3).append(" ms").toString());
                    }
                    if (this.zzeij) {
                        if (this.zzeix != null) {
                            string4 = "badUrl";
                            throw this.zzeix;
                        }
                        string4 = "externalAbort";
                        throw new IOException("Abort requested before buffering finished. ");
                    }
                    if (this.zzeiy) {
                        return true;
                    }
                    zzkv zzkv2 = this.zzeiw.zzzt();
                    if (zzkv2 == null) {
                        string4 = "exoPlayerReleased";
                        throw new IOException("ExoPlayer was released during preloading.");
                    }
                    long l6 = zzkv2.getDuration();
                    if (l6 > 0L) {
                        long l7 = zzkv2.getBufferedPosition();
                        if (l7 != l5) {
                            boolean bl = l7 > 0L;
                            this.zza(string2, string3, l7, l6, bl, zzbfb.zzyp(), zzbfb.zzyq());
                            l5 = l7;
                        }
                        if (l7 >= l6) {
                            this.zzb(string2, string3, l6);
                            return true;
                        }
                        if (this.zzeiw.getBytesTransferred() >= l4 && l7 > 0L) {
                            return true;
                        }
                    }
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        string4 = "interrupted";
                        throw new IOException("Wait interrupted.");
                    }
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            String string5 = exception.getMessage();
            zzaxa.zzep((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Failed to preload url ").append(string2).append(" Exception: ").append(string5).toString());
            ((zzbfu)this).release();
            string5 = zzbgq.zzb(string4, exception2);
            this.zza(string2, string3, string4, string5);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzfb(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfb(String string2) {
        Object object = this;
        synchronized (object) {
            this.zzeij = true;
            this.notify();
            ((zzbfu)this).release();
        }
        if (this.zzech != null) {
            object = ((zzbfu)this).zzey(this.zzech);
            if (this.zzeix != null) {
                this.zza(this.zzech, (String)object, "badUrl", zzbgq.zzb(string2, this.zzeix));
                return;
            }
            this.zza(this.zzech, (String)object, "externalAbort", "Programmatic precache abort.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzbfb zzaaa() {
        Object object = this;
        synchronized (object) {
            this.zzeiy = true;
            this.notify();
        }
        this.zzeiw.zza((zzbfj)null);
        object = this.zzeiw;
        this.zzeiw = null;
        return object;
    }

    private static String zzb(String string2, Exception exception) {
        String string3 = exception.getClass().getCanonicalName();
        String string4 = exception.getMessage();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append("/").append(string3).append(":").append(string4).toString();
    }
}

