/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.internal.ads.zzahn;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazs;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzbcr;
import com.google.android.gms.internal.ads.zzbcx;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbhr;
import com.google.android.gms.internal.ads.zzyr;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
public final class zzbfp
implements zzahn<zzbdg> {
    private boolean zzehr;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzyr.zzpa();
                n2 = zzazu.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzaxa.zzep((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzbcr zzbcr2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        String string6 = map.get("socketReceiveBufferSize");
        try {
            int n;
            if (string2 != null) {
                n = Integer.parseInt(string2);
                zzbcr2.zzcy(n);
            }
            if (string3 != null) {
                n = Integer.parseInt(string3);
                zzbcr2.zzcz(n);
            }
            if (string4 != null) {
                n = Integer.parseInt(string4);
                zzbcr2.zzda(n);
            }
            if (string5 != null) {
                n = Integer.parseInt(string5);
                zzbcr2.zzdb(n);
            }
            if (string6 != null) {
                n = Integer.parseInt(string6);
                zzbcr2.zzdc(n);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzaxa.zzep((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        zzbcr zzbcr2;
        Object object2;
        Object object3;
        Map map2 = map;
        zzbdg zzbdg2 = (zzbdg)object;
        zzbfp zzbfp2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzaxa.zzep((String)"Action missing from video GMSG.");
            return;
        }
        if (zzaxa.isLoggable((int)3)) {
            object3 = new JSONObject(map2);
            object3.remove("google.afma.Notify_dt");
            object2 = object3.toString();
            zzaxa.zzdp((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object2).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object2).toString());
        }
        if ("background".equals(string2)) {
            object3 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object3)) {
                zzaxa.zzep((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object3);
                zzbdg2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzaxa.zzep((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object3 = (String)map2.get("mimeTypes");
            if (object3 == null) {
                zzaxa.zzep((String)"No MIME types specified for decoder properties inspection.");
                zzbcr.zza(zzbdg2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzaxa.zzep((String)"Video decoder properties available on API versions >= 16.");
                zzbcr.zza(zzbdg2, "deficientApiVersion");
                return;
            }
            object2 = new HashMap();
            for (String string3 : ((String)object3).split(",")) {
                object2.put(string3, zzazs.zzeh(string3.trim()));
            }
            zzbcr.zza(zzbdg2, (Map<String, List<Map<String, Object>>>)object2);
            return;
        }
        object3 = zzbdg2.zzya();
        if (object3 == null) {
            zzaxa.zzep((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzbdg2.getContext();
            int n2 = zzbfp.zza(context, map2, "x", 0);
            int n3 = zzbfp.zza(context, map2, "y", 0);
            int n4 = zzbfp.zza(context, map2, "w", -1);
            int n5 = zzbfp.zza(context, map2, "h", -1);
            n4 = Math.min(n4, zzbdg2.zzyj() - n2);
            n5 = Math.min(n5, zzbdg2.zzyi() - n3);
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzbcx)object3).zzxw() == null) {
                zzbdf zzbdf2 = new zzbdf((String)map2.get("flags"));
                ((zzbcx)object3).zza(n2, n3, n4, n5, n, bl3, zzbdf2);
                zzbcr zzbcr3 = ((zzbcx)object3).zzxw();
                if (zzbcr3 != null) {
                    zzbfp.zza(zzbcr3, map2);
                }
                return;
            }
            ((zzbcx)object3).zze(n2, n3, n4, n5);
            return;
        }
        zzbhr zzbhr2 = zzbdg2.zzyb();
        if (zzbhr2 != null) {
            if ("timeupdate".equals(string2)) {
                String string4 = (String)map2.get("currentTime");
                if (string4 == null) {
                    zzaxa.zzep((String)"currentTime parameter missing from timeupdate video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    zzbhr2.zze(f);
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzaxa.zzep((String)(string5.length() != 0 ? "Could not parse currentTime parameter from timeupdate video GMSG: ".concat(string5) : new String("Could not parse currentTime parameter from timeupdate video GMSG: ")));
                    return;
                }
            }
            if ("skip".equals(string2)) {
                zzbhr2.zzabs();
                return;
            }
        }
        if ((zzbcr2 = ((zzbcx)object3).zzxw()) == null) {
            zzbcr.zzb(zzbdg2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzbdg2.getContext();
            int n = zzbfp.zza(context, map2, "x", 0);
            int n6 = zzbfp.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzbcr2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string6 = (String)map2.get("time");
            if (string6 == null) {
                zzaxa.zzep((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string6) * 1000.0f);
                zzbcr2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzaxa.zzep((String)(string7.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string7) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzbcr2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzbcr2.zzfr();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzbfp.zza(zzbcr2, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                zzbcr2.zzxq();
                return;
            }
            zzbcr2.zzxr();
            return;
        }
        if ("pause".equals(string2)) {
            zzbcr2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzbcr2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzbcr2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            String string8 = (String)map2.get("src");
            String[] stringArray = new String[]{string8};
            String string9 = (String)map2.get("demuxed");
            if (string9 != null) {
                try {
                    JSONArray jSONArray = new JSONArray(string9);
                    stringArray = new String[jSONArray.length()];
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        stringArray[i] = jSONArray.getString(i);
                    }
                }
                catch (JSONException jSONException) {
                    String string10 = String.valueOf(string9);
                    zzaxa.zzep((String)(string10.length() != 0 ? "Malformed demuxed URL list for playback: ".concat(string10) : new String("Malformed demuxed URL list for playback: ")));
                    stringArray = new String[]{string8};
                }
            }
            zzbcr2.zzc(string8, stringArray);
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzbdg2.getContext();
            int n = zzbfp.zza(context, map2, "dx", 0);
            int n7 = zzbfp.zza(context, map2, "dy", 0);
            zzbcr2.zza(n, n7);
            if (!zzbfp2.zzehr) {
                zzbdg2.zztm();
                zzbfp2.zzehr = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string11 = (String)map2.get("volume");
            if (string11 == null) {
                zzaxa.zzep((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string11);
                zzbcr2.setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string12 = String.valueOf(string11);
                zzaxa.zzep((String)(string12.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string12) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzbcr2.zzxs();
            return;
        }
        String string13 = String.valueOf(string2);
        zzaxa.zzep((String)(string13.length() != 0 ? "Unknown video action: ".concat(string13) : new String("Unknown video action: ")));
    }
}

