/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.TextureView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbdh;
import com.google.android.gms.internal.ads.zzbdl;
import com.google.android.gms.internal.ads.zzbds;
import com.google.android.gms.internal.ads.zzbdt;
import com.google.android.gms.internal.ads.zzbdu;
import com.google.android.gms.internal.ads.zzbdx;
import com.google.android.gms.internal.ads.zzbdy;
import com.google.android.gms.internal.ads.zzbdz;
import com.google.android.gms.internal.ads.zzbea;
import com.google.android.gms.internal.ads.zzbeb;
import com.google.android.gms.internal.ads.zzbec;
import com.google.android.gms.internal.ads.zzbed;
import com.google.android.gms.internal.ads.zzbee;
import com.google.android.gms.internal.ads.zzbef;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbeh;
import com.google.android.gms.internal.ads.zzbei;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbgh;
import com.google.android.gms.internal.ads.zzbgm;
import com.google.android.gms.internal.ads.zzge;
import com.google.android.gms.internal.ads.zzgf;
import com.google.android.gms.internal.ads.zzgh;
import com.google.android.gms.internal.ads.zzgl;
import com.google.android.gms.internal.ads.zzgn;
import com.google.android.gms.internal.ads.zzgq;
import com.google.android.gms.internal.ads.zzhd;
import com.google.android.gms.internal.ads.zzhh;
import com.google.android.gms.internal.ads.zzhn;
import com.google.android.gms.internal.ads.zzid;
import com.google.android.gms.internal.ads.zzig;
import com.google.android.gms.internal.ads.zziv;
import com.google.android.gms.internal.ads.zzjg;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjt;
import com.google.android.gms.internal.ads.zzyr;
import java.nio.ByteBuffer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.dataflow.qual.SideEffectFree;

@zzare
@ParametersAreNonnullByDefault
@TargetApi(value=16)
public final class zzbdr
extends zzbcp
implements TextureView.SurfaceTextureListener {
    private float zzefp;
    private final zzbdg zzebv;
    private final Context zzlj;
    private final int zzefq;
    private final zzbdh zzeay;
    private final boolean zzeaz;
    private final zzbdf zzefr;
    private zzbco zzebm;
    @Nullable
    private Surface zzaez;
    @Nullable
    private zzbdl zzefs;
    @Nullable
    private zzge zzefg;
    @Nullable
    private zzhd zzefh;
    @Nullable
    private zzgn zzefi;
    private String zzeft;
    private boolean zzefu;
    private int zzefv = 1;
    @Nullable
    private zzbde zzebj;
    private boolean zzebk;
    private boolean zzefw;
    private boolean zzefx;
    private int zzebe;
    private int zzebf;
    private float zzaft;
    private int zzebh;
    private int zzebi;
    private final zzgh zzefy = new zzbef(this);
    private final zzhh zzefz = new zzbeg(this);
    private final zzgq zzega = new zzbeh(this);

    public zzbdr(Context context, zzbdh zzbdh2, zzbdg zzbdg2, int n, boolean bl, boolean bl2, zzbdf zzbdf2) {
        super(context);
        this.zzlj = context;
        this.zzeaz = bl2;
        this.zzebv = zzbdg2;
        this.zzefq = n;
        this.zzeay = zzbdh2;
        this.zzebk = bl;
        this.zzefr = zzbdf2;
        this.setSurfaceTextureListener(this);
        this.zzeay.zzb(this);
    }

    @EnsuresNonNullIf(expression={"mPlayer"}, result=true)
    private final boolean zzyv() {
        return this.zzefg != null && !this.zzefu;
    }

    @EnsuresNonNullIf(expression={"mPlayer"}, result=true)
    private final boolean zzyw() {
        return this.zzyv() && this.zzefv != 1;
    }

    private final void zzyx() {
        if (this.zzefg != null) {
            return;
        }
        if (this.zzeft != null && this.zzaez != null) {
            zzbdr zzbdr2 = this;
            zzbdl zzbdl2 = null;
            if (zzbdr2.zzeft.startsWith("cache:")) {
                zzbfu zzbfu2 = zzbdr2.zzebv.zzet(zzbdr2.zzeft);
                if (zzbfu2 != null && zzbfu2 instanceof zzbgm) {
                    zzbgm zzbgm2 = (zzbgm)zzbfu2;
                    zzbgm2.zzzx();
                    zzbdl2 = zzbgm2.zzzy();
                    zzbdl2.zza(zzbdr2.zzefy, zzbdr2.zzefz, zzbdr2.zzega);
                } else if (zzbfu2 instanceof zzbgh) {
                    zzig zzig2;
                    zzjp zzjp2;
                    Object object;
                    zzid zzid2;
                    zzbgh zzbgh2 = (zzbgh)zzbfu2;
                    ByteBuffer byteBuffer = zzbgh2.getByteBuffer();
                    String string2 = zzbgh2.getUrl();
                    boolean bl = zzbgh2.zzzv();
                    zzbdl2 = new zzbdl();
                    boolean bl2 = bl;
                    ByteBuffer byteBuffer2 = byteBuffer;
                    String string3 = string2;
                    zzbdr zzbdr3 = zzbdr2;
                    zzid zzid3 = zzid2 = "video/webm".equals(null) ? new zzjg() : new zziv();
                    if (bl2 && byteBuffer2.limit() > 0) {
                        object = new byte[byteBuffer2.limit()];
                        byteBuffer2.get((byte[])object);
                        zzjp2 = new zzjo((byte[])object);
                        zzig2 = new zzig(Uri.parse((String)string3), zzjp2, zzid2, 2, zzbdr3.zzefr.zzeeg);
                    } else {
                        object = zzk.zzlg().zzq(zzbdr3.zzebv.getContext(), zzbdr3.zzebv.zzyh().zzbsy);
                        zzjp2 = new zzjt(zzbdr3.zzebv.getContext(), (String)object);
                        zzaci zzaci2 = zzact.zzcts;
                        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                            zzjp2 = new zzbei(zzbdr3.zzlj, zzjp2, new zzbdt(zzbdr3));
                        }
                        if (byteBuffer2.limit() > 0) {
                            byte[] byArray = new byte[byteBuffer2.limit()];
                            byteBuffer2.get(byArray);
                            zzjp zzjp3 = zzjp2;
                            zzjo zzjo2 = new zzjo(byArray);
                            zzjp2 = new zzbek(zzjo2, byArray.length, zzjp3);
                        }
                        zzig2 = new zzig(Uri.parse((String)string3), zzjp2, zzid2, 2, zzbdr3.zzefr.zzeeg);
                    }
                    zzig zzig3 = zzig2;
                    zzbdl2.zza(zzbdr2.zzefy, zzbdr2.zzefz, zzbdr2.zzega);
                    if (!zzbdl2.zza(zzig3)) {
                        zzbdr2.zzn("AdExoPlayerHelper Error", "Prepare from ByteBuffer failed.");
                    }
                } else {
                    String string4 = String.valueOf(zzbdr2.zzeft);
                    zzaxa.zzep((String)(string4.length() != 0 ? "Source is MD5 but not found in cache. Source: ".concat(string4) : new String("Source is MD5 but not found in cache. Source: ")));
                }
            } else {
                zzhn zzhn2;
                zzbdr zzbdr4 = zzbdr2;
                if (zzbdr4.zzefq == 1) {
                    zzhn2 = new zzgl(zzbdr4.zzebv.getContext(), Uri.parse((String)zzbdr4.zzeft), null, 2);
                } else {
                    Preconditions.checkArgument((zzbdr4.zzefq == 2 ? 1 : 0) != 0);
                    String string5 = zzk.zzlg().zzq(zzbdr4.zzebv.getContext(), zzbdr4.zzebv.zzyh().zzbsy);
                    zzjp zzjp4 = new zzjt(zzbdr4.zzebv.getContext(), string5);
                    zzaci zzaci3 = zzact.zzcts;
                    if (((Boolean)zzyr.zzpe().zzd(zzaci3)).booleanValue()) {
                        zzjp4 = new zzbei(zzbdr4.zzlj, zzjp4, new zzbds(zzbdr4));
                    }
                    zzid zzid4 = "video/webm".equals(null) ? new zzjg() : new zziv();
                    zzhn2 = new zzig(Uri.parse((String)zzbdr4.zzeft), zzjp4, zzid4, 2, zzbdr4.zzefr.zzeeg);
                }
                zzgl zzgl2 = zzhn2;
                zzbdl2 = new zzbdl();
                zzbdl2.zza(zzbdr2.zzefy, zzbdr2.zzefz, zzbdr2.zzega);
                if (!zzbdl2.zza(zzgl2)) {
                    zzbdr2.zzn("AdExoPlayerHelper Error", "Prepare failed.");
                }
            }
            this.zzefs = zzbdl2;
            if (this.zzefs == null) {
                String string6 = String.valueOf(this.zzeft);
                zzaxa.zzep((String)(string6.length() != 0 ? "AdExoPlayerHelper is null. Source: ".concat(string6) : new String("AdExoPlayerHelper is null. Source: ")));
                return;
            }
            this.zzefg = this.zzefs.zzys();
            this.zzefh = this.zzefs.zzyt();
            this.zzefi = this.zzefs.zzyu();
            if (this.zzefg != null) {
                this.zza(this.zzaez, false);
                this.zzefv = this.zzefg.getPlaybackState();
                if (this.zzefv == 4) {
                    this.zzyy();
                }
            }
        }
    }

    @SideEffectFree
    private final void zza(@Nullable Surface surface, boolean bl) {
        if (this.zzefg != null && this.zzefh != null) {
            if (bl) {
                this.zzefg.zzb(this.zzefh, 1, surface);
                return;
            }
            this.zzefg.zza((zzgf)this.zzefh, 1, surface);
            return;
        }
        zzaxa.zzep((String)"Trying to set surface before player and renderers are initalized.");
    }

    @SideEffectFree
    private final void zza(float f, boolean bl) {
        if (this.zzefg != null && this.zzefi != null) {
            if (bl) {
                this.zzefg.zzb(this.zzefi, 1, Float.valueOf(f));
                return;
            }
            this.zzefg.zza((zzgf)this.zzefi, 1, Float.valueOf(f));
            return;
        }
        zzaxa.zzep((String)"Trying to set volume before player and renderers are initalized.");
    }

    @Override
    public final void zzxk() {
        this.zza(this.zzebu.getVolume(), false);
    }

    private final void zzb(int n, int n2, float f) {
        float f2;
        float f3 = f2 = n2 == 0 ? 1.0f : (float)n * f / (float)n2;
        if (this.zzefp != f2) {
            this.zzefp = f2;
            this.requestLayout();
        }
    }

    private final void zzyy() {
        if (this.zzefw) {
            return;
        }
        this.zzefw = true;
        zzaxa.zzds("Video is ready.");
        zzaxj.zzdvx.post((Runnable)new zzbdx(this));
        ((zzbcp)this).zzxk();
        this.zzeay.zzhd();
        if (this.zzefx) {
            ((zzbcp)this).play();
        }
    }

    private final void zzyk() {
        zzaxa.zzds("Video ended.");
        if (this.zzefr.zzeee) {
            this.zzza();
        }
        this.zzeay.zzym();
        this.zzebu.zzym();
        zzaxj.zzdvx.post((Runnable)new zzbdy(this));
    }

    private final void zzn(String string2, @Nullable String string3) {
        zzaxa.zzep((String)new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error received: ").append(string2).append(" : ").append(string3).toString());
        this.zzefu = true;
        if (this.zzefr.zzeee) {
            this.zzza();
        }
        zzaxj.zzdvx.post((Runnable)new zzbdz(this, string2, string3));
    }

    @Override
    public final String zzxg() {
        String string2 = this.zzefq == 1 ? "/Framework" : (this.zzefq == 2 ? new StringBuilder(12 + String.valueOf(null).length()).append("/Extractor(").append((String)null).append(")").toString() : "/Unknown");
        String string3 = this.zzebk ? " spherical" : "";
        return new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ExoPlayer/1").append(string2).append(string3).toString();
    }

    @Override
    public final void zza(zzbco zzbco2) {
        this.zzebm = zzbco2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzeft = string2;
            this.zzyx();
            return;
        }
        zzaxa.zzep((String)"Path is null.");
    }

    @Override
    public final void play() {
        if (this.zzyw()) {
            if (this.zzefr.zzeee) {
                this.zzyz();
            }
            this.zzefg.zzd(true);
            this.zzeay.zzyl();
            this.zzebu.zzyl();
            this.zzebt.zzxm();
            zzaxj.zzdvx.post((Runnable)new zzbea(this));
            return;
        }
        this.zzefx = true;
    }

    @Override
    public final void stop() {
        if (this.zzyv()) {
            this.zzefg.stop();
            zzbdr zzbdr2 = this;
            if (zzbdr2.zzefg != null) {
                zzbdr2.zza(null, true);
                if (zzbdr2.zzefs != null) {
                    zzbdr2.zzefs.zzyr();
                    zzbdr2.zzefs = null;
                }
                zzbdr2.zzefg = null;
                zzbdr2.zzefh = null;
                zzbdr2.zzefi = null;
                zzbdr2.zzefv = 1;
                zzbdr2.zzefu = false;
                zzbdr2.zzefw = false;
                zzbdr2.zzefx = false;
            }
        }
        this.zzeay.zzym();
        this.zzebu.zzym();
        this.zzeay.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzyw()) {
            if (this.zzefr.zzeee) {
                this.zzza();
            }
            this.zzefg.zzd(false);
            this.zzeay.zzym();
            this.zzebu.zzym();
            zzaxj.zzdvx.post((Runnable)new zzbeb(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzyw()) {
            this.zzefg.seekTo(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebj != null) {
            this.zzebj.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzyw()) {
            return (int)this.zzefg.zzdn();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzyw()) {
            return (int)this.zzefg.getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzebe;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzebf;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzefp != 0.0f && this.zzebj == null) {
            float f;
            float f2 = (float)n3 / (float)n4;
            float f3 = this.zzefp / f2 - 1.0f;
            if (f > 0.01f) {
                n4 = (int)((float)n3 / this.zzefp);
            } else if (f3 < -0.01f) {
                n3 = (int)((float)n4 * this.zzefp);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebj != null) {
            this.zzebj.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebh > 0 && this.zzebh != n3 || this.zzebi > 0 && this.zzebi != n4) {
                zzbdr zzbdr2 = this;
                if (zzbdr2.zzeaz && zzbdr2.zzyv() && zzbdr2.zzefg.zzdn() > 0L && !zzbdr2.zzefg.zzdm()) {
                    zzbdr2.zza(0.0f, true);
                    zzbdr2.zzefg.zzd(true);
                    long l = zzbdr2.zzefg.zzdn();
                    long l2 = zzk.zzln().currentTimeMillis();
                    while (zzbdr2.zzyv() && zzbdr2.zzefg.zzdn() == l && zzk.zzln().currentTimeMillis() - l2 <= 250L) {
                    }
                    if (zzbdr2.zzyv()) {
                        zzbdr2.zzefg.zzd(false);
                    }
                    ((zzbcp)zzbdr2).zzxk();
                }
            }
            this.zzebh = n3;
            this.zzebi = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebk) {
            this.zzebj = new zzbde(this.getContext());
            this.zzebj.zza(surfaceTexture, n, n2);
            this.zzebj.start();
            SurfaceTexture surfaceTexture2 = this.zzebj.zzxy();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzebj.zzxx();
                this.zzebj = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzaez = new Surface(surfaceTexture3);
        if (this.zzefg == null) {
            this.zzyx();
        } else {
            this.zza(this.zzaez, true);
            if (!this.zzefr.zzeee) {
                this.zzyz();
            }
        }
        float f = 1.0f;
        if (this.zzebe != 0 && this.zzebf != 0) {
            n = this.zzebe;
            n2 = this.zzebf;
            f = this.zzaft;
        }
        this.zzb(n, n2, f);
        zzaxj.zzdvx.post((Runnable)new zzbec(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebj != null) {
            this.zzebj.zzm(n, n2);
        }
        zzaxj.zzdvx.post((Runnable)new zzbed(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzaxa.zzds("Surface destroyed");
        ((zzbcp)this).pause();
        if (this.zzebj != null) {
            this.zzebj.zzxx();
            this.zzebj = null;
        }
        if (this.zzefg != null) {
            this.zzza();
            if (this.zzaez != null) {
                this.zzaez.release();
            }
            this.zzaez = null;
            this.zza(null, true);
        }
        zzaxj.zzdvx.post((Runnable)new zzbee(this));
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeay.zzc(this);
        this.zzebt.zza(surfaceTexture, this.zzebm);
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzaxa.zzds(new StringBuilder(57).append("AdExoPlayerView1 window visibility changed to ").append(n).toString());
        zzaxj.zzdvx.post((Runnable)new zzbdu(this, n));
        super.onWindowVisibilityChanged(n);
    }

    private final void zzyz() {
        if (this.zzefg != null) {
            this.zzefg.zzc(0, true);
        }
    }

    private final void zzza() {
        if (this.zzefg != null) {
            this.zzefg.zzc(0, false);
        }
    }

    final /* synthetic */ void zzdd(int n) {
        if (this.zzebm != null) {
            this.zzebm.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzzb() {
        if (this.zzebm != null) {
            this.zzebm.zzxo();
        }
    }

    final /* synthetic */ void zzn(int n, int n2) {
        if (this.zzebm != null) {
            this.zzebm.zzk(n, n2);
        }
    }

    final /* synthetic */ void zzzc() {
        if (this.zzebm != null) {
            this.zzebm.zzxl();
        }
    }

    final /* synthetic */ void zzzd() {
        if (this.zzebm != null) {
            this.zzebm.onPaused();
        }
    }

    final /* synthetic */ void zzze() {
        if (this.zzebm != null) {
            this.zzebm.zzxm();
        }
    }

    final /* synthetic */ void zzo(String string2, String string3) {
        if (this.zzebm != null) {
            this.zzebm.zzl(string2, string3);
        }
    }

    final /* synthetic */ void zzzf() {
        if (this.zzebm != null) {
            this.zzebm.zzxn();
        }
    }

    final /* synthetic */ void zzzg() {
        if (this.zzebm != null) {
            this.zzebm.zzhd();
        }
    }

    final /* synthetic */ void zzb(boolean bl, long l) {
        this.zzebv.zza(bl, l);
    }

    final /* synthetic */ void zzc(boolean bl, long l) {
        this.zzebv.zza(bl, l);
    }

    static /* synthetic */ int zza(zzbdr zzbdr2) {
        return zzbdr2.zzefv;
    }

    static /* synthetic */ int zza(zzbdr zzbdr2, int n) {
        zzbdr2.zzefv = n;
        return zzbdr2.zzefv;
    }

    static /* synthetic */ void zzb(zzbdr zzbdr2) {
        zzbdr2.zzyy();
    }

    static /* synthetic */ void zzc(zzbdr zzbdr2) {
        zzbdr2.zzyk();
    }

    static /* synthetic */ void zza(zzbdr zzbdr2, String string2, String string3) {
        zzbdr2.zzn(string2, string3);
    }

    static /* synthetic */ int zzb(zzbdr zzbdr2, int n) {
        zzbdr2.zzebe = n;
        return zzbdr2.zzebe;
    }

    static /* synthetic */ int zzc(zzbdr zzbdr2, int n) {
        zzbdr2.zzebf = n;
        return zzbdr2.zzebf;
    }

    static /* synthetic */ float zza(zzbdr zzbdr2, float f) {
        zzbdr2.zzaft = f;
        return zzbdr2.zzaft;
    }

    static /* synthetic */ int zzd(zzbdr zzbdr2) {
        return zzbdr2.zzebe;
    }

    static /* synthetic */ int zze(zzbdr zzbdr2) {
        return zzbdr2.zzebf;
    }

    static /* synthetic */ float zzf(zzbdr zzbdr2) {
        return zzbdr2.zzaft;
    }

    static /* synthetic */ void zza(zzbdr zzbdr2, int n, int n2, float f) {
        zzbdr2.zzb(n, n2, f);
    }
}

