/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.Process;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzace;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzasr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxb;
import com.google.android.gms.internal.ads.zzaxh;
import com.google.android.gms.internal.ads.zzaxl;
import com.google.android.gms.internal.ads.zzaxm;
import com.google.android.gms.internal.ads.zzaxn;
import com.google.android.gms.internal.ads.zzaxo;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzazj;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzazx;
import com.google.android.gms.internal.ads.zzazy;
import com.google.android.gms.internal.ads.zzyr;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
public final class zzaxj {
    private AtomicReference<Pattern> zzdvv = new AtomicReference<Object>(null);
    private AtomicReference<Pattern> zzdvw = new AtomicReference<Object>(null);
    public static final Handler zzdvx = new zzaxb(Looper.getMainLooper());
    private boolean zzxt = true;
    private final Object zzdvy = new Object();
    @GuardedBy(value="userAgentLock")
    private String zzapq;
    private boolean zzdvz = false;
    private boolean zzdwa = false;

    public final void zza(Context context, String string2, boolean bl, HttpURLConnection httpURLConnection) {
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        String string3 = string2;
        Context context2 = context;
        zzaxj zzaxj2 = this;
        httpURLConnection2.setConnectTimeout(60000);
        httpURLConnection2.setInstanceFollowRedirects(false);
        httpURLConnection2.setReadTimeout(60000);
        httpURLConnection2.setRequestProperty("User-Agent", zzaxj2.zzq(context2, string3));
        httpURLConnection2.setUseCaches(false);
    }

    public static boolean zzp(Context context, String string2) {
        context = zzasr.zzw(context);
        String string3 = string2;
        String string4 = context.getPackageName();
        return Wrappers.packageManager((Context)context).checkPermission(string3, string4) == 0;
    }

    public static void zzb(Context context, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        ArrayList<String> arrayList2 = arrayList;
        String string4 = string2;
        Context context2 = context;
        ArrayList<String> arrayList3 = arrayList2;
        int n = arrayList3.size();
        Object var7_10 = null;
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            String string5 = (String)e;
            new zzazj(context2, string4, string5).zzvi();
        }
    }

    public static String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public final boolean zzak(Context context) {
        if (this.zzdvz) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzaxo(this, null), intentFilter);
        this.zzdvz = true;
        return true;
    }

    public final boolean zzal(Context context) {
        if (this.zzdwa) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.ads.intent.DEBUG_LOGGING_ENABLEMENT_CHANGED");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zzaxn(this, null), intentFilter);
        this.zzdwa = true;
        return true;
    }

    public final void zza(Context context, String string2, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzq(context, string2));
    }

    private static String zzwa() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuilder.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuilder.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuilder.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuilder.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuilder.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzq(Context context, String string2) {
        Object object = this.zzdvy;
        synchronized (object) {
            if (this.zzapq != null) {
                return this.zzapq;
            }
            if (string2 == null) {
                return zzaxj.zzwa();
            }
            try {
                this.zzapq = zzk.zzli().getDefaultUserAgent(context);
            }
            catch (Exception exception) {}
            if (TextUtils.isEmpty((CharSequence)this.zzapq)) {
                zzyr.zzpa();
                if (!zzazu.zzwy()) {
                    this.zzapq = null;
                    zzdvx.post((Runnable)new zzaxl(this, context));
                    while (this.zzapq == null) {
                        try {
                            this.zzdvy.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzapq = zzaxj.zzwa();
                            String string3 = String.valueOf(this.zzapq);
                            zzaxa.zzep((String)(string3.length() != 0 ? "Interrupted, use default user agent: ".concat(string3) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    this.zzapq = zzaxj.zzam(context);
                }
            }
            String string4 = String.valueOf(this.zzapq);
            this.zzapq = new StringBuilder(10 + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string4).append(" (Mobile; ").append(string2).toString();
            try {
                if (Wrappers.packageManager((Context)context).isCallerInstantApp()) {
                    this.zzapq = String.valueOf(this.zzapq).concat(";aia");
                }
            }
            catch (Exception exception) {
                zzk.zzlk().zza(exception, "AdUtil.getUserAgent");
            }
            this.zzapq = String.valueOf(this.zzapq).concat(")");
            return this.zzapq;
        }
    }

    @VisibleForTesting
    protected static String zzam(Context context) {
        try {
            return new WebView(context).getSettings().getUserAgentString();
        }
        catch (Throwable throwable) {
            return zzaxj.zzwa();
        }
    }

    public final JSONObject zzi(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string2 : map.keySet()) {
                this.zza(jSONObject, string2, map.get(string2));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string3 = String.valueOf(classCastException.getMessage());
            throw new JSONException(string3.length() != 0 ? "Could not convert map to JSON: ".concat(string3) : new String("Could not convert map to JSON: "));
        }
    }

    public final JSONObject zza(@Nullable Bundle bundle, JSONObject jSONObject) {
        try {
            if (bundle != null) {
                return this.zzd(bundle);
            }
            return null;
        }
        catch (JSONException jSONException) {
            zzaxa.zzc((String)"Error converting Bundle to JSON", (Throwable)jSONException);
            return null;
        }
    }

    public final JSONObject zzd(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : bundle.keySet()) {
            this.zza(jSONObject, string2, bundle.get(string2));
        }
        return jSONObject;
    }

    private final JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    private final void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzi(map));
            return;
        }
        if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            zzaxj zzaxj2 = this;
            JSONArray jSONArray2 = new JSONArray();
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object2 = objectArray2[i];
                zzaxj2.zza(jSONArray2, object2);
            }
            jSONArray.put((Object)jSONArray2);
            return;
        }
        jSONArray.put(object);
    }

    private final void zza(JSONObject jSONObject, String string2, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string2, (Object)this.zzd((Bundle)object));
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string2, (Object)this.zzi(map));
            return;
        }
        if (object instanceof Collection) {
            jSONObject.put(string2 != null ? string2 : "null", (Object)this.zza((Collection)object));
            return;
        }
        if (object instanceof Object[]) {
            jSONObject.put(string2, (Object)this.zza(Arrays.asList((Object[])object)));
            return;
        }
        jSONObject.put(string2, object);
    }

    private static int zza(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid Hex.");
    }

    public static Map<String, String> zzi(Uri uri) {
        zzaci zzaci2 = zzact.zzcwv;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            zzaci2 = uri;
            if (zzaci2 == null) {
                return null;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            zzk.zzli();
            for (String string2 : zzaci2.getQueryParameterNames()) {
                hashMap.put(string2, zzaci2.getQueryParameter(string2));
            }
            return hashMap;
        }
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(20);
        String string3 = uri.getEncodedQuery();
        if (string3 == null) {
            return hashMap;
        }
        int n = string3.length();
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder(100);
        StringBuilder stringBuilder2 = new StringBuilder(n);
        StringBuilder stringBuilder3 = stringBuilder;
        block11: while (n2 < n) {
            char c = string3.charAt(n2);
            switch (c) {
                case '+': {
                    stringBuilder3.append(' ');
                    break;
                }
                case '=': {
                    if (stringBuilder3 != stringBuilder2) {
                        stringBuilder3 = stringBuilder2;
                        break;
                    }
                    stringBuilder3.append(c);
                    break;
                }
                case '&': {
                    if (stringBuilder.length() > 0 && stringBuilder3 != stringBuilder) {
                        hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
                        stringBuilder.setLength(0);
                        stringBuilder2.setLength(0);
                    }
                    stringBuilder3 = stringBuilder;
                    break;
                }
                case '%': {
                    byte[] byArray = new byte[(n - n2) / 3];
                    int n3 = 0;
                    while (n2 < n - 2 && c == '%') {
                        try {
                            byArray[n3] = (byte)((zzaxj.zza(string3.charAt(n2 + 1)) << 4) + zzaxj.zza(string3.charAt(n2 + 2)));
                            ++n3;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        if ((n2 += 3) >= n) continue;
                        c = string3.charAt(n2);
                    }
                    try {
                        stringBuilder3.append(new String(byArray, 0, n3, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    if (c == '%') break;
                    continue block11;
                }
                default: {
                    stringBuilder3.append(c);
                }
            }
            ++n2;
        }
        if (stringBuilder.length() > 0 && stringBuilder3 != stringBuilder) {
            hashMap.put(stringBuilder.toString(), stringBuilder2.toString());
        }
        return hashMap;
    }

    public static String zzwb() {
        return UUID.randomUUID().toString();
    }

    public static int zzdy(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(numberFormatException);
            zzaxa.zzep((String)new StringBuilder(22 + String.valueOf(string3).length()).append("Could not parse value:").append(string3).toString());
            return 0;
        }
    }

    public static String zzwc() {
        String string2 = Build.MODEL;
        String string3 = Build.MANUFACTURER;
        if (string2.startsWith(string3)) {
            return string2;
        }
        return new StringBuilder(1 + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string3).append(" ").append(string2).toString();
    }

    private static int[] zzwd() {
        return new int[]{0, 0};
    }

    public static int[] zzd(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return zzaxj.zzwd();
    }

    public final int[] zze(Activity activity) {
        int[] nArray = zzaxj.zzd(activity);
        return new int[]{zzyr.zzpa().zzb((Context)activity, nArray[0]), zzyr.zzpa().zzb((Context)activity, nArray[1])};
    }

    public final int[] zzf(Activity activity) {
        int[] nArray;
        View view;
        Activity activity2 = activity;
        Window window = activity2.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = view.getTop();
            nArray = nArray2;
            nArray2[1] = view.getBottom();
        } else {
            nArray = zzaxj.zzwd();
        }
        int[] nArray3 = nArray;
        return new int[]{zzyr.zzpa().zzb((Context)activity, nArray3[0]), zzyr.zzpa().zzb((Context)activity, nArray3[1])};
    }

    public static boolean zzdz(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        return string2.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public static DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static AlertDialog.Builder zzan(Context context) {
        return new AlertDialog.Builder(context);
    }

    public static zzace zzao(Context context) {
        return new zzace(context);
    }

    public static Bitmap zzk(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public static PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, false);
    }

    public static String zzap(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static boolean zzaq(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public final void zza(Context context, @Nullable String string2, String string3, Bundle bundle, boolean bl) {
        zzk.zzlg();
        bundle.putString("device", zzaxj.zzwc());
        bundle.putString("eids", TextUtils.join((CharSequence)",", (Iterable)zzact.zzqn()));
        zzyr.zzpa();
        zzazu.zza((Context)context, (String)string2, (String)string3, (Bundle)bundle, (boolean)true, (zzazx)new zzaxm(this, context, string2));
    }

    public static void zzd(Runnable runnable) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            runnable.run();
            return;
        }
        zzaxh.zzc(runnable);
    }

    public static Bitmap zzl(View view) {
        if (view == null) {
            return null;
        }
        Bitmap bitmap = zzaxj.zzn(view);
        if (bitmap == null) {
            bitmap = zzaxj.zzm(view);
        }
        return bitmap;
    }

    private static Bitmap zzm(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzaxa.zzep((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzaxa.zzc((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private static Bitmap zzn(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzaxa.zzc((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public static void zza(Context context, Intent intent) {
        try {
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
    }

    public static int zzar(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return 0;
        }
        return applicationInfo.targetSdkVersion;
    }

    public final boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = zzaxj.zzas(context);
        return this.zza(view, powerManager, keyguardManager);
    }

    @Nullable
    private static KeyguardManager zzas(Context context) {
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return keyguardManager;
    }

    public final boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl;
        KeyguardManager keyguardManager2;
        boolean bl2 = zzk.zzlg().zzxt || !((keyguardManager2 = keyguardManager) == null ? false : keyguardManager2.inKeyguardRestrictedInputMode()) || zzaxj.zzo(view) ? true : (bl = false);
        if (view.getVisibility() == 0 && view.isShown() && ((keyguardManager2 = powerManager) == null || keyguardManager2.isScreenOn()) && bl) {
            keyguardManager2 = zzact.zzcqi;
            if (!((Boolean)zzyr.zzpe().zzd((zzaci)keyguardManager2)).booleanValue() || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect())) {
                return true;
            }
        }
        return false;
    }

    public static boolean zzo(View view) {
        Context context;
        View view2 = view.getRootView();
        Activity activity = view2 != null && (context = view2.getContext()) instanceof Activity ? (Activity)context : null;
        if (activity == null) {
            return false;
        }
        view2 = activity.getWindow();
        WindowManager.LayoutParams layoutParams = view2 == null ? null : view2.getAttributes();
        return layoutParams != null && (layoutParams.flags & 0x80000) != 0;
    }

    @TargetApi(value=16)
    public static boolean zzat(Context context) {
        if (context == null || !PlatformVersion.isAtLeastJellyBean()) {
            return false;
        }
        KeyguardManager keyguardManager = zzaxj.zzas(context);
        return keyguardManager != null && keyguardManager.isKeyguardLocked();
    }

    public static int zzp(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public static boolean zzau(Context context) {
        try {
            context.getClassLoader().loadClass("com.google.android.gms.ads.internal.ClientApi2");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
        catch (Throwable throwable) {
            zzaxa.zzc((String)"Error loading class.", (Throwable)throwable);
            zzk.zzlk().zza(throwable, "AdUtil.isLiteSdk");
            return false;
        }
    }

    @TargetApi(value=18)
    public static void zza(Context context, Uri uri) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            Bundle bundle = new Bundle();
            intent.putExtras(bundle);
            zzaxj.zzb(context, intent);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
            String string2 = uri.toString();
            zzaxa.zzdp((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Opening ").append(string2).append(" in a new browser.").toString());
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzaxa.zzc((String)"No browser is found.", (Throwable)activityNotFoundException);
            return;
        }
    }

    @TargetApi(value=18)
    public static void zzb(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Bundle bundle = intent.getExtras() != null ? intent.getExtras() : new Bundle();
            bundle.putBinder("android.support.customtabs.extra.SESSION", null);
            bundle.putString("com.android.browser.application_id", context.getPackageName());
            intent.putExtras(bundle);
        }
    }

    public static void zzc(Context context, String string2, String string3) {
        try {
            FileOutputStream fileOutputStream = context.openFileOutput(string2, 0);
            fileOutputStream.write(string3.getBytes("UTF-8"));
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Error writing to file in internal storage.", (Throwable)exception);
            return;
        }
    }

    public static String zzr(Context context, String string2) {
        try {
            FileInputStream fileInputStream = context.openFileInput(string2);
            return new String(IOUtils.readInputStreamFully((InputStream)fileInputStream, (boolean)true), "UTF-8");
        }
        catch (IOException iOException) {
            zzaxa.zzdp((String)"Error reading from internal storage.");
            return "";
        }
    }

    public final boolean zzea(String string2) {
        zzaci zzaci2 = zzact.zzcnu;
        return zzaxj.zza(string2, this.zzdvv, (String)zzyr.zzpe().zzd(zzaci2));
    }

    public final boolean zzeb(String string2) {
        zzaci zzaci2 = zzact.zzcnv;
        return zzaxj.zza(string2, this.zzdvw, (String)zzyr.zzpe().zzd(zzaci2));
    }

    private static boolean zza(String string2, AtomicReference<Pattern> atomicReference, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try {
            Pattern pattern = atomicReference.get();
            if (pattern == null || !string3.equals(pattern.pattern())) {
                pattern = Pattern.compile(string3);
                atomicReference.set(pattern);
            }
            return pattern.matcher(string2).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public static String zzwe() {
        Resources resources = zzk.zzlk().getResources();
        String string2 = resources != null ? resources.getString(R.string.s7) : "Test Ad";
        return string2;
    }

    @Nullable
    public static WebResourceResponse zzd(Context context, String string2, String string3) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("User-Agent", zzk.zzlg().zzq(context, string2));
            hashMap.put("Cache-Control", "max-stale=3600");
            String string4 = (String)new zzayv(context).zzc(string3, hashMap).get(60L, TimeUnit.SECONDS);
            if (string4 != null) {
                return new WebResourceResponse("application/javascript", "UTF-8", (InputStream)new ByteArrayInputStream(string4.getBytes("UTF-8")));
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            zzaxa.zzd((String)"Could not fetch MRAID JS.", (Throwable)exception);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static WebResourceResponse zzd(HttpURLConnection httpURLConnection) throws IOException {
        String string2;
        String string3;
        Object object2;
        block4: {
            Object object;
            zzk.zzlg();
            object2 = httpURLConnection.getContentType();
            string3 = TextUtils.isEmpty((CharSequence)object2) ? "" : ((String)object2).split(";")[0].trim();
            zzk.zzlg();
            object2 = httpURLConnection.getContentType();
            if (!TextUtils.isEmpty((CharSequence)object2) && ((String[])(object = ((String)object2).split(";"))).length != 1) {
                void entry;
                boolean i = true;
                while (entry < ((String[])object).length) {
                    String[] stringArray;
                    if (object[entry].trim().startsWith("charset") && (stringArray = ((String)object[entry]).trim().split("=")).length > 1) {
                        string2 = stringArray[1].trim();
                        break block4;
                    }
                    ++entry;
                }
            }
            string2 = "";
        }
        String string4 = string2;
        object2 = httpURLConnection.getHeaderFields();
        HashMap<String, String> hashMap = new HashMap<String, String>(object2.size());
        for (Map.Entry entry : object2.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || ((List)entry.getValue()).size() <= 0) continue;
            hashMap.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        HashMap<String, String> hashMap2 = hashMap;
        return zzk.zzli().zza(string3, string4, httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage(), hashMap2, httpURLConnection.getInputStream());
    }

    public static void zza(Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        boolean bl = false;
        try {
            zzaci zzaci2 = zzact.zzclg;
            bl = (Boolean)zzyr.zzpe().zzd(zzaci2);
        }
        catch (IllegalStateException illegalStateException) {}
        if (bl) {
            Throwable throwable2 = throwable;
            CrashUtils.addDynamiteErrorToDropBox((Context)context, (Throwable)throwable2);
        }
    }

    public static String zzav(Context context) {
        zzaci zzaci2 = zzact.zzcwm;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            return "";
        }
        return context.getSharedPreferences("mobileads_consent", 0).getString("consent_string", "");
    }

    public static Bundle zzaw(Context context) {
        zzaci zzaci2 = zzact.zzcwn;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            return null;
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        Bundle bundle = new Bundle();
        if (sharedPreferences.contains("IABConsent_CMPPresent")) {
            bundle.putBoolean("IABConsent_CMPPresent", sharedPreferences.getBoolean("IABConsent_CMPPresent", false));
        }
        String[] stringArray = new String[]{"IABConsent_SubjectToGDPR", "IABConsent_ConsentString", "IABConsent_ParsedPurposeConsents", "IABConsent_ParsedVendorConsents"};
        for (int i = 0; i < 4; ++i) {
            String string2 = stringArray[i];
            if (!sharedPreferences.contains(string2)) continue;
            bundle.putString(string2, sharedPreferences.getString(string2, null));
        }
        return bundle;
    }

    public static boolean zzax(Context context) {
        if (!(context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    public static boolean zzec(String string2) {
        int n;
        Object object;
        if (!zzazy.isEnabled()) {
            return false;
        }
        zzaci zzaci2 = zzact.zzcup;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            return false;
        }
        zzaci2 = zzact.zzcur;
        String string3 = (String)zzyr.zzpe().zzd(zzaci2);
        if (!string3.isEmpty()) {
            object = string3.split(";");
            int n2 = ((String[])object).length;
            for (n = 0; n < n2; ++n) {
                if (!((String)object[n]).equals(string2)) continue;
                return false;
            }
        }
        zzaci2 = zzact.zzcuq;
        object = (String)zzyr.zzpe().zzd(zzaci2);
        if (((String)object).isEmpty()) {
            return true;
        }
        String[] stringArray = ((String)object).split(";");
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean zza(zzaxj zzaxj2, boolean bl) {
        zzaxj2.zzxt = bl;
        return zzaxj2.zzxt;
    }

    static /* synthetic */ Object zza(zzaxj zzaxj2) {
        return zzaxj2.zzdvy;
    }

    static /* synthetic */ String zza(zzaxj zzaxj2, String string2) {
        zzaxj2.zzapq = string2;
        return zzaxj2.zzapq;
    }
}

