/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaus;
import com.google.android.gms.internal.ads.zzaut;
import com.google.android.gms.internal.ads.zzauu;
import com.google.android.gms.internal.ads.zzauv;
import com.google.android.gms.internal.ads.zzauw;
import com.google.android.gms.internal.ads.zzauz;
import com.google.android.gms.internal.ads.zzavb;
import com.google.android.gms.internal.ads.zzavc;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzavf;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxh;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbas;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzdrv;
import com.google.android.gms.internal.ads.zzdsi;
import com.google.android.gms.internal.ads.zzdsj;
import com.google.android.gms.internal.ads.zzdsk;
import com.google.android.gms.internal.ads.zzdsl;
import com.google.android.gms.internal.ads.zzdso;
import com.google.android.gms.internal.ads.zzdsp;
import com.google.android.gms.internal.ads.zzyr;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
@ParametersAreNonnullByDefault
public final class zzaur
implements zzavc {
    private static List<Future<Void>> zzdrb = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService zzdrc = Executors.newSingleThreadScheduledExecutor();
    @GuardedBy(value="lock")
    private final zzdsi zzdrd;
    @GuardedBy(value="lock")
    private final LinkedHashMap<String, zzdso> zzdre;
    @GuardedBy(value="lock")
    private final List<String> zzdrf = new ArrayList<String>();
    @GuardedBy(value="lock")
    private final List<String> zzdrg = new ArrayList<String>();
    private final Context zzlj;
    private final zzave zzdrh;
    @VisibleForTesting
    private boolean zzdri;
    private final zzauz zzdoe;
    private final zzavf zzdrj;
    private final Object lock = new Object();
    private HashSet<String> zzdrk = new HashSet();
    private boolean zzdrl = false;
    private boolean zzdrm = false;
    private boolean zzdrn = false;

    public zzaur(Context context, zzbaj zzbaj2, zzauz zzauz2, String string2, zzave zzave2) {
        Preconditions.checkNotNull((Object)((Object)zzauz2), (Object)"SafeBrowsing config is not present.");
        this.zzlj = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdre = new LinkedHashMap();
        this.zzdrh = zzave2;
        this.zzdoe = zzauz2;
        for (String string3 : this.zzdoe.zzdrx) {
            this.zzdrk.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzdrk.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzbaj zzbaj3 = zzbaj2;
        zzaur zzaur2 = this;
        zzdsi zzdsi2 = new zzdsi();
        new zzdsi().zzhrv = 8;
        zzdsi2.url = string4;
        zzdsi2.zzhrx = string4;
        zzdsi2.zzhrz = new zzdsj();
        zzdsi2.zzhrz.zzdrt = zzaur2.zzdoe.zzdrt;
        zzdsp zzdsp2 = new zzdsp();
        new zzdsp().zzhte = zzbaj3.zzbsy;
        zzdsp2.zzhtg = Wrappers.packageManager((Context)zzaur2.zzlj).isCallerInstantApp();
        long l = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzaur2.zzlj);
        if (l > 0L) {
            zzdsp2.zzhtf = l;
        }
        zzdsi2.zzhsj = zzdsp2;
        this.zzdrd = zzdsi2;
        this.zzdrj = new zzavf(this.zzlj, this.zzdoe.zzdsa, this);
    }

    @Override
    public final zzauz zzuc() {
        return this.zzdoe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdk(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrd.zzhsb = string2;
            return;
        }
    }

    @Override
    public final boolean zzud() {
        return PlatformVersion.isAtLeastKitKat() && this.zzdoe.zzdrv && !this.zzdrm;
    }

    @Override
    public final void zzj(View view) {
        if (!this.zzdoe.zzdrv) {
            return;
        }
        if (this.zzdrm) {
            return;
        }
        zzk.zzlg();
        Bitmap bitmap = zzaxj.zzl(view);
        if (bitmap == null) {
            zzavb.zzdp("Failed to capture the webview bitmap.");
            return;
        }
        this.zzdrm = true;
        zzaxj.zzd(new zzauu(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n == 3) {
                this.zzdrn = true;
            }
            if (this.zzdre.containsKey(string2)) {
                if (n == 3) {
                    this.zzdre.get((Object)string2).zzhtc = n;
                }
                return;
            }
            zzdso zzdso2 = new zzdso();
            new zzdso().zzhtc = n;
            zzdso2.zzhsw = this.zzdre.size();
            zzdso2.url = string2;
            zzdso2.zzhsx = new zzdsl();
            if (this.zzdrk.size() > 0 && map != null) {
                ArrayList<zzdsk> arrayList = new ArrayList<zzdsk>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    try {
                        String string3 = entry.getKey() != null ? entry.getKey() : "";
                        String string4 = entry.getValue() != null ? entry.getValue() : "";
                        String string5 = string3.toLowerCase(Locale.ENGLISH);
                        if (!this.zzdrk.contains(string5)) continue;
                        zzdsk zzdsk2 = new zzdsk();
                        new zzdsk().zzhsn = string3.getBytes("UTF-8");
                        zzdsk2.zzhso = string4.getBytes("UTF-8");
                        arrayList.add(zzdsk2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        zzavb.zzdp("Cannot convert string to bytes, skip header.");
                    }
                }
                zzdsk[] zzdskArray = new zzdsk[arrayList.size()];
                arrayList.toArray(zzdskArray);
                zzdso2.zzhsx.zzhsq = zzdskArray;
            }
            this.zzdre.put(string2, zzdso2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdl(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrf.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdm(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrg.add(string2);
            return;
        }
    }

    @Override
    public final String[] zza(String[] stringArray) {
        return this.zzdrj.zzb(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zzue() {
        this.zzdrl = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzdso zzdn(String string2) {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdre.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzuf() {
        Object object = this.lock;
        synchronized (object) {
            zzbbi zzbbi2 = zzbas.zza(this.zzdrh.zza(this.zzlj, this.zzdre.keySet()), new zzaus(this), zzbbn.zzeah);
            zzbbi zzbbi3 = zzbas.zza(zzbbi2, 10L, TimeUnit.SECONDS, zzdrc);
            zzbas.zza(zzbbi2, new zzauv(this, zzbbi3), zzbbn.zzeah);
            zzdrb.add(zzbbi3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzbbi<Void> zzug() {
        if (!(this.zzdri && this.zzdoe.zzdrz || this.zzdrn && this.zzdoe.zzdry || !this.zzdri && this.zzdoe.zzdrw)) {
            return zzbas.zzm(null);
        }
        Object object = this.lock;
        synchronized (object) {
            this.zzdrd.zzhsa = new zzdso[this.zzdre.size()];
            this.zzdre.values().toArray(this.zzdrd.zzhsa);
            this.zzdrd.zzhsk = this.zzdrf.toArray(new String[0]);
            this.zzdrd.zzhsl = this.zzdrg.toArray(new String[0]);
            if (zzavb.isEnabled()) {
                zzdso[] zzdsoArray = this.zzdrd.url;
                String string2 = this.zzdrd.zzhsb;
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(zzdsoArray).length() + String.valueOf(string2).length()).append("Sending SB report\n  url: ").append((String)zzdsoArray).append("\n  clickUrl: ").append(string2).append("\n  resources: \n").toString());
                zzdsoArray = this.zzdrd.zzhsa;
                int n = this.zzdrd.zzhsa.length;
                for (int i = 0; i < n; ++i) {
                    zzdso zzdso2 = zzdsoArray[i];
                    stringBuilder.append("    [");
                    stringBuilder.append(zzdso2.zzhtd.length);
                    stringBuilder.append("] ");
                    stringBuilder.append(zzdso2.url);
                }
                zzavb.zzdp(stringBuilder.toString());
            }
            String string3 = this.zzdoe.zzdru;
            byte[] byArray = zzdrv.zza(this.zzdrd);
            zzaur zzaur2 = this;
            zzbbi<String> zzbbi2 = new zzayv(zzaur2.zzlj).zza(1, string3, null, byArray);
            if (zzavb.isEnabled()) {
                zzbbi2.zza(new zzauw(zzaur2), zzaxh.zzdvr);
            }
            return zzbas.zza(zzbbi2, zzaut.zzdrp, zzbbn.zzeah);
        }
    }

    static final /* synthetic */ Void zzdo(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzbbi zzh(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzaur zzaur2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzaur2.lock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzdso zzdso2 = zzaur2.zzdn(string2);
                        if (zzdso2 == null) {
                            String string4 = String.valueOf(string2);
                            zzavb.zzdp(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        zzdso2.zzhtd = new String[n];
                        for (int i = 0; i < n; ++i) {
                            zzdso2.zzhtd[i] = jSONArray.getJSONObject(i).getString("threat_type");
                        }
                        zzaur2.zzdri = zzaur2.zzdri | n > 0;
                    }
                }
            }
            if (this.zzdri) {
                Object object = this.lock;
                synchronized (object) {
                    this.zzdrd.zzhrv = 9;
                }
            }
            return this.zzug();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            zzaci zzaci2 = zzact.zzctk;
            if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
                zzaxa.zzb((String)string5, (Throwable)jSONException2);
            }
            return zzbas.zzd(new Exception("Safebrowsing report transmission failed."));
        }
    }

    static /* synthetic */ Object zza(zzaur zzaur2) {
        return zzaur2.lock;
    }

    static /* synthetic */ zzdsi zzb(zzaur zzaur2) {
        return zzaur2.zzdrd;
    }

    static /* synthetic */ List zzuh() {
        return zzdrb;
    }
}

