/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.ads.impl.R;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzapq;
import com.google.android.gms.internal.ads.zzapr;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbha;
import java.util.Map;

@zzare
public final class zzapp
extends zzaqc {
    private final Map<String, String> zzcxs;
    private final Context zzlj;
    private String zzdht;
    private long zzdhu;
    private long zzdhv;
    private String zzdhw;
    private String zzdhx;

    public zzapp(zzbha zzbha2, Map<String, String> map) {
        super(zzbha2, "createCalendarEvent");
        this.zzcxs = map;
        this.zzlj = zzbha2.zzyd();
        zzapp zzapp2 = this;
        zzapp2.zzdht = zzapp2.zzdf("description");
        zzapp2.zzdhw = zzapp2.zzdf("summary");
        zzapp2.zzdhu = zzapp2.zzdg("start_ticks");
        zzapp2.zzdhv = zzapp2.zzdg("end_ticks");
        zzapp2.zzdhx = zzapp2.zzdf("location");
    }

    private final String zzdf(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzcxs.get(string2))) {
            return "";
        }
        return this.zzcxs.get(string2);
    }

    private final long zzdg(String string2) {
        String string3 = this.zzcxs.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.zzlj == null) {
            this.zzdh("Activity context is not available.");
            return;
        }
        zzk.zzlg();
        if (!zzaxj.zzao(this.zzlj).zzql()) {
            this.zzdh("This feature is not available on the device.");
            return;
        }
        zzk.zzlg();
        AlertDialog.Builder builder = zzaxj.zzan(this.zzlj);
        Resources resources = zzk.zzlk().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzapq(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzapr(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzdht);
        intent.putExtra("eventLocation", this.zzdhx);
        intent.putExtra("description", this.zzdhw);
        if (this.zzdhu > -1L) {
            intent.putExtra("beginTime", this.zzdhu);
        }
        if (this.zzdhv > -1L) {
            intent.putExtra("endTime", this.zzdhv);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzapp zzapp2) {
        return zzapp2.zzlj;
    }
}

