/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdmh;
import com.google.android.gms.internal.ads.zzdmp;
import com.google.android.gms.internal.ads.zzdmq;
import com.google.android.gms.internal.ads.zzdni;
import com.google.android.gms.internal.ads.zzdnj;
import com.google.android.gms.internal.ads.zzdoc;
import com.google.android.gms.internal.ads.zzdoq;
import com.google.android.gms.internal.ads.zzdpj;
import com.google.android.gms.internal.ads.zzdqa;
import com.google.android.gms.internal.ads.zzdqy;
import com.google.android.gms.internal.ads.zzdra;
import com.google.android.gms.internal.ads.zzdre;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzdnh
extends zzdmp {
    private static final Logger logger = Logger.getLogger(zzdnh.class.getName());
    private static final boolean zzhdn = zzdqy.zzbac();
    zzdnj zzhdo;

    public static zzdnh zzab(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzdnh zzm(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzdqy.zzbad()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzdnh() {
    }

    public abstract void zzw(int var1, int var2) throws IOException;

    public abstract void zzx(int var1, int var2) throws IOException;

    public abstract void zzy(int var1, int var2) throws IOException;

    public final void zzz(int n, int n2) throws IOException {
        this.zzy(n, zzdnh.zzgk(n2));
    }

    public abstract void zzaa(int var1, int var2) throws IOException;

    public abstract void zzh(int var1, long var2) throws IOException;

    public final void zzi(int n, long l) throws IOException {
        this.zzh(n, zzdnh.zzfr(l));
    }

    public abstract void zzj(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzaa(n, Float.floatToRawIntBits(f));
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzj(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzi(int var1, boolean var2) throws IOException;

    public abstract void zzf(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzdmq var2) throws IOException;

    public abstract void zza(int var1, zzdpj var2) throws IOException;

    abstract void zza(int var1, zzdpj var2, zzdqa var3) throws IOException;

    public abstract void zzb(int var1, zzdpj var2) throws IOException;

    public abstract void zzb(int var1, zzdmq var2) throws IOException;

    public abstract void zzfz(int var1) throws IOException;

    public abstract void zzga(int var1) throws IOException;

    public final void zzgb(int n) throws IOException {
        this.zzga(zzdnh.zzgk(n));
    }

    public abstract void zzgc(int var1) throws IOException;

    public abstract void zzfj(long var1) throws IOException;

    public final void zzfk(long l) throws IOException {
        this.zzfj(zzdnh.zzfr(l));
    }

    public abstract void zzfl(long var1) throws IOException;

    public final void zzg(float f) throws IOException {
        this.zzgc(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzfl(Double.doubleToRawLongBits(d));
    }

    public final void zzbf(boolean bl) throws IOException {
        this.zzd((byte)(bl ? 1 : 0));
    }

    public abstract void zzgw(String var1) throws IOException;

    public abstract void zzcz(zzdmq var1) throws IOException;

    public abstract void zzj(zzdpj var1) throws IOException;

    abstract void zza(zzdpj var1, zzdqa var2) throws IOException;

    public abstract void zzd(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzab(int n, int n2) {
        return zzdnh.zzgd(n) + zzdnh.zzge(n2);
    }

    public static int zzac(int n, int n2) {
        return zzdnh.zzgd(n) + zzdnh.zzgf(n2);
    }

    public static int zzad(int n, int n2) {
        return zzdnh.zzgd(n) + zzdnh.zzgf(zzdnh.zzgk(n2));
    }

    public static int zzae(int n, int n2) {
        return zzdnh.zzgd(n) + 4;
    }

    public static int zzaf(int n, int n2) {
        return zzdnh.zzgd(n) + 4;
    }

    public static int zzk(int n, long l) {
        return zzdnh.zzgd(n) + zzdnh.zzfn(l);
    }

    public static int zzl(int n, long l) {
        return zzdnh.zzgd(n) + zzdnh.zzfn(l);
    }

    public static int zzm(int n, long l) {
        return zzdnh.zzgd(n) + zzdnh.zzfn(zzdnh.zzfr(l));
    }

    public static int zzn(int n, long l) {
        return zzdnh.zzgd(n) + 8;
    }

    public static int zzo(int n, long l) {
        return zzdnh.zzgd(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzdnh.zzgd(n) + 4;
    }

    public static int zzc(int n, double d) {
        return zzdnh.zzgd(n) + 8;
    }

    public static int zzj(int n, boolean bl) {
        return zzdnh.zzgd(n) + 1;
    }

    public static int zzag(int n, int n2) {
        return zzdnh.zzgd(n) + zzdnh.zzge(n2);
    }

    public static int zzg(int n, String string) {
        return zzdnh.zzgd(n) + zzdnh.zzgx(string);
    }

    public static int zzc(int n, zzdmq zzdmq2) {
        int n2 = zzdmq2.size();
        return zzdnh.zzgd(n) + (zzdnh.zzgf(n2) + n2);
    }

    public static int zza(int n, zzdoq zzdoq2) {
        int n2 = zzdoq2.zzaxj();
        return zzdnh.zzgd(n) + (zzdnh.zzgf(n2) + n2);
    }

    public static int zzc(int n, zzdpj zzdpj2) {
        return zzdnh.zzgd(n) + zzdnh.zzk(zzdpj2);
    }

    static int zzb(int n, zzdpj zzdpj2, zzdqa zzdqa2) {
        return zzdnh.zzgd(n) + zzdnh.zzb(zzdpj2, zzdqa2);
    }

    public static int zzd(int n, zzdpj zzdpj2) {
        return (zzdnh.zzgd(1) << 1) + zzdnh.zzac(2, n) + zzdnh.zzc(3, zzdpj2);
    }

    public static int zzd(int n, zzdmq zzdmq2) {
        return (zzdnh.zzgd(1) << 1) + zzdnh.zzac(2, n) + zzdnh.zzc(3, zzdmq2);
    }

    public static int zzb(int n, zzdoq zzdoq2) {
        return (zzdnh.zzgd(1) << 1) + zzdnh.zzac(2, n) + zzdnh.zza(3, zzdoq2);
    }

    public static int zzgd(int n) {
        return zzdnh.zzgf(n << 3);
    }

    public static int zzge(int n) {
        if (n >= 0) {
            return zzdnh.zzgf(n);
        }
        return 10;
    }

    public static int zzgf(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzgg(int n) {
        return zzdnh.zzgf(zzdnh.zzgk(n));
    }

    public static int zzgh(int n) {
        return 4;
    }

    public static int zzgi(int n) {
        return 4;
    }

    public static int zzfm(long l) {
        return zzdnh.zzfn(l);
    }

    public static int zzfn(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzfo(long l) {
        return zzdnh.zzfn(zzdnh.zzfr(l));
    }

    public static int zzfp(long l) {
        return 8;
    }

    public static int zzfq(long l) {
        return 8;
    }

    public static int zzh(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzbg(boolean bl) {
        return 1;
    }

    public static int zzgj(int n) {
        return zzdnh.zzge(n);
    }

    public static int zzgx(String string) {
        int n;
        try {
            n = zzdra.zza(string);
        }
        catch (zzdre zzdre2) {
            n = string.getBytes(zzdoc.UTF_8).length;
        }
        int n2 = n;
        return zzdnh.zzgf(n2) + n2;
    }

    public static int zza(zzdoq zzdoq2) {
        int n = zzdoq2.zzaxj();
        return zzdnh.zzgf(n) + n;
    }

    public static int zzda(zzdmq zzdmq2) {
        int n = zzdmq2.size();
        return zzdnh.zzgf(n) + n;
    }

    public static int zzac(byte[] byArray) {
        int n = byArray.length;
        return zzdnh.zzgf(n) + n;
    }

    public static int zzk(zzdpj zzdpj2) {
        int n = zzdpj2.zzaxj();
        return zzdnh.zzgf(n) + n;
    }

    static int zzb(zzdpj zzdpj2, zzdqa zzdqa2) {
        zzdqa zzdqa3 = zzdqa2;
        zzdmh zzdmh2 = (zzdmh)zzdpj2;
        int n = zzdmh2.zzavg();
        if (n == -1) {
            n = zzdqa3.zzak(zzdmh2);
            zzdmh2.zzfi(n);
        }
        int n2 = n;
        return zzdnh.zzgf(n2) + n2;
    }

    private static int zzgk(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzfr(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzawu();

    public final void zzawv() {
        if (this.zzawu() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzk(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzdre zzdre2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzdre2);
        byte[] byArray = string.getBytes(zzdoc.UTF_8);
        try {
            this.zzga(byArray.length);
            this.zzh(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzdpj zzdpj2, zzdqa zzdqa2) {
        zzdqa zzdqa3;
        int n2 = zzdnh.zzgd(n) << 1;
        zzdqa zzdqa4 = zzdqa3 = zzdqa2;
        zzdmh zzdmh2 = (zzdmh)zzdpj2;
        int n3 = zzdmh2.zzavg();
        if (n3 == -1) {
            n3 = zzdqa4.zzak(zzdmh2);
            zzdmh2.zzfi(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzl(zzdpj zzdpj2) {
        return zzdpj2.zzaxj();
    }

    @Deprecated
    public static int zzgl(int n) {
        return zzdnh.zzgf(n);
    }

    /* synthetic */ zzdnh(zzdni zzdni2) {
        this();
    }

    static final class zze
    extends zzdnh {
        private final ByteBuffer zzhdr;
        private final ByteBuffer zzaxl;
        private final long zzhds;
        private final long zzhdt;
        private final long zzhdu;
        private final long zzhdv;
        private long zzahv;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzhdr = byteBuffer;
            this.zzaxl = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhds = zzdqy.zzn(byteBuffer);
            this.zzhdt = this.zzhds + (long)byteBuffer.position();
            this.zzhdu = this.zzhds + (long)byteBuffer.limit();
            this.zzhdv = this.zzhdu - 10L;
            this.zzahv = this.zzhdt;
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdnh)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzx(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfz(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzga(n2);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 5);
            ((zzdnh)this).zzgc(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfj(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 1);
            ((zzdnh)this).zzfl(l);
        }

        @Override
        public final void zzi(int n, boolean bl) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzgw(string);
        }

        @Override
        public final void zza(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzcz(zzdmq2);
        }

        @Override
        public final void zza(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzj(zzdpj2);
        }

        @Override
        final void zza(int n, zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zza(zzdpj2, zzdqa2);
        }

        @Override
        public final void zzb(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdpj2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzb(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdmq2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzj(zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzga(zzdpj2.zzaxj());
            zzdpj2.zzb(this);
        }

        @Override
        final void zza(zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            zzdqa zzdqa3 = zzdqa2;
            zzdmh zzdmh2 = (zzdmh)zzdpj2;
            int n = zzdmh2.zzavg();
            if (n == -1) {
                n = zzdqa3.zzak(zzdmh2);
                zzdmh2.zzfi(n);
            }
            ((zzdnh)this).zzga(n);
            zzdqa2.zza(zzdpj2, this.zzhdo);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            if (this.zzahv >= this.zzhdu) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzahv, this.zzhdu, 1));
            }
            zzdqy.zza(this.zzahv++, by);
        }

        @Override
        public final void zzcz(zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzga(zzdmq2.size());
            zzdmq2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).zzga(n2);
            ((zzdnh)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdnh)this).zzga(n);
                return;
            }
            ((zzdnh)this).zzfj(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (this.zzahv <= this.zzhdv) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzdqy.zza(this.zzahv++, (byte)n);
                        return;
                    }
                    zzdqy.zza(this.zzahv++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzahv < this.zzhdu) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzdqy.zza(this.zzahv++, (byte)n);
                    return;
                }
                zzdqy.zza(this.zzahv++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzahv, this.zzhdu, 1));
        }

        @Override
        public final void zzgc(int n) throws IOException {
            long l = this.zzahv;
            zze zze2 = this;
            this.zzaxl.putInt((int)(l - zze2.zzhds), n);
            this.zzahv += 4L;
        }

        @Override
        public final void zzfj(long l) throws IOException {
            if (this.zzahv <= this.zzhdv) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdqy.zza(this.zzahv++, (byte)l);
                        return;
                    }
                    zzdqy.zza(this.zzahv++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzahv < this.zzhdu) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzdqy.zza(this.zzahv++, (byte)l);
                    return;
                }
                zzdqy.zza(this.zzahv++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzahv, this.zzhdu, 1));
        }

        @Override
        public final void zzfl(long l) throws IOException {
            long l2 = this.zzahv;
            zze zze2 = this;
            this.zzaxl.putLong((int)(l2 - zze2.zzhds), l);
            this.zzahv += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzhdu - (long)n2 < this.zzahv) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzahv, this.zzhdu, n2));
            }
            zzdqy.zza(byArray, n, this.zzahv, n2);
            this.zzahv += (long)n2;
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgw(String string) throws IOException {
            long l = this.zzahv;
            try {
                int n = zze.zzgf(string.length() * 3);
                int n2 = zze.zzgf(string.length());
                if (n2 == n) {
                    long l2 = this.zzahv;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzhds) + n2;
                    this.zzaxl.position(n3);
                    zzdra.zza(string, this.zzaxl);
                    int n4 = this.zzaxl.position() - n3;
                    ((zzdnh)this).zzga(n4);
                    this.zzahv += (long)n4;
                    return;
                }
                int n5 = zzdra.zza(string);
                ((zzdnh)this).zzga(n5);
                this.zzfs(this.zzahv);
                zzdra.zza(string, this.zzaxl);
                this.zzahv += (long)n5;
                return;
            }
            catch (zzdre zzdre2) {
                this.zzahv = l;
                this.zzfs(this.zzahv);
                this.zza(string, zzdre2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzahv;
            zze zze2 = this;
            this.zzhdr.position((int)(l - zze2.zzhds));
        }

        @Override
        public final int zzawu() {
            return (int)(this.zzhdu - this.zzahv);
        }

        private final void zzfs(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzaxl.position((int)(l2 - zze2.zzhds));
        }
    }

    static final class zzd
    extends zzdnh {
        private final ByteBuffer zzhdr;
        private final ByteBuffer zzaxl;
        private final int zzhdq;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzhdr = byteBuffer;
            this.zzaxl = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzhdq = byteBuffer.position();
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdnh)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzx(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfz(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzga(n2);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 5);
            ((zzdnh)this).zzgc(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfj(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 1);
            ((zzdnh)this).zzfl(l);
        }

        @Override
        public final void zzi(int n, boolean bl) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzgw(string);
        }

        @Override
        public final void zza(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzcz(zzdmq2);
        }

        @Override
        public final void zza(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzj(zzdpj2);
        }

        @Override
        final void zza(int n, zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zza(zzdpj2, zzdqa2);
        }

        @Override
        public final void zzb(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdpj2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzb(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdmq2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzj(zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzga(zzdpj2.zzaxj());
            zzdpj2.zzb(this);
        }

        @Override
        final void zza(zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            zzdqa zzdqa3 = zzdqa2;
            zzdmh zzdmh2 = (zzdmh)zzdpj2;
            int n = zzdmh2.zzavg();
            if (n == -1) {
                n = zzdqa3.zzak(zzdmh2);
                zzdmh2.zzfi(n);
            }
            ((zzdnh)this).zzga(n);
            zzdqa2.zza(zzdpj2, this.zzhdo);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.zzaxl.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzcz(zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzga(zzdmq2.size());
            zzdmq2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).zzga(n2);
            ((zzdnh)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdnh)this).zzga(n);
                return;
            }
            ((zzdnh)this).zzfj(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzaxl.put((byte)n);
                        return;
                    }
                    this.zzaxl.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzgc(int n) throws IOException {
            try {
                this.zzaxl.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzfj(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzaxl.put((byte)l);
                        return;
                    }
                    this.zzaxl.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzfl(long l) throws IOException {
            try {
                this.zzaxl.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzaxl.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgw(String string) throws IOException {
            int n = this.zzaxl.position();
            try {
                int n2 = zzd.zzgf(string.length() * 3);
                int n3 = zzd.zzgf(string.length());
                if (n3 == n2) {
                    int n4 = this.zzaxl.position() + n3;
                    this.zzaxl.position(n4);
                    this.zzgy(string);
                    int n5 = this.zzaxl.position();
                    this.zzaxl.position(n);
                    ((zzdnh)this).zzga(n5 - n4);
                    this.zzaxl.position(n5);
                    return;
                }
                int n6 = zzdra.zza(string);
                ((zzdnh)this).zzga(n6);
                this.zzgy(string);
                return;
            }
            catch (zzdre zzdre2) {
                this.zzaxl.position(n);
                this.zza(string, zzdre2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzhdr.position(this.zzaxl.position());
        }

        @Override
        public final int zzawu() {
            return this.zzaxl.remaining();
        }

        private final void zzgy(String string) throws IOException {
            try {
                zzdra.zza(string, this.zzaxl);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzhdp;
        private int zzhdq;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzhdp = byteBuffer;
            this.zzhdq = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzhdp.position(this.zzhdq + this.zzawx());
        }
    }

    static class zza
    extends zzdnh {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzw(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzdnh)this).zzga(n << 3 | n3);
        }

        @Override
        public final void zzx(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfz(n2);
        }

        @Override
        public final void zzy(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzga(n2);
        }

        @Override
        public final void zzaa(int n, int n2) throws IOException {
            ((zzdnh)this).zzw(n, 5);
            ((zzdnh)this).zzgc(n2);
        }

        @Override
        public final void zzh(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzfj(l);
        }

        @Override
        public final void zzj(int n, long l) throws IOException {
            ((zzdnh)this).zzw(n, 1);
            ((zzdnh)this).zzfl(l);
        }

        @Override
        public final void zzi(int n, boolean bl) throws IOException {
            ((zzdnh)this).zzw(n, 0);
            ((zzdnh)this).zzd((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzf(int n, String string) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzgw(string);
        }

        @Override
        public final void zza(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzcz(zzdmq2);
        }

        @Override
        public final void zzcz(zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzga(zzdmq2.size());
            zzdmq2.zza(this);
        }

        @Override
        public final void zzk(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).zzga(n2);
            ((zzdnh)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            ((zzdnh)this).zzj(zzdpj2);
        }

        @Override
        final void zza(int n, zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            ((zzdnh)this).zzw(n, 2);
            zzdqa zzdqa3 = zzdqa2;
            zzdmh zzdmh2 = (zzdmh)zzdpj2;
            int n2 = zzdmh2.zzavg();
            if (n2 == -1) {
                n2 = zzdqa3.zzak(zzdmh2);
                zzdmh2.zzfi(n2);
            }
            ((zzdnh)this).zzga(n2);
            zzdqa2.zza(zzdpj2, this.zzhdo);
        }

        @Override
        public final void zzb(int n, zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdpj2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzb(int n, zzdmq zzdmq2) throws IOException {
            ((zzdnh)this).zzw(1, 3);
            ((zzdnh)this).zzy(2, n);
            ((zzdnh)this).zza(3, zzdmq2);
            ((zzdnh)this).zzw(1, 4);
        }

        @Override
        public final void zzj(zzdpj zzdpj2) throws IOException {
            ((zzdnh)this).zzga(zzdpj2.zzaxj());
            zzdpj2.zzb(this);
        }

        @Override
        final void zza(zzdpj zzdpj2, zzdqa zzdqa2) throws IOException {
            zzdqa zzdqa3 = zzdqa2;
            zzdmh zzdmh2 = (zzdmh)zzdpj2;
            int n = zzdmh2.zzavg();
            if (n == -1) {
                n = zzdqa3.zzak(zzdmh2);
                zzdmh2.zzfi(n);
            }
            ((zzdnh)this).zzga(n);
            zzdqa2.zza(zzdpj2, this.zzhdo);
        }

        @Override
        public final void zzd(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfz(int n) throws IOException {
            if (n >= 0) {
                ((zzdnh)this).zzga(n);
                return;
            }
            ((zzdnh)this).zzfj(n);
        }

        @Override
        public final void zzga(int n) throws IOException {
            if (zzhdn && ((zzdnh)this).zzawu() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzdqy.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzdqy.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzgc(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfj(long l) throws IOException {
            if (zzhdn && ((zzdnh)this).zzawu() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzdqy.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzdqy.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzfl(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzh(byte[] byArray, int n, int n2) throws IOException {
            ((zzdnh)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgw(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzgf(string.length() * 3);
                int n3 = zza.zzgf(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzdra.zza(string, this.buffer, this.position, ((zzdnh)this).zzawu());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzdnh)this).zzga(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzdra.zza(string);
                ((zzdnh)this).zzga(n6);
                this.position = zzdra.zza(string, this.buffer, this.position, ((zzdnh)this).zzawu());
                return;
            }
            catch (zzdre zzdre2) {
                this.position = n;
                this.zza(string, zzdre2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzawu() {
            return this.limit - this.position;
        }

        public final int zzawx() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

