/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.EventImpl;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

final class EventListenerImpl
implements EventListener {
    static Map<EventListener, Long> EL2peer = new WeakHashMap<EventListener, Long>();
    static Map<Long, WeakReference<EventListener>> peer2EL = new HashMap<Long, WeakReference<EventListener>>();
    protected final EventListener eventListener;
    protected final long contextPeer;
    protected final long rootPeer;
    protected final long jsPeer;

    static long getPeer(EventListener eventListener, long contextPeer, long rootPeer) {
        if (eventListener == null) {
            return 0L;
        }
        Long peer = EL2peer.get(eventListener);
        if (peer != null) {
            return peer;
        }
        EventListenerImpl eli = new EventListenerImpl(eventListener, 0L, contextPeer, rootPeer);
        peer = eli.twkCreatePeer();
        EL2peer.put(eventListener, peer);
        peer2EL.put(peer, new WeakReference<EventListener>(eventListener));
        return peer;
    }

    private native long twkCreatePeer();

    static EventListener getELfromPeer(long peer) {
        WeakReference<EventListener> wr = peer2EL.get(peer);
        return wr == null ? null : (EventListener)wr.get();
    }

    static EventListener getImpl(long peer, long contextPeer, long rootPeer) {
        if (peer == 0L) {
            return null;
        }
        EventListener ev = EventListenerImpl.getELfromPeer(peer);
        if (ev != null) {
            EventListenerImpl.twkDisposeJSPeer(peer);
            return ev;
        }
        EventListenerImpl el = new EventListenerImpl(null, peer, contextPeer, rootPeer);
        EL2peer.put(el, peer);
        peer2EL.put(peer, new WeakReference<EventListenerImpl>(el));
        Disposer.addRecord(el, new SelfDisposer(peer));
        return el;
    }

    @Override
    public void handleEvent(Event evt) {
        if (this.jsPeer != 0L && evt instanceof EventImpl) {
            EventListenerImpl.twkDispatchEvent(this.jsPeer, ((EventImpl)evt).getPeer());
        }
    }

    private static native void twkDispatchEvent(long var0, long var2);

    private EventListenerImpl(EventListener eventListener, long jsPeer, long contextPeer, long rootPeer) {
        this.eventListener = eventListener;
        this.contextPeer = contextPeer;
        this.rootPeer = rootPeer;
        this.jsPeer = jsPeer;
    }

    private static void dispose(long peer) {
        EventListener ev = EventListenerImpl.getELfromPeer(peer);
        if (ev != null) {
            EL2peer.remove(ev);
        }
        peer2EL.remove(peer);
    }

    private static native void twkDisposeJSPeer(long var0);

    private void fwkHandleEvent(long eventPeer) {
        this.eventListener.handleEvent(EventImpl.getImpl(eventPeer, this.contextPeer, this.rootPeer));
    }

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            EventListenerImpl.dispose(this.peer);
            EventListenerImpl.twkDisposeJSPeer(this.peer);
        }
    }
}

