/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ThemeUtils {
    public static final int BUFFER_SIZE = 20480;

    public static int getColor(String colorValue) {
        if (colorValue != null && colorValue.startsWith("0x")) {
            colorValue = colorValue.substring(2);
            int len = colorValue.length();
            int a = 0;
            int r = 0;
            int g = 0;
            int b = 0;
            if (len == 8) {
                a = Integer.parseInt(colorValue.substring(0, 2), 16);
                r = Integer.parseInt(colorValue.substring(2, 4), 16);
                g = Integer.parseInt(colorValue.substring(4, 6), 16);
                b = Integer.parseInt(colorValue.substring(6, 8), 16);
            } else if (len == 6) {
                a = 255;
                r = Integer.parseInt(colorValue.substring(2, 4), 16);
                g = Integer.parseInt(colorValue.substring(4, 6), 16);
                b = Integer.parseInt(colorValue.substring(6, 8), 16);
            }
            Color color = new Color(r, g, b, a);
            return color.getRGB();
        }
        return 0;
    }

    public static int getInt(String value) {
        try {
            if (value.contains("sp")) {
                value = value.substring(0, value.length() - 2);
            }
            if (value != null) {
                return Integer.decode(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public static int[] splitInt(String value, String reg) {
        String[] strValues = ThemeUtils.splitString(value, reg);
        if (strValues != null && strValues.length > 0) {
            int[] intValues = new int[strValues.length];
            int i = 0;
            while (i < intValues.length) {
                intValues[i] = ThemeUtils.getInt(strValues[i]);
                ++i;
            }
            return intValues;
        }
        return new int[0];
    }

    public static String[] splitString(String value, String reg) {
        if (value != null && value.length() > 0) {
            String newReg = "\\";
            if (reg.equals(".") || reg.equals("|") || reg.equals("*") || reg.equals("+") || reg.equals("\\")) {
                reg = String.valueOf(newReg) + reg;
            }
            String[] valueArray = value.split(reg);
            ArrayList<String> a = new ArrayList<String>();
            int i = 0;
            while (i < valueArray.length) {
                if (valueArray[i].equals("\\") && valueArray[i + 1].equals("")) {
                    a.add(reg);
                    ++i;
                } else {
                    a.add(valueArray[i]);
                }
                ++i;
            }
            return a.toArray(new String[0]);
        }
        return new String[0];
    }

    public static float getFloat(String value) {
        try {
            if (value != null) {
                return Float.parseFloat(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0.0f;
    }

    public static String getFileNameNoSuffix(String filename) {
        int dot;
        if (filename != null && filename.length() > 0 && (dot = filename.lastIndexOf(46)) > -1 && dot < filename.length()) {
            return filename.substring(0, dot);
        }
        return filename;
    }

    public static String getFileType(String filename) {
        if (filename != null && filename.length() > 0) {
            String fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            return fileType;
        }
        return filename;
    }

    public static void getAllDirFromDir(String filePath, Map<Integer, File> pathMap, boolean isDirOrFile) throws Exception {
        if (pathMap == null) {
            pathMap = new HashMap<Integer, File>();
        }
        int j = 0;
        File[] fList = null;
        try {
            File f = new File(filePath);
            if (f.isDirectory()) {
                fList = f.listFiles();
                if (isDirOrFile) {
                    j = 0;
                    while (j < fList.length) {
                        if (fList[j].isDirectory()) {
                            pathMap.put(pathMap.size(), fList[j]);
                        }
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < fList.length) {
                        if (fList[j].isFile()) {
                            pathMap.put(pathMap.size(), fList[j]);
                        }
                        ++j;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error\ufffd\ufffd " + e);
        }
    }

    public static boolean copyFile(InputStream is, String destFilePath, boolean cover) {
        boolean succeed;
        block33: {
            if (is == null || destFilePath == null) {
                return false;
            }
            File destFile = new File(destFilePath);
            if (destFile.exists() && !cover) {
                return true;
            }
            File destParentFile = destFile.getParentFile();
            if (destParentFile != null && !destParentFile.exists()) {
                destParentFile.mkdirs();
            }
            succeed = false;
            FileOutputStream destOutStream = null;
            FilterOutputStream bufOutStream = null;
            try {
                try {
                    int count;
                    destOutStream = new FileOutputStream(destFile);
                    bufOutStream = new BufferedOutputStream(destOutStream);
                    byte[] buffer = new byte[20480];
                    while ((count = is.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufOutStream).write(buffer, 0, count);
                    }
                    ((BufferedOutputStream)bufOutStream).flush();
                    succeed = true;
                }
                catch (IOException e) {
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    succeed = false;
                    if (bufOutStream != null) {
                        try {
                            bufOutStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (destOutStream != null) {
                        try {
                            ((OutputStream)destOutStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (is == null) break block33;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bufOutStream != null) {
                    try {
                        bufOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destOutStream != null) {
                    try {
                        ((OutputStream)destOutStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return succeed;
    }

    public static String copyFile(String srcFilePath, String srcFileName, String destPath) {
        File destFilePath = new File(destPath);
        File srcFile = new File(srcFilePath);
        if (destFilePath.isFile()) {
            return null;
        }
        if (!srcFile.exists() || srcFile.isDirectory()) {
            return null;
        }
        HashMap<Integer, File> pathMap = new HashMap<Integer, File>();
        try {
            int count;
            ThemeUtils.getAllDirFromDir(destPath, pathMap, false);
            int i = 0;
            while (i < pathMap.size()) {
                if (srcFileName.equals(((File)pathMap.get(i)).getName())) {
                    Date dt = new Date();
                    long sysTime = dt.getTime();
                    String prefixSrcFileName = ThemeUtils.getFileNameNoSuffix(srcFileName);
                    String suffixsrcFileName = ThemeUtils.getFileType(srcFileName);
                    srcFileName = String.valueOf(prefixSrcFileName) + "_" + Long.toString(sysTime) + "." + suffixsrcFileName;
                }
                ++i;
            }
            FileInputStream in = new FileInputStream(srcFilePath);
            FileOutputStream out = new FileOutputStream(String.valueOf(destPath) + srcFileName);
            byte[] bt = new byte[1024];
            while ((count = in.read(bt)) > 0) {
                out.write(bt, 0, count);
            }
            in.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return srcFileName;
    }

    public static float getDimension(String dimenValue, float parentDimen) {
        if (dimenValue != null && dimenValue.length() > 0) {
            if (dimenValue.contains("%")) {
                String[] valueArray = dimenValue.split("%");
                if (valueArray.length == 2) {
                    int witdh = 480;
                    int height = 800;
                    float ratio = ThemeUtils.getFloat(valueArray[0]) / 100.0f;
                    if (valueArray[1].equalsIgnoreCase("p")) {
                        return ratio * parentDimen;
                    }
                    if (valueArray[1].equalsIgnoreCase("w")) {
                        return ratio * (float)witdh;
                    }
                    if (valueArray[1].equalsIgnoreCase("h")) {
                        return ratio * (float)height;
                    }
                }
            } else {
                return ThemeUtils.getInt(dimenValue);
            }
        }
        return 0.0f;
    }

    public static void deleteDir(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                ThemeUtils.deleteDir(file);
            }
            ++n2;
        }
        dir.delete();
    }

    public static void deleteDir(String dirPath) {
        File dir = new File(dirPath);
        ThemeUtils.deleteDir(dir);
    }

    public static boolean forceDelete(File f) {
        boolean result = false;
        int tryCount = 0;
        while (!result && tryCount++ < 10) {
            System.gc();
            result = f.delete();
        }
        return result;
    }

    public static void folderReName(File srcFile, String dstFolderName) {
        String newFilePath = String.valueOf(srcFile.getParent()) + "\\" + dstFolderName;
        File newFile = new File(newFilePath);
        srcFile.renameTo(newFile);
    }

    private static void zipFile(File source, String basePath, ZipOutputStream zos) {
        File[] files = new File[]{};
        files = source.isDirectory() ? source.listFiles() : new File[]{source};
        byte[] buf = new byte[1024];
        int length = 0;
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String pathName;
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    pathName = String.valueOf(file.getParent().substring(basePath.length() + 1)) + "/";
                    zos.putNextEntry(new ZipEntry(pathName));
                    ThemeUtils.zipFile(file, basePath, zos);
                } else {
                    pathName = file.getPath().substring(basePath.length() + 1);
                    FileInputStream is = new FileInputStream(file);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    zos.putNextEntry(new ZipEntry(pathName));
                    while ((length = bis.read(buf)) > 0) {
                        zos.write(buf, 0, length);
                    }
                    ((InputStream)is).close();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unZip(String zipfile, String destDir) {
        destDir = destDir.endsWith("\\") ? destDir : String.valueOf(destDir) + "\\";
        byte[] b = new byte[1024];
        try {
            ZipFile zipFile = new ZipFile(new File(zipfile));
            Enumeration enumeration = zipFile.getEntries();
            ZipEntry zipEntry = null;
            while (enumeration.hasMoreElements()) {
                int length;
                zipEntry = (ZipEntry)enumeration.nextElement();
                File loadFile = new File(String.valueOf(destDir) + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    loadFile.mkdirs();
                    continue;
                }
                if (!loadFile.getParentFile().exists()) {
                    loadFile.getParentFile().mkdirs();
                }
                FileOutputStream outputStream = new FileOutputStream(loadFile);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                while ((length = inputStream.read(b)) > 0) {
                    ((OutputStream)outputStream).write(b, 0, length);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyAllFile(String path1, String path2, boolean cover) throws IOException {
        File f = new File(path1);
        if (f.isDirectory()) {
            File temp = new File(path2);
            if (!temp.isDirectory()) {
                temp.mkdirs();
            }
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    FileInputStream fi = new FileInputStream(files[i].toString());
                    File newFile = new File(String.valueOf(path2) + "\\" + files[i].getName());
                    if (!newFile.exists() || cover) {
                        FileOutputStream fo = new FileOutputStream(String.valueOf(path2) + "\\" + files[i].getName());
                        byte[] date = new byte[fi.available()];
                        fi.read(date);
                        fo.write(date);
                        fi.close();
                        fo.close();
                    }
                } else {
                    ThemeUtils.copyAllFile(files[i].toString(), String.valueOf(path2) + "\\" + files[i].getName(), cover);
                }
                ++i;
            }
        }
    }

    public static void copyFile(String oldPath, String newPath) {
        try {
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<File> getTTFFileFromDir() {
        File directory = new File("C:\\WINDOWS\\Fonts");
        File[] files = directory.listFiles();
        ArrayList<File> result = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            if (ThemeUtils.getFileType(files[i].getName()).equals("TTF")) {
                result.add(files[i]);
            }
            ++i;
        }
        return result;
    }

    public static int getIntFromFloat(float i) {
        return (int)((double)i + 0.5);
    }

    public static Dimension getScreenWidth() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static boolean unIlOrItZip(String zipfile, String destDir) {
        String fileTag = ThemeUtils.getFileType(zipfile);
        File oldfile = new File(zipfile);
        File newfile = new File(String.valueOf(ThemeUtils.getFileNameNoSuffix(zipfile)) + ".zip");
        oldfile.renameTo(newfile);
        ThemeUtils.unZip(String.valueOf(ThemeUtils.getFileNameNoSuffix(zipfile)) + ".zip", destDir);
        return fileTag == "Il";
    }

    public static boolean getBool(String value) {
        try {
            if (value != null) {
                return Boolean.getBoolean(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static int parseCode(String codeString) {
        int code = 0;
        if (codeString != null) {
            code = (codeString = codeString.toUpperCase()).startsWith("F") ? -(ThemeUtils.getInt(codeString.substring(1)) + 1000) : (codeString.startsWith("M") ? -ThemeUtils.getInt(codeString.substring(1)) : ThemeUtils.getInt(codeString));
        }
        return code;
    }

    public static String mergeStrings(String[] strs) {
        String result = null;
        if (strs.length >= 1) {
            result = strs[0];
        }
        int i = 1;
        while (i < strs.length) {
            result = String.valueOf(result) + "," + strs[i];
            ++i;
        }
        return result;
    }

    public static int getAlphaFromPercent(int percent) {
        return 255 + -254 * percent / 100;
    }

    public static int getPercentFromAlpha(int alpha) {
        return (alpha - 255) * 100 / -254;
    }
}

