/*
 * Decompiled with CFR 0.152.
 */
package com.iflytek.skintool.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class FileUtils {
    public static final int BUFFER_SIZE = 20480;
    public static final int KEY_LEN = 8;

    public static void saveObject(String fileName, Object object) {
        block35: {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    file.createNewFile();
                    fos = new FileOutputStream(file);
                    oos = new ObjectOutputStream(fos);
                    oos.writeObject(object);
                    oos.flush();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block35;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block35;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block35;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException3) {}
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static Object readObject(String fileName) {
        Object object;
        block42: {
            File f = new File(fileName);
            if (!f.exists()) {
                return null;
            }
            object = null;
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    ois = new ObjectInputStream(fis);
                    object = ois.readObject();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block42;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block42;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block42;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException3) {
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block42;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return object;
    }

    public static byte[] readByteArray(String fileName) {
        byte[] bytes;
        block13: {
            File f = new File(fileName);
            if (!f.exists()) {
                return null;
            }
            bytes = null;
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(f);
                    bytes = FileUtils.readByteArray(fis);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (fis == null) break block13;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bytes;
    }

    public static void writeByteArray(String fileName, byte[] bytes) {
        block21: {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            FileOutputStream fos = null;
            try {
                try {
                    file.createNewFile();
                    fos = new FileOutputStream(file);
                    fos.write(bytes);
                    fos.flush();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (fos == null) break block21;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    if (fos == null) break block21;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (fos == null) break block21;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static byte[] readByteArray(InputStream is) {
        byte[] bytes = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        try {
            try {
                int ch;
                while ((ch = is.read(tmp)) != -1) {
                    bos.write(tmp, 0, ch);
                }
                bytes = bos.toByteArray();
            }
            catch (IOException iOException) {
                try {
                    bos.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException iOException) {}
        }
        return bytes;
    }

    public static Object readObject(InputStream is) {
        Object object;
        block20: {
            object = null;
            ObjectInputStream ois = null;
            try {
                try {
                    ois = new ObjectInputStream(is);
                    object = ois.readObject();
                }
                catch (StreamCorruptedException streamCorruptedException) {
                    if (ois == null) break block20;
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (IOException iOException) {
                    if (ois == null) break block20;
                    try {
                        ois.close();
                    }
                    catch (IOException iOException2) {
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (ois == null) break block20;
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return object;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        FileUtils.deleteFile(file);
    }

    public static boolean deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                File[] fileArray = files = file.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File subFile = fileArray[n2];
                    if (subFile.isDirectory()) {
                        FileUtils.deleteFile(subFile);
                    } else {
                        subFile.delete();
                    }
                    ++n2;
                }
            }
            file.delete();
            return true;
        }
        return false;
    }

    public static String createFilePath(String dir, String name, String suffix) {
        String fileName = name;
        if (suffix != null) {
            fileName = fileName.concat(suffix);
        }
        if (dir != null) {
            if (!dir.endsWith(File.separator)) {
                dir = dir.concat(File.separator);
            }
            return dir.concat(fileName);
        }
        return fileName;
    }

    public static String getParentDirNameFromPath(String path) {
        int lastIndex = path.lastIndexOf(File.separator);
        if (lastIndex <= 0) {
            return null;
        }
        if ((lastIndex = (path = path.substring(0, lastIndex)).lastIndexOf(File.separator)) == -1) {
            return path;
        }
        return path.substring(lastIndex + 1);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath, boolean cover) {
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists()) {
            return false;
        }
        if (srcFile.isDirectory()) {
            if (!srcFilePath.endsWith(File.separator)) {
                srcFilePath = String.valueOf(srcFilePath) + File.separator;
            }
            if (!destFilePath.endsWith(File.separator)) {
                destFilePath = String.valueOf(destFilePath) + File.separator;
            }
            boolean ret = true;
            String[] stringArray = srcFile.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                ret = ret && FileUtils.copyFile(String.valueOf(srcFilePath) + filename, String.valueOf(destFilePath) + filename, cover);
                ++n2;
            }
            return ret;
        }
        return FileUtils.copyRealFile(srcFilePath, destFilePath, cover);
    }

    private static boolean copyRealFile(String srcFilePath, String destFilePath, boolean cover) {
        if (srcFilePath == null || destFilePath == null) {
            return false;
        }
        File srcFile = new File(srcFilePath);
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        try {
            File destFile = new File(destFilePath);
            if (srcFile.getCanonicalPath().equalsIgnoreCase(destFile.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException destFile) {
        }
        catch (NoSuchElementException e) {
            return true;
        }
        try {
            FileInputStream srcInStream = new FileInputStream(srcFile);
            return FileUtils.copyFile(srcInStream, destFilePath, cover);
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public static boolean copyFile(InputStream is, String destFilePath, boolean cover) {
        return FileUtils.copyFile(is, destFilePath, cover, true);
    }

    private static boolean copyFile(InputStream is, String destFilePath, boolean cover, boolean needCloseIs) {
        boolean succeed;
        block33: {
            if (is == null || destFilePath == null) {
                return false;
            }
            File destFile = new File(destFilePath);
            if (destFile.exists() && !cover) {
                return true;
            }
            File destParentFile = destFile.getParentFile();
            if (destParentFile != null && !destParentFile.exists()) {
                destParentFile.mkdirs();
            }
            succeed = false;
            FileOutputStream destOutStream = null;
            FilterOutputStream bufOutStream = null;
            try {
                try {
                    int count;
                    destOutStream = new FileOutputStream(destFile);
                    bufOutStream = new BufferedOutputStream(destOutStream);
                    byte[] buffer = new byte[20480];
                    while ((count = is.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufOutStream).write(buffer, 0, count);
                    }
                    ((BufferedOutputStream)bufOutStream).flush();
                    succeed = true;
                }
                catch (IOException e) {
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    succeed = false;
                    if (bufOutStream != null) {
                        try {
                            bufOutStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (destOutStream != null) {
                        try {
                            ((OutputStream)destOutStream).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (!needCloseIs || is == null) break block33;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (bufOutStream != null) {
                    try {
                        bufOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destOutStream != null) {
                    try {
                        ((OutputStream)destOutStream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (needCloseIs && is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return succeed;
    }

    public static String unZip(String sourceFile, String destDir, boolean cover) {
        return FileUtils.unZip(sourceFile, destDir, null, cover);
    }

    public static String unZip(String sourceFile, String destDir, String dirFilter, boolean cover) {
        destDir = destDir.endsWith(File.separator) ? destDir : destDir.concat(File.separator);
        ZipFile readZipFile = null;
        String result = null;
        try {
            try {
                readZipFile = new ZipFile(new File(sourceFile));
                Enumeration<? extends ZipEntry> enumeration = readZipFile.entries();
                boolean isFirst = true;
                String path = null;
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    String name = zipEntry.getName();
                    if (isFirst) {
                        int index = name.indexOf(File.separator);
                        path = index >= 0 ? name.substring(0, index) : name;
                        isFirst = false;
                    }
                    if (zipEntry.isDirectory() || dirFilter != null && name.contains(String.valueOf(path) + dirFilter)) continue;
                    String outFilePath = String.valueOf(destDir) + name;
                    FileUtils.copyFile(readZipFile.getInputStream(zipEntry), outFilePath, cover);
                }
                result = path;
            }
            catch (IOException e) {
                result = null;
                try {
                    if (readZipFile != null) {
                        readZipFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (readZipFile != null) {
                    readZipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static String byteCountToDisplaySize(int progress, int max) {
        char unit;
        double divider;
        if (max < 10) {
            divider = 1.0;
            unit = 'B';
        } else if (max < 0x100000) {
            divider = 1024.0;
            unit = 'K';
        } else {
            divider = 1048576.0;
            unit = 'M';
        }
        return String.format("%.2f" + unit + "/%.2f" + unit, (double)progress / divider, (double)max / divider);
    }

    public static String getExtendName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (-1 == index || index + 1 == fileName.length()) {
            return null;
        }
        return fileName.substring(index + 1);
    }

    public static String getMainName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (-1 == index || index + 1 == fileName.length()) {
            return null;
        }
        return fileName.substring(0, index);
    }

    public static String[] splitFileName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (-1 == index || index + 1 == fileName.length()) {
            return null;
        }
        String s1 = fileName.substring(0, index);
        String s2 = fileName.substring(index + 1);
        return new String[]{s1, s2};
    }

    public static String getFileNameFromPath(String path) {
        int index = path.lastIndexOf(File.separator);
        if (-1 == index || index + 1 == path.length()) {
            return null;
        }
        return path.substring(index + 1);
    }

    public static void iconWriteToFile(ImageIcon imageIcon, String filePath) {
        Image image = imageIcon.getImage();
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 5);
        try {
            ImageIO.write((RenderedImage)bi, "png", new File(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

